/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.nio;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.BufType;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.nio.NioUdtByteRendezvousChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.test.udt.nio.AbstractUdtTest;
import io.netty.test.udt.nio.NioUdtByteAcceptorChannelTest;
import io.netty.test.udt.nio.NioUdtMessageRendezvousChannelTest;
import io.netty.test.udt.util.EchoByteHandler;
import io.netty.test.udt.util.UnitHelp;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class NioUdtByteRendezvousChannelTest
extends AbstractUdtTest {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(NioUdtByteAcceptorChannelTest.class);

    @Test
    public void metadata() throws Exception {
        Assert.assertEquals((Object)BufType.BYTE, (Object)new NioUdtByteRendezvousChannel().metadata().bufferType());
    }

    @Test(timeout=10000L)
    public void basicEcho() throws Exception {
        int messageSize = 65536;
        int transferLimit = 0x100000;
        Meter rate1 = Metrics.newMeter(NioUdtMessageRendezvousChannelTest.class, (String)"send rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);
        Meter rate2 = Metrics.newMeter(NioUdtMessageRendezvousChannelTest.class, (String)"send rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);
        InetSocketAddress addr1 = UnitHelp.localSocketAddress();
        InetSocketAddress addr2 = UnitHelp.localSocketAddress();
        EchoByteHandler handler1 = new EchoByteHandler(rate1, 65536);
        EchoByteHandler handler2 = new EchoByteHandler(rate2, 65536);
        NioEventLoopGroup group1 = new NioEventLoopGroup(1, Executors.defaultThreadFactory(), NioUdtProvider.BYTE_PROVIDER);
        NioEventLoopGroup group2 = new NioEventLoopGroup(1, Executors.defaultThreadFactory(), NioUdtProvider.BYTE_PROVIDER);
        Bootstrap boot1 = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)boot1.group((EventLoopGroup)group1)).channelFactory(NioUdtProvider.BYTE_RENDEZVOUS)).localAddress((SocketAddress)addr1)).remoteAddress((SocketAddress)addr2).handler((ChannelHandler)handler1);
        Bootstrap boot2 = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)boot2.group((EventLoopGroup)group1)).channelFactory(NioUdtProvider.BYTE_RENDEZVOUS)).localAddress((SocketAddress)addr2)).remoteAddress((SocketAddress)addr1).handler((ChannelHandler)handler2);
        ChannelFuture connectFuture1 = boot1.connect();
        ChannelFuture connectFuture2 = boot2.connect();
        while (handler1.meter().count() < 0x100000L && handler2.meter().count() < 0x100000L) {
            log.info("progress : {} {}", (Object)handler1.meter().count(), (Object)handler2.meter().count());
            Thread.sleep(1000L);
        }
        connectFuture1.channel().close().sync();
        connectFuture2.channel().close().sync();
        log.info("handler1 : {}", (Object)handler1.meter().count());
        log.info("handler2 : {}", (Object)handler2.meter().count());
        Assert.assertTrue((handler1.meter().count() >= 0x100000L ? 1 : 0) != 0);
        Assert.assertTrue((handler2.meter().count() >= 0x100000L ? 1 : 0) != 0);
        Assert.assertEquals((long)handler1.meter().count(), (long)handler2.meter().count());
        group1.shutdownGracefully();
        group2.shutdownGracefully();
    }
}

