/*
 * Decompiled with CFR 0.152.
 */
package io.netty.test.udt.util;

import com.barchart.udt.SocketUDT;
import com.barchart.udt.StatusUDT;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class UnitHelp {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(UnitHelp.class);
    private static final Pattern SPACES = Pattern.compile("\\s+");

    public static boolean canLoadAndInitClass(String name) {
        try {
            Class.forName(name, true, UnitHelp.class.getClassLoader());
            log.info("Class load and init success.");
            return true;
        }
        catch (Throwable e) {
            log.warn("Class load or init failure.", e);
            return false;
        }
    }

    public static void clear(IntBuffer buffer) {
        for (int index = 0; index < buffer.capacity(); ++index) {
            buffer.put(index, 0);
        }
    }

    public static long ping(String host) throws Exception {
        String command;
        String name = System.getProperty("os.name").toLowerCase();
        if (name.contains("linux")) {
            command = "ping -c 1 " + host;
        } else if (name.contains("mac os x")) {
            command = "ping -c 1 " + host;
        } else if (name.contains("windows")) {
            command = "ping -n 1 " + host;
        } else {
            throw new Exception("unknown platform");
        }
        long timeStart = System.currentTimeMillis();
        UnitHelp.process(command);
        long timeFinish = System.currentTimeMillis();
        long timeDiff = timeFinish - timeStart;
        return timeDiff;
    }

    public static void process(String command) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(SPACES.split(command));
        Process process = builder.start();
        process.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized InetSocketAddress findLocalAddress(String host) {
        ServerSocket socket = null;
        try {
            InetAddress address = InetAddress.getByName(host);
            socket = new ServerSocket(0, 3, address);
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socket.getLocalSocketAddress();
            return inetSocketAddress;
        }
        catch (Exception e) {
            log.error("Failed to find addess.");
            InetSocketAddress inetSocketAddress = null;
            return inetSocketAddress;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    log.error("Failed to close socket.");
                }
            }
        }
    }

    public static InetSocketAddress hostedSocketAddress(String host) throws Exception {
        for (int k = 0; k < 10; ++k) {
            InetSocketAddress address = UnitHelp.findLocalAddress(host);
            if (address != null) {
                return address;
            }
            Thread.sleep(500L);
        }
        throw new Exception("Failed to allocate address.");
    }

    public static InetSocketAddress localSocketAddress() throws Exception {
        return UnitHelp.hostedSocketAddress("localhost");
    }

    public static void logBuffer(String title, IntBuffer buffer) {
        for (int index = 0; index < buffer.capacity(); ++index) {
            int value = buffer.get(index);
            if (value == 0) continue;
            log.info(String.format("%s [id: 0x%08x]", title, value));
        }
    }

    public static void logClassPath() {
        String classPath = System.getProperty("java.class.path");
        String[] entries = classPath.split(File.pathSeparator);
        StringBuilder text = new StringBuilder(1024);
        for (String item : entries) {
            text.append("\n\t");
            text.append(item);
        }
        log.info("\n\t[java.class.path]{}", (Object)text);
    }

    public static void logLibraryPath() {
        String classPath = System.getProperty("java.library.path");
        String[] entries = classPath.split(File.pathSeparator);
        StringBuilder text = new StringBuilder(1024);
        for (String item : entries) {
            text.append("\n\t");
            text.append(item);
        }
        log.info("\n\t[java.library.path]{}", (Object)text);
    }

    public static void logOsArch() {
        StringBuilder text = new StringBuilder(1024);
        text.append("\n\t");
        text.append(System.getProperty("os.name"));
        text.append("\n\t");
        text.append(System.getProperty("os.arch"));
        log.info("\n\t[os/arch]{}", (Object)text);
    }

    public static void logSet(Set<?> set) {
        TreeSet treeSet = new TreeSet(set);
        for (Object item : treeSet) {
            log.info("-> {}", item);
        }
    }

    public static String property(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            log.error("property '{}' not defined; terminating", (Object)name);
            System.exit(1);
        }
        return value;
    }

    public static int[] randomIntArray(int length, int range) {
        int[] array = new int[length];
        Random generator = new Random(0L);
        for (int i = 0; i < array.length; ++i) {
            array[i] = generator.nextInt(range);
        }
        return array;
    }

    public static String randomString() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String randomSuffix(String name) {
        return name + '-' + System.currentTimeMillis();
    }

    public static void socketAwait(SocketUDT socket, StatusUDT ... statusArray) throws Exception {
        block0: while (true) {
            StatusUDT[] statusUDTArray = statusArray;
            int n = statusUDTArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                StatusUDT status = statusUDTArray[n2];
                if (socket.status() == status) {
                    return;
                }
                Thread.sleep(50L);
                ++n2;
            }
            break;
        }
    }

    public static Set<Integer> socketIndexSet(IntBuffer buffer) {
        HashSet<Integer> set = new HashSet<Integer>();
        while (buffer.hasRemaining()) {
            set.add(buffer.get());
        }
        return set;
    }

    public static boolean socketPresent(SocketUDT socket, IntBuffer buffer) {
        for (int index = 0; index < buffer.capacity(); ++index) {
            if (buffer.get(index) != socket.id()) continue;
            return true;
        }
        return false;
    }

    private UnitHelp() {
    }
}

