/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.sctp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.channel.sctp.SctpMessage;
import java.util.HashMap;
import java.util.Map;

public class SctpMessageCompletionHandler
extends ChannelInboundMessageHandlerAdapter<SctpMessage> {
    private final Map<Integer, ByteBuf> fragments = new HashMap<Integer, ByteBuf>();
    private boolean assembled;

    public boolean beginMessageReceived(ChannelHandlerContext ctx) throws Exception {
        this.assembled = false;
        return super.beginMessageReceived(ctx);
    }

    public void endMessageReceived(ChannelHandlerContext ctx) throws Exception {
        if (this.assembled) {
            this.assembled = false;
            ctx.fireInboundBufferUpdated();
        }
        super.endMessageReceived(ctx);
    }

    public void messageReceived(ChannelHandlerContext ctx, SctpMessage msg) throws Exception {
        ByteBuf byteBuf = msg.data();
        int protocolIdentifier = msg.protocolIdentifier();
        int streamIdentifier = msg.streamIdentifier();
        boolean isComplete = msg.isComplete();
        ByteBuf frag = this.fragments.containsKey(streamIdentifier) ? this.fragments.remove(streamIdentifier) : Unpooled.EMPTY_BUFFER;
        if (isComplete && !frag.isReadable()) {
            this.handleAssembledMessage(ctx, msg);
        } else if (!isComplete && frag.isReadable()) {
            this.fragments.put(streamIdentifier, Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{frag, byteBuf}));
        } else if (isComplete && frag.isReadable()) {
            this.fragments.remove(streamIdentifier);
            SctpMessage assembledMsg = new SctpMessage(protocolIdentifier, streamIdentifier, Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{frag, byteBuf}));
            this.handleAssembledMessage(ctx, assembledMsg);
        } else {
            this.fragments.put(streamIdentifier, byteBuf);
        }
        byteBuf.retain();
    }

    private void handleAssembledMessage(ChannelHandlerContext ctx, SctpMessage assembledMsg) {
        ctx.nextInboundMessageBuffer().add((Object)assembledMsg);
        this.assembled = true;
    }
}

