/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.unix.LimitsStaticallyReferencedJniMethods;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Locale;

public final class Unix {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Unix.class);
    private static final Throwable UNAVAILABILITY_CAUSE;

    private static void loadNativeLibrary() {
        String name = SystemPropertyUtil.get((String)"os.name").toLowerCase(Locale.UK).trim();
        if (!(name.startsWith("linux") || name.startsWith("osx") || name.startsWith("mac") || name.endsWith("bsd"))) {
            throw new IllegalStateException("Only supported on Linux/MacOS/BSD");
        }
        String staticLibName = "netty_transport_native_unix";
        String sharedLibName = staticLibName + '_' + PlatformDependent.normalizedOs() + '_' + PlatformDependent.normalizedArch();
        ClassLoader cl = PlatformDependent.getClassLoader(Unix.class);
        try {
            NativeLibraryLoader.load((String)sharedLibName, (ClassLoader)cl);
        }
        catch (UnsatisfiedLinkError e1) {
            try {
                NativeLibraryLoader.load((String)staticLibName, (ClassLoader)cl);
                logger.debug("Failed to load {}", (Object)sharedLibName, (Object)e1);
            }
            catch (UnsatisfiedLinkError e2) {
                ThrowableUtil.addSuppressed((Throwable)e1, (Throwable)e2);
                throw e1;
            }
        }
    }

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    private Unix() {
    }

    static {
        Throwable cause = null;
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            try {
                LimitsStaticallyReferencedJniMethods.udsSunPathSize();
            }
            catch (UnsatisfiedLinkError ignore) {
                Unix.loadNativeLibrary();
            }
            finally {
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (IOException ignore) {}
            }
            Socket.initialize();
        }
        catch (Throwable error) {
            cause = error;
        }
        UNAVAILABILITY_CAUSE = cause;
    }
}

