/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.tests.SocketTest;
import io.netty.channel.unix.tests.UnixTestUtils;
import java.io.IOException;
import java.net.SocketAddress;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class KQueueSocketTest
extends SocketTest<BsdSocket> {
    @BeforeClass
    public static void loadJNI() {
        Assume.assumeTrue((boolean)KQueue.isAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerCreds() throws IOException {
        BsdSocket s1 = BsdSocket.newSocketDomain();
        BsdSocket s2 = BsdSocket.newSocketDomain();
        try {
            DomainSocketAddress dsa = UnixTestUtils.newSocketAddress();
            s1.bind((SocketAddress)dsa);
            s1.listen(1);
            Assert.assertTrue((boolean)s2.connect((SocketAddress)dsa));
            byte[] addr = new byte[64];
            s1.accept(addr);
            PeerCredentials pc = s1.getPeerCredentials();
            Assert.assertNotEquals((long)pc.uid(), (long)-1L);
        }
        finally {
            s1.close();
            s2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerPID() throws IOException {
        BsdSocket s1 = BsdSocket.newSocketDomain();
        BsdSocket s2 = BsdSocket.newSocketDomain();
        try {
            DomainSocketAddress dsa = UnixTestUtils.newSocketAddress();
            s1.bind((SocketAddress)dsa);
            s1.listen(1);
            Assert.assertEquals((long)0L, (long)s2.getPeerCredentials().pid());
            Assert.assertTrue((boolean)s2.connect((SocketAddress)dsa));
            byte[] addr = new byte[64];
            int clientFd = s1.accept(addr);
            Assert.assertNotEquals((long)-1L, (long)clientFd);
            PeerCredentials pc = new BsdSocket(clientFd).getPeerCredentials();
            Assert.assertNotEquals((long)0L, (long)pc.pid());
            Assert.assertNotEquals((long)0L, (long)s2.getPeerCredentials().pid());
            Assert.assertEquals((long)0L, (long)s1.getPeerCredentials().pid());
        }
        finally {
            s1.close();
            s2.close();
        }
    }

    protected BsdSocket newSocket() {
        return BsdSocket.newSocketStream();
    }
}

