/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KQueueChannelConfigTest {
    @Before
    public void before() {
        KQueue.ensureAvailability();
    }

    @Test
    public void testOptionGetThrowsChannelException() throws Exception {
        KQueueSocketChannel channel = new KQueueSocketChannel();
        channel.config().getSoLinger();
        channel.fd().close();
        try {
            channel.config().getSoLinger();
            Assert.fail();
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    @Test
    public void testOptionSetThrowsChannelException() throws Exception {
        KQueueSocketChannel channel = new KQueueSocketChannel();
        channel.config().setKeepAlive(true);
        channel.fd().close();
        try {
            channel.config().setKeepAlive(true);
            Assert.fail();
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSoLingerNoAssertError() throws Exception {
        KQueueEventLoopGroup group = new KQueueEventLoopGroup(1);
        try {
            Bootstrap bootstrap = new Bootstrap();
            KQueueSocketChannel ch = (KQueueSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(KQueueSocketChannel.class)).option(ChannelOption.SO_LINGER, (Object)10)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ch.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

