/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Random;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class KQueueSocketChannelConfigTest {
    private static EventLoopGroup group;
    private static KQueueSocketChannel ch;
    private static Random rand;

    @BeforeClass
    public static void beforeClass() {
        rand = new Random();
        group = new KQueueEventLoopGroup(1);
    }

    @AfterClass
    public static void afterClass() {
        group.shutdownGracefully();
    }

    @Before
    public void setup() {
        Bootstrap bootstrap = new Bootstrap();
        ch = (KQueueSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(KQueueSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
    }

    @After
    public void teardown() {
        ch.close().syncUninterruptibly();
    }

    @Test
    public void testRandomSndLowAt() {
        int actual;
        int expected = Math.min(BsdSocket.BSD_SND_LOW_AT_MAX, Math.abs(rand.nextInt()));
        try {
            ch.config().setSndLowAt(expected);
            actual = ch.config().getSndLowAt();
        }
        catch (RuntimeException e) {
            Assume.assumeNoException((Throwable)e);
            return;
        }
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testInvalidHighSndLowAt() {
        try {
            ch.config().setSndLowAt(Integer.MIN_VALUE);
        }
        catch (ChannelException e) {
            return;
        }
        catch (RuntimeException e) {
            Assume.assumeNoException((Throwable)e);
        }
        Assert.fail();
    }

    @Test
    public void testTcpNoPush() {
        ch.config().setTcpNoPush(false);
        Assert.assertFalse((boolean)ch.config().isTcpNoPush());
        ch.config().setTcpNoPush(true);
        Assert.assertTrue((boolean)ch.config().isTcpNoPush());
    }

    @Test
    public void testSetOptionWhenClosed() {
        ch.close().syncUninterruptibly();
        try {
            ch.config().setSoLinger(0);
            Assert.fail();
        }
        catch (ChannelException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ClosedChannelException));
        }
    }

    @Test
    public void testGetOptionWhenClosed() {
        ch.close().syncUninterruptibly();
        try {
            ch.config().getSoLinger();
            Assert.fail();
        }
        catch (ChannelException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ClosedChannelException));
        }
    }
}

