/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.testsuite.transport.AbstractSingleThreadEventLoopTest;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class EpollEventLoopTest
extends AbstractSingleThreadEventLoopTest {
    protected EventLoopGroup newEventLoopGroup() {
        return new EpollEventLoopGroup();
    }

    protected ServerSocketChannel newChannel() {
        return new EpollServerSocketChannel();
    }

    protected Class<? extends ServerChannel> serverChannelClass() {
        return EpollServerSocketChannel.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScheduleBigDelayNotOverflow() {
        final AtomicReference capture = new AtomicReference();
        EpollEventLoop group = new EpollEventLoop(null, (Executor)new ThreadPerTaskExecutor((ThreadFactory)new DefaultThreadFactory(((Object)((Object)this)).getClass())), 0, DefaultSelectStrategyFactory.INSTANCE.newSelectStrategy(), RejectedExecutionHandlers.reject(), null){

            @Override
            void handleLoopException(Throwable t) {
                capture.set(t);
                super.handleLoopException(t);
            }
        };
        try {
            EventLoop eventLoop = group.next();
            ScheduledFuture future = eventLoop.schedule(new Runnable(){

                @Override
                public void run() {
                }
            }, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            Assert.assertFalse((boolean)future.awaitUninterruptibly(1000L));
            Assert.assertTrue((boolean)future.cancel(true));
            Assert.assertNull(capture.get());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventFDETSemantics() throws Throwable {
        final FileDescriptor epoll = Native.newEpollCreate();
        final FileDescriptor eventFd = Native.newEventFd();
        final FileDescriptor timerFd = Native.newTimerFd();
        final EpollEventArray array = new EpollEventArray(1024);
        try {
            Native.epollCtlAdd(epoll.intValue(), eventFd.intValue(), Native.EPOLLIN | Native.EPOLLET);
            final AtomicReference causeRef = new AtomicReference();
            final AtomicInteger integer = new AtomicInteger();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 2; ++i) {
                            int ready = Native.epollWait(epoll, array, timerFd, -1, -1);
                            Assert.assertEquals((long)1L, (long)ready);
                            Assert.assertEquals((long)eventFd.intValue(), (long)array.fd(0));
                            integer.incrementAndGet();
                        }
                    }
                    catch (IOException e) {
                        causeRef.set(e);
                    }
                }
            });
            t.start();
            Native.eventFdWrite(eventFd.intValue(), 1L);
            while (integer.get() != 1) {
                Thread.sleep(10L);
            }
            Thread.sleep(1000L);
            Assert.assertEquals((long)1L, (long)integer.get());
            Native.eventFdWrite(eventFd.intValue(), 1L);
            t.join();
            Throwable cause = (Throwable)causeRef.get();
            if (cause != null) {
                throw cause;
            }
            Assert.assertEquals((long)2L, (long)integer.get());
        }
        finally {
            array.free();
            epoll.close();
            eventFd.close();
            timerFd.close();
        }
    }
}

