/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.tests.SocketTest;
import io.netty.channel.unix.tests.UnixTestUtils;
import java.io.IOException;
import java.net.SocketAddress;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class EpollSocketTest
extends SocketTest<LinuxSocket> {
    @BeforeClass
    public static void loadJNI() {
        Assume.assumeTrue((boolean)Epoll.isAvailable());
    }

    @Test
    public void testTcpCork() throws Exception {
        Assert.assertFalse((boolean)((LinuxSocket)this.socket).isTcpCork());
        ((LinuxSocket)this.socket).setTcpCork(true);
        Assert.assertTrue((boolean)((LinuxSocket)this.socket).isTcpCork());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerCreds() throws IOException {
        LinuxSocket s1 = LinuxSocket.newSocketDomain();
        LinuxSocket s2 = LinuxSocket.newSocketDomain();
        try {
            DomainSocketAddress dsa = UnixTestUtils.newSocketAddress();
            s1.bind((SocketAddress)dsa);
            s1.listen(1);
            Assert.assertTrue((boolean)s2.connect((SocketAddress)dsa));
            byte[] addr = new byte[64];
            s1.accept(addr);
            PeerCredentials pc = s1.getPeerCredentials();
            Assert.assertNotEquals((long)pc.uid(), (long)-1L);
        }
        finally {
            s1.close();
            s2.close();
        }
    }

    protected LinuxSocket newSocket() {
        return LinuxSocket.newSocketStream();
    }
}

