/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EpollServerSocketChannelConfigTest {
    private static EventLoopGroup group;
    private static EpollServerSocketChannel ch;

    @BeforeClass
    public static void before() {
        group = new EpollEventLoopGroup(1);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ch = (EpollServerSocketChannel)((ServerBootstrap)bootstrap.group(group).channel(EpollServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
    }

    @AfterClass
    public static void after() {
        try {
            ch.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testTcpDeferAccept() {
        ch.config().setTcpDeferAccept(0);
        Assert.assertEquals((long)0L, (long)ch.config().getTcpDeferAccept());
        ch.config().setTcpDeferAccept(10);
        Assert.assertTrue((10 <= ch.config().getTcpDeferAccept() ? 1 : 0) != 0);
    }

    @Test
    public void testReusePort() {
        ch.config().setReusePort(false);
        Assert.assertFalse((boolean)ch.config().isReusePort());
        ch.config().setReusePort(true);
        Assert.assertTrue((boolean)ch.config().isReusePort());
    }

    @Test
    public void testFreeBind() {
        ch.config().setFreeBind(false);
        Assert.assertFalse((boolean)ch.config().isFreeBind());
        ch.config().setFreeBind(true);
        Assert.assertTrue((boolean)ch.config().isFreeBind());
    }

    @Test
    public void getGetOptions() {
        Map<ChannelOption<?>, Object> map = ch.config().getOptions();
        Assert.assertFalse((boolean)map.isEmpty());
    }
}

