/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EpollSocketTcpMd5Test {
    private static final byte[] SERVER_KEY = "abc".getBytes(CharsetUtil.US_ASCII);
    private static final byte[] BAD_KEY = "def".getBytes(CharsetUtil.US_ASCII);
    private static EventLoopGroup GROUP;
    private EpollServerSocketChannel server;

    @BeforeClass
    public static void beforeClass() {
        GROUP = new EpollEventLoopGroup(1);
    }

    @AfterClass
    public static void afterClass() {
        GROUP.shutdownGracefully();
    }

    @Before
    public void setup() {
        Bootstrap bootstrap = new Bootstrap();
        this.server = (EpollServerSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(GROUP)).channel(EpollServerSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST4, 0)).syncUninterruptibly().channel();
    }

    @After
    public void teardown() {
        this.server.close().syncUninterruptibly();
    }

    @Test
    public void testServerSocketChannelOption() throws Exception {
        this.server.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY));
        this.server.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.emptyMap());
    }

    @Test
    public void testServerOption() throws Exception {
        Bootstrap bootstrap = new Bootstrap();
        EpollServerSocketChannel ch = (EpollServerSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(GROUP)).channel(EpollServerSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
        ch.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY));
        ch.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.emptyMap());
        ch.close().syncUninterruptibly();
    }

    @Test(expected=ConnectTimeoutException.class)
    public void testKeyMismatch() throws Exception {
        this.server.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY));
        EpollSocketChannel client = (EpollSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(GROUP)).channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).option(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, BAD_KEY))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000)).connect((SocketAddress)this.server.localAddress()).syncUninterruptibly().channel();
        client.close().syncUninterruptibly();
    }

    @Test
    public void testKeyMatch() throws Exception {
        this.server.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY));
        EpollSocketChannel client = (EpollSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(GROUP)).channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).option(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY))).connect((SocketAddress)this.server.localAddress()).syncUninterruptibly().channel();
        client.close().syncUninterruptibly();
    }
}

