/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.Random;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EpollSocketChannelConfigTest {
    private static EventLoopGroup group;
    private static EpollSocketChannel ch;
    private static Random rand;

    @BeforeClass
    public static void beforeClass() {
        rand = new Random();
        group = new EpollEventLoopGroup(1);
    }

    @AfterClass
    public static void afterClass() {
        group.shutdownGracefully();
    }

    @Before
    public void setup() {
        Bootstrap bootstrap = new Bootstrap();
        ch = (EpollSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
    }

    @After
    public void teardown() {
        ch.close().syncUninterruptibly();
    }

    private static long randLong(long min, long max) {
        return min + EpollSocketChannelConfigTest.nextLong(max - min + 1L);
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = rand.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Test
    public void testRandomTcpNotSentLowAt() {
        long actual;
        long expected = EpollSocketChannelConfigTest.randLong(0L, 0xFFFFFFFFL);
        try {
            ch.config().setTcpNotSentLowAt(expected);
            actual = ch.config().getTcpNotSentLowAt();
        }
        catch (RuntimeException e) {
            Assume.assumeNoException((Throwable)e);
            return;
        }
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testInvalidHighTcpNotSentLowAt() {
        try {
            long value = 0x100000000L;
            ch.config().setTcpNotSentLowAt(0x100000000L);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (RuntimeException e) {
            Assume.assumeNoException((Throwable)e);
        }
        Assert.fail();
    }

    @Test
    public void testInvalidLowTcpNotSentLowAt() {
        try {
            long value = -1L;
            ch.config().setTcpNotSentLowAt(-1L);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (RuntimeException e) {
            Assume.assumeNoException((Throwable)e);
        }
        Assert.fail();
    }

    @Test
    public void testTcpCork() {
        ch.config().setTcpCork(false);
        Assert.assertFalse((boolean)ch.config().isTcpCork());
        ch.config().setTcpCork(true);
        Assert.assertTrue((boolean)ch.config().isTcpCork());
    }

    @Test
    public void testTcpQickAck() {
        ch.config().setTcpQuickAck(false);
        Assert.assertFalse((boolean)ch.config().isTcpQuickAck());
        ch.config().setTcpQuickAck(true);
        Assert.assertTrue((boolean)ch.config().isTcpQuickAck());
    }

    @Test
    public void testSetOptionWhenClosed() {
        ch.close().syncUninterruptibly();
        try {
            ch.config().setSoLinger(0);
            Assert.fail();
        }
        catch (ChannelException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ClosedChannelException));
        }
    }

    @Test
    public void testGetOptionWhenClosed() {
        ch.close().syncUninterruptibly();
        try {
            ch.config().getSoLinger();
            Assert.fail();
        }
        catch (ChannelException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ClosedChannelException));
        }
    }

    @Test
    public void getGetOptions() {
        Map<ChannelOption<?>, Object> map = ch.config().getOptions();
        Assert.assertFalse((boolean)map.isEmpty());
    }
}

