/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.testsuite.transport.socket.DatagramUnicastTest;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.io.IOException;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import java.nio.channels.spi.SelectorProvider;
import org.junit.Assume;
import org.junit.BeforeClass;

public class DatagramUnicastIPv6Test
extends DatagramUnicastTest {
    @BeforeClass
    @SuppressJava6Requirement(reason="Guarded by java version check")
    public static void assumeIpv6Supported() {
        try {
            if (PlatformDependent.javaVersion() < 7) {
                throw new UnsupportedOperationException();
            }
            DatagramChannel channel = SelectorProvider.provider().openDatagramChannel(StandardProtocolFamily.INET6);
            channel.close();
        }
        catch (UnsupportedOperationException e) {
            Assume.assumeNoException((String)"IPv6 not supported", (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected InternetProtocolFamily internetProtocolFamily() {
        return InternetProtocolFamily.IPv6;
    }
}

