/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.testsuite.transport.socket.AbstractDatagramTest;
import io.netty.util.NetUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class DatagramUnicastTest
extends AbstractDatagramTest {
    private static final byte[] BYTES = new byte[]{0, 1, 2, 3};

    @Test
    public void testSimpleSendDirectByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendDirectByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), true, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), true, BYTES, 4);
    }

    @Test
    public void testSimpleSendHeapByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendHeapByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.buffer().writeBytes(BYTES), true, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.buffer().writeBytes(BYTES), true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeDirectByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendCompositeDirectByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeHeapByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendCompositeHeapByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeMixedByteBuf() throws Throwable {
        this.run();
    }

    public void testSimpleSendCompositeMixedByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendWithoutBind() throws Throwable {
        this.run();
    }

    public void testSimpleSendWithoutBind(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), false, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), false, BYTES, 4);
    }

    private void testSimpleSend(Bootstrap sb, Bootstrap cb, ByteBuf buf, boolean bindClient, byte[] bytes, int count) throws Throwable {
        for (WrapType type : WrapType.values()) {
            this.testSimpleSend0(sb, cb, buf.retain(), bindClient, bytes, count, type);
        }
        Assert.assertTrue((boolean)buf.release());
    }

    @Test
    public void testSimpleSendWithConnect() throws Throwable {
        this.run();
    }

    public void testSimpleSendWithConnect(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSendWithConnect(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), BYTES, 1);
        this.testSimpleSendWithConnect(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), BYTES, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSimpleSend0(Bootstrap sb, Bootstrap cb, ByteBuf buf, boolean bindClient, byte[] bytes, int count, WrapType wrapType) throws Throwable {
        Channel sc = null;
        Channel cc = null;
        try {
            SocketAddress sender;
            cb.handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                public void channelRead0(ChannelHandlerContext ctx, Object msgs) throws Exception {
                }
            });
            if (bindClient) {
                cc = cb.bind(this.newSocketAddress()).sync().channel();
                sender = cc.localAddress();
            } else {
                cb.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true);
                cc = cb.register().sync().channel();
                sender = null;
            }
            CountDownLatch latch = new CountDownLatch(count);
            AtomicReference<Throwable> errorRef = new AtomicReference<Throwable>();
            sc = this.setupServerChannel(sb, bytes, sender, latch, errorRef, false);
            InetSocketAddress addr = this.sendToAddress((InetSocketAddress)sc.localAddress());
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>(count);
            for (int i = 0; i < count; ++i) {
                futures.add(DatagramUnicastTest.write(cc, buf, addr, wrapType));
            }
            cc.flush();
            for (ChannelFuture future : futures) {
                future.sync();
            }
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                Throwable error = errorRef.get();
                if (error != null) {
                    throw error;
                }
                Assert.fail();
            }
        }
        catch (Throwable throwable) {
            buf.release();
            DatagramUnicastTest.closeChannel(cc);
            DatagramUnicastTest.closeChannel(sc);
            throw throwable;
        }
        buf.release();
        DatagramUnicastTest.closeChannel(cc);
        DatagramUnicastTest.closeChannel(sc);
    }

    private static ChannelFuture write(Channel cc, ByteBuf buf, InetSocketAddress remote, WrapType wrapType) {
        switch (wrapType) {
            case DUP: {
                return cc.write((Object)new DatagramPacket(buf.retainedDuplicate(), remote));
            }
            case SLICE: {
                return cc.write((Object)new DatagramPacket(buf.retainedSlice(), remote));
            }
            case READ_ONLY: {
                return cc.write((Object)new DatagramPacket(buf.retain().asReadOnly(), remote));
            }
            case NONE: {
                return cc.write((Object)new DatagramPacket(buf.retain(), remote));
            }
        }
        throw new Error("unknown wrap type: " + (Object)((Object)wrapType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSimpleSendWithConnect(Bootstrap sb, Bootstrap cb, ByteBuf buf, byte[] bytes, int count) throws Throwable {
        try {
            for (WrapType type : WrapType.values()) {
                this.testSimpleSendWithConnect0(sb, cb, buf.retain(), bytes, count, type);
            }
        }
        finally {
            Assert.assertTrue((boolean)buf.release());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSimpleSendWithConnect0(Bootstrap sb, Bootstrap cb, ByteBuf buf, final byte[] bytes, int count, WrapType wrapType) throws Throwable {
        final CountDownLatch clientLatch = new CountDownLatch(count);
        final AtomicReference clientErrorRef = new AtomicReference();
        cb.handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
                try {
                    ByteBuf buf = (ByteBuf)msg.content();
                    Assert.assertEquals((long)bytes.length, (long)buf.readableBytes());
                    for (int i = 0; i < bytes.length; ++i) {
                        Assert.assertEquals((long)bytes[i], (long)buf.getByte(buf.readerIndex() + i));
                    }
                    InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
                    if (localAddress.getAddress().isAnyLocalAddress()) {
                        Assert.assertEquals((long)localAddress.getPort(), (long)((InetSocketAddress)msg.recipient()).getPort());
                    } else {
                        Assert.assertEquals((Object)localAddress, (Object)msg.recipient());
                    }
                }
                finally {
                    clientLatch.countDown();
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                clientErrorRef.compareAndSet(null, cause);
            }
        });
        Channel sc = null;
        DatagramChannel cc = null;
        try {
            Throwable cause;
            CountDownLatch latch = new CountDownLatch(count);
            AtomicReference<Throwable> errorRef = new AtomicReference<Throwable>();
            cc = (DatagramChannel)cb.bind(this.newSocketAddress()).sync().channel();
            sc = this.setupServerChannel(sb, bytes, cc.localAddress(), latch, errorRef, true);
            cc.connect((SocketAddress)this.sendToAddress((InetSocketAddress)sc.localAddress())).syncUninterruptibly();
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
            for (int i = 0; i < count; ++i) {
                futures.add(DatagramUnicastTest.write((Channel)cc, buf, wrapType));
            }
            cc.flush();
            for (ChannelFuture future : futures) {
                future.sync();
            }
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                cause = errorRef.get();
                if (cause != null) {
                    throw cause;
                }
                Assert.fail();
            }
            if (!clientLatch.await(10L, TimeUnit.SECONDS)) {
                cause = (Throwable)clientErrorRef.get();
                if (cause != null) {
                    throw cause;
                }
                Assert.fail();
            }
            Assert.assertTrue((boolean)cc.isConnected());
            cc.disconnect().syncUninterruptibly();
            Assert.assertFalse((boolean)cc.isConnected());
            ChannelFuture future = cc.writeAndFlush((Object)buf.retain().duplicate()).awaitUninterruptibly();
            Assert.assertTrue((String)("NotYetConnectedException expected, got: " + future.cause()), (boolean)(future.cause() instanceof NotYetConnectedException));
        }
        catch (Throwable throwable) {
            buf.release();
            DatagramUnicastTest.closeChannel(cc);
            DatagramUnicastTest.closeChannel(sc);
            throw throwable;
        }
        buf.release();
        DatagramUnicastTest.closeChannel((Channel)cc);
        DatagramUnicastTest.closeChannel(sc);
    }

    private static ChannelFuture write(Channel cc, ByteBuf buf, WrapType wrapType) {
        switch (wrapType) {
            case DUP: {
                return cc.write((Object)buf.retainedDuplicate());
            }
            case SLICE: {
                return cc.write((Object)buf.retainedSlice());
            }
            case READ_ONLY: {
                return cc.write((Object)buf.retain().asReadOnly());
            }
            case NONE: {
                return cc.write((Object)buf.retain());
            }
        }
        throw new Error("unknown wrap type: " + (Object)((Object)wrapType));
    }

    private Channel setupServerChannel(Bootstrap sb, final byte[] bytes, final SocketAddress sender, final CountDownLatch latch, final AtomicReference<Throwable> errorRef, final boolean echo) throws Throwable {
        sb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DatagramPacket>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
                        try {
                            if (sender == null) {
                                Assert.assertNotNull((Object)msg.sender());
                            } else {
                                InetSocketAddress senderAddress = (InetSocketAddress)sender;
                                if (senderAddress.getAddress().isAnyLocalAddress()) {
                                    Assert.assertEquals((long)senderAddress.getPort(), (long)((InetSocketAddress)msg.sender()).getPort());
                                } else {
                                    Assert.assertEquals((Object)sender, (Object)msg.sender());
                                }
                            }
                            ByteBuf buf = (ByteBuf)msg.content();
                            Assert.assertEquals((long)bytes.length, (long)buf.readableBytes());
                            for (int i = 0; i < bytes.length; ++i) {
                                Assert.assertEquals((long)bytes[i], (long)buf.getByte(buf.readerIndex() + i));
                            }
                            Assert.assertEquals((Object)ctx.channel().localAddress(), (Object)msg.recipient());
                            if (echo) {
                                ctx.writeAndFlush((Object)new DatagramPacket(buf.retainedDuplicate(), (InetSocketAddress)msg.sender()));
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        errorRef.compareAndSet(null, cause);
                    }
                }});
            }
        });
        return sb.bind(this.newSocketAddress()).sync().channel();
    }

    private static void closeChannel(Channel channel) throws Exception {
        if (channel != null) {
            channel.close().sync();
        }
    }

    protected InetSocketAddress sendToAddress(InetSocketAddress serverAddress) {
        InetAddress addr = serverAddress.getAddress();
        if (addr.isAnyLocalAddress()) {
            if (addr instanceof Inet6Address) {
                return new InetSocketAddress(NetUtil.LOCALHOST6, serverAddress.getPort());
            }
            return new InetSocketAddress(NetUtil.LOCALHOST4, serverAddress.getPort());
        }
        return serverAddress;
    }

    private static enum WrapType {
        NONE,
        DUP,
        SLICE,
        READ_ONLY;

    }
}

