/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SocketSslGreetingTest
extends AbstractSocketTest {
    private static final InternalLogger logger;
    private static final LogLevel LOG_LEVEL;
    private static final File CERT_FILE;
    private static final File KEY_FILE;
    private final ByteBuf greeting = (ByteBuf)ReferenceCountUtil.releaseLater((Object)Unpooled.buffer().writeByte(97));
    private final SslContext serverCtx;
    private final SslContext clientCtx;

    @Parameterized.Parameters(name="{index}: serverEngine = {0}, clientEngine = {1}")
    public static Collection<Object[]> data() throws Exception {
        ArrayList<SslContext> serverContexts = new ArrayList<SslContext>();
        serverContexts.add(SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.JDK).build());
        ArrayList<SslContext> clientContexts = new ArrayList<SslContext>();
        clientContexts.add(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(CERT_FILE).build());
        boolean hasOpenSsl = OpenSsl.isAvailable();
        if (hasOpenSsl) {
            serverContexts.add(SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.OPENSSL).build());
            clientContexts.add(SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(CERT_FILE).build());
        } else {
            logger.warn("OpenSSL is unavailable and thus will not be tested.", OpenSsl.unavailabilityCause());
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslContext sc : serverContexts) {
            for (SslContext cc : clientContexts) {
                params.add(new Object[]{sc, cc});
            }
        }
        return params;
    }

    public SocketSslGreetingTest(SslContext serverCtx, SslContext clientCtx) {
        this.serverCtx = serverCtx;
        this.clientCtx = clientCtx;
    }

    @Test(timeout=30000L)
    public void testSslGreeting() throws Throwable {
        this.run();
    }

    public void testSslGreeting(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final ServerHandler sh = new ServerHandler();
        final ClientHandler ch = new ClientHandler();
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                ChannelPipeline p = sch.pipeline();
                p.addLast(new ChannelHandler[]{SocketSslGreetingTest.this.serverCtx.newHandler(sch.alloc())});
                p.addLast(new ChannelHandler[]{new LoggingHandler(LOG_LEVEL)});
                p.addLast(new ChannelHandler[]{sh});
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                ChannelPipeline p = sch.pipeline();
                p.addLast(new ChannelHandler[]{SocketSslGreetingTest.this.clientCtx.newHandler(sch.alloc())});
                p.addLast(new ChannelHandler[]{new LoggingHandler(LOG_LEVEL)});
                p.addLast(new ChannelHandler[]{ch});
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        ch.latch.await();
        sh.channel.close().awaitUninterruptibly();
        cc.close().awaitUninterruptibly();
        sc.close().awaitUninterruptibly();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        SelfSignedCertificate ssc;
        logger = InternalLoggerFactory.getInstance(SocketSslGreetingTest.class);
        LOG_LEVEL = LogLevel.TRACE;
        try {
            ssc = new SelfSignedCertificate();
        }
        catch (CertificateException e) {
            throw new Error(e);
        }
        CERT_FILE = ssc.certificate();
        KEY_FILE = ssc.privateKey();
    }

    private class ServerHandler
    extends SimpleChannelInboundHandler<String> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();

        private ServerHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
            this.channel.writeAndFlush((Object)SocketSslGreetingTest.this.greeting.retainedDuplicate());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the server side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            SslHandshakeCompletionEvent event;
            if (evt instanceof SslHandshakeCompletionEvent && (event = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                SSLSession session = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                try {
                    session.getPeerCertificates();
                    Assert.fail();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
                try {
                    session.getPeerCertificateChain();
                    Assert.fail();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
                try {
                    session.getPeerPrincipal();
                    Assert.fail();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    private class ClientHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        final AtomicReference<Throwable> exception = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);

        private ClientHandler() {
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
            Assert.assertEquals((Object)SocketSslGreetingTest.this.greeting, (Object)buf);
            this.latch.countDown();
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the client side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }
}

