/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.JdkSslClientContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.nio.channels.ClosedChannelException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLHandshakeException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SocketSslClientRenegotiateTest
extends AbstractSocketTest {
    private static final InternalLogger logger;
    private static final File CERT_FILE;
    private static final File KEY_FILE;
    private final SslContext serverCtx;
    private final SslContext clientCtx;
    private final boolean delegate;
    private final AtomicReference<Throwable> clientException = new AtomicReference();
    private final AtomicReference<Throwable> serverException = new AtomicReference();
    private volatile Channel clientChannel;
    private volatile Channel serverChannel;
    private volatile SslHandler clientSslHandler;
    private volatile SslHandler serverSslHandler;
    private final TestHandler clientHandler = new TestHandler(this.clientException);
    private final TestHandler serverHandler = new TestHandler(this.serverException);

    @Parameterized.Parameters(name="{index}: serverEngine = {0}, clientEngine = {1}, delegate = {2}")
    public static Collection<Object[]> data() throws Exception {
        ArrayList<OpenSslServerContext> serverContexts = new ArrayList<OpenSslServerContext>();
        ArrayList<JdkSslClientContext> clientContexts = new ArrayList<JdkSslClientContext>();
        clientContexts.add(new JdkSslClientContext(CERT_FILE));
        boolean hasOpenSsl = OpenSsl.isAvailable();
        if (hasOpenSsl) {
            OpenSslServerContext context = new OpenSslServerContext(CERT_FILE, KEY_FILE);
            serverContexts.add(context);
        } else {
            logger.warn("OpenSSL is unavailable and thus will not be tested.", OpenSsl.unavailabilityCause());
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslContext sslContext : serverContexts) {
            for (SslContext sslContext2 : clientContexts) {
                for (int i = 0; i < 32; ++i) {
                    params.add(new Object[]{sslContext, sslContext2, true});
                    params.add(new Object[]{sslContext, sslContext2, false});
                }
            }
        }
        return params;
    }

    public SocketSslClientRenegotiateTest(SslContext serverCtx, SslContext clientCtx, boolean delegate) {
        this.serverCtx = serverCtx;
        this.clientCtx = clientCtx;
        this.delegate = delegate;
    }

    @Test(timeout=30000L)
    public void testSslRenegotiationRejected() throws Throwable {
        Assume.assumeFalse((boolean)"BoringSSL".equals(OpenSsl.versionString()));
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        this.run();
    }

    private static SslHandler newSslHandler(SslContext sslCtx, ByteBufAllocator allocator, Executor executor) {
        if (executor == null) {
            return sslCtx.newHandler(allocator);
        }
        return sslCtx.newHandler(allocator, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSslRenegotiationRejected(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.reset();
        final ExecutorService executorService = this.delegate ? Executors.newCachedThreadPool() : null;
        try {
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel sch) throws Exception {
                    SocketSslClientRenegotiateTest.this.serverChannel = sch;
                    SocketSslClientRenegotiateTest.this.serverSslHandler = SocketSslClientRenegotiateTest.newSslHandler(SocketSslClientRenegotiateTest.this.serverCtx, sch.alloc(), executorService);
                    SocketSslClientRenegotiateTest.this.serverSslHandler.engine().setEnabledProtocols(new String[]{"TLSv1.2"});
                    sch.pipeline().addLast("ssl", (ChannelHandler)SocketSslClientRenegotiateTest.this.serverSslHandler);
                    sch.pipeline().addLast("handler", (ChannelHandler)SocketSslClientRenegotiateTest.this.serverHandler);
                }
            });
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel sch) throws Exception {
                    SocketSslClientRenegotiateTest.this.clientChannel = sch;
                    SocketSslClientRenegotiateTest.this.clientSslHandler = SocketSslClientRenegotiateTest.newSslHandler(SocketSslClientRenegotiateTest.this.clientCtx, sch.alloc(), executorService);
                    SocketSslClientRenegotiateTest.this.clientSslHandler.engine().setEnabledProtocols(new String[]{"TLSv1.2"});
                    sch.pipeline().addLast("ssl", (ChannelHandler)SocketSslClientRenegotiateTest.this.clientSslHandler);
                    sch.pipeline().addLast("handler", (ChannelHandler)SocketSslClientRenegotiateTest.this.clientHandler);
                }
            });
            Channel sc = sb.bind().sync().channel();
            cb.connect(sc.localAddress()).sync();
            Future clientHandshakeFuture = this.clientSslHandler.handshakeFuture();
            clientHandshakeFuture.sync();
            String renegotiation = this.clientSslHandler.engine().getEnabledCipherSuites()[0];
            this.clientSslHandler.engine().setEnabledCipherSuites(new String[]{renegotiation});
            this.clientSslHandler.renegotiate().await();
            this.serverChannel.close().awaitUninterruptibly();
            this.clientChannel.close().awaitUninterruptibly();
            sc.close().awaitUninterruptibly();
            try {
                if (this.serverException.get() != null) {
                    throw this.serverException.get();
                }
                Assert.fail();
            }
            catch (DecoderException e) {
                Assert.assertTrue((boolean)(e.getCause() instanceof SSLHandshakeException));
            }
            if (this.clientException.get() != null) {
                throw this.clientException.get();
            }
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
        }
    }

    private void reset() {
        this.clientException.set(null);
        this.serverException.set(null);
        this.clientHandler.handshakeCounter = 0;
        this.serverHandler.handshakeCounter = 0;
        this.clientChannel = null;
        this.serverChannel = null;
        this.clientSslHandler = null;
        this.serverSslHandler = null;
    }

    static {
        SelfSignedCertificate ssc;
        logger = InternalLoggerFactory.getInstance(SocketSslClientRenegotiateTest.class);
        try {
            ssc = new SelfSignedCertificate();
        }
        catch (CertificateException e) {
            throw new Error(e);
        }
        CERT_FILE = ssc.certificate();
        KEY_FILE = ssc.privateKey();
    }

    @ChannelHandler.Sharable
    private static final class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        protected final AtomicReference<Throwable> exception;
        private int handshakeCounter;

        TestHandler(AtomicReference<Throwable> exception) {
            this.exception = exception;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvt = (SslHandshakeCompletionEvent)evt;
                if (this.handshakeCounter == 0) {
                    ++this.handshakeCounter;
                    if (handshakeEvt.cause() != null) {
                        logger.warn("Handshake failed:", handshakeEvt.cause());
                    }
                    Assert.assertSame((Object)SslHandshakeCompletionEvent.SUCCESS, (Object)evt);
                } else if (ctx.channel().parent() == null) {
                    Assert.assertTrue((boolean)(handshakeEvt.cause() instanceof ClosedChannelException));
                }
            }
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        }
    }
}

