/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.udt;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTClientServerConnectionTest {
    static final Logger log = LoggerFactory.getLogger(UDTClientServerConnectionTest.class);
    static final int WAIT_COUNT = 50;
    static final int WAIT_SLEEP = 100;

    @Test
    public void connection() throws Exception {
        Assume.assumeFalse((String)"Not supported on J9 JVM", (boolean)PlatformDependent.isJ9Jvm());
        log.info("Starting server.");
        Server server = new Server(new InetSocketAddress(NetUtil.LOCALHOST4, 0));
        Thread serverTread = new Thread((Runnable)server, "server-*");
        serverTread.start();
        server.waitForRunning(true);
        Assert.assertTrue((boolean)server.isRunning);
        log.info("Starting client.");
        Client client = new Client((InetSocketAddress)server.channel.localAddress());
        Thread clientThread = new Thread((Runnable)client, "client-*");
        clientThread.start();
        client.waitForRunning(true);
        Assert.assertTrue((boolean)client.isRunning);
        log.info("Wait till connection is active.");
        client.waitForActive(true);
        server.waitForActive(true);
        log.info("Verify connection is active.");
        Assert.assertEquals((String)"group must have one", (long)1L, (long)server.group.size());
        log.info("Stopping client.");
        client.shutdown();
        client.waitForShutdown();
        Assert.assertTrue((boolean)client.isShutdown);
        log.info("Wait till connection is inactive.");
        client.waitForActive(false);
        server.waitForActive(false);
        log.info("Verify connection is inactive.");
        Assert.assertEquals((String)"group must be empty", (long)0L, (long)server.group.size());
        log.info("Stopping server.");
        server.shutdown();
        server.waitForShutdown();
        Assert.assertTrue((boolean)server.isShutdown);
        log.info("Finished server.");
    }

    static class ServerHandler
    extends SimpleChannelInboundHandler<Object> {
        static final Logger log = LoggerFactory.getLogger(ServerHandler.class);
        final ChannelGroup group;
        volatile boolean isActive;

        ServerHandler(ChannelGroup group) {
            this.group = group;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.group.add((Object)ctx.channel());
            this.isActive = true;
            log.info("Server active  : {}", (Object)ctx.channel());
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.group.remove((Object)ctx.channel());
            this.isActive = false;
            log.info("Server inactive: {}", (Object)ctx.channel());
            super.channelInactive(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.warn("Server close on exception.", cause);
            ctx.close();
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            log.info("Server received: " + msg);
        }
    }

    static class Server
    implements Runnable {
        static final Logger log = LoggerFactory.getLogger(Server.class);
        final ChannelGroup group = new DefaultChannelGroup("server group", (EventExecutor)GlobalEventExecutor.INSTANCE);
        private final InetSocketAddress address;
        volatile Channel channel;
        volatile boolean isRunning;
        volatile boolean isShutdown;

        Server(InetSocketAddress address) {
            this.address = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerBootstrap boot = new ServerBootstrap();
            DefaultThreadFactory acceptFactory = new DefaultThreadFactory("accept");
            DefaultThreadFactory serverFactory = new DefaultThreadFactory("server");
            NioEventLoopGroup acceptGroup = new NioEventLoopGroup(1, (ThreadFactory)acceptFactory, NioUdtProvider.BYTE_PROVIDER);
            NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ThreadFactory)serverFactory, NioUdtProvider.BYTE_PROVIDER);
            try {
                ((ServerBootstrap)boot.group((EventLoopGroup)acceptGroup, (EventLoopGroup)connectGroup).channelFactory(NioUdtProvider.BYTE_ACCEPTOR)).childHandler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                    protected void initChannel(UdtChannel ch) throws Exception {
                        ChannelPipeline pipeline = ch.pipeline();
                        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter()));
                        pipeline.addLast("decoder", (ChannelHandler)new StringDecoder(CharsetUtil.UTF_8));
                        pipeline.addLast("encoder", (ChannelHandler)new StringEncoder(CharsetUtil.UTF_8));
                        pipeline.addLast("handler", (ChannelHandler)new ServerHandler(Server.this.group));
                    }
                });
                this.channel = boot.bind((SocketAddress)this.address).sync().channel();
                this.isRunning = true;
                log.info("Server ready.");
                this.waitForRunning(false);
                log.info("Server closing acceptor...");
                this.channel.close().sync();
                log.info("Server closing connectors...");
                this.group.close().sync();
                this.isShutdown = true;
                log.info("Server is done.");
            }
            catch (Throwable e) {
                log.error("Server failure.", e);
            }
            finally {
                acceptGroup.shutdownGracefully();
                connectGroup.shutdownGracefully();
                acceptGroup.terminationFuture().syncUninterruptibly();
                connectGroup.terminationFuture().syncUninterruptibly();
            }
        }

        void shutdown() {
            this.isRunning = false;
        }

        void waitForActive(boolean isActive) throws Exception {
            for (int k = 0; k < 50; ++k) {
                Thread.sleep(100L);
                if (isActive) {
                    for (Channel channel : this.group) {
                        ServerHandler handler = (ServerHandler)channel.pipeline().get(ServerHandler.class);
                        if (handler == null || !handler.isActive) continue;
                        return;
                    }
                    continue;
                }
                if (!this.group.isEmpty()) continue;
                return;
            }
        }

        void waitForRunning(boolean isRunning) throws Exception {
            for (int k = 0; k < 50; ++k) {
                if (isRunning == this.isRunning) {
                    return;
                }
                Thread.sleep(100L);
            }
        }

        void waitForShutdown() throws Exception {
            for (int k = 0; k < 50; ++k) {
                if (this.isShutdown) {
                    return;
                }
                Thread.sleep(100L);
            }
        }
    }

    static class ClientHandler
    extends SimpleChannelInboundHandler<Object> {
        static final Logger log = LoggerFactory.getLogger(ClientHandler.class);
        volatile boolean isActive;

        ClientHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.isActive = true;
            log.info("Client active {}", (Object)ctx.channel());
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.isActive = false;
            log.info("Client inactive {}", (Object)ctx.channel());
            super.channelInactive(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            log.warn("Client unexpected exception from downstream.", cause);
            ctx.close();
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            log.info("Client received: " + msg);
        }
    }

    static class Client
    implements Runnable {
        static final Logger log = LoggerFactory.getLogger(Client.class);
        private final InetSocketAddress address;
        volatile Channel channel;
        volatile boolean isRunning;
        volatile boolean isShutdown;

        Client(InetSocketAddress address) {
            this.address = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Bootstrap boot = new Bootstrap();
            DefaultThreadFactory clientFactory = new DefaultThreadFactory("client");
            NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ThreadFactory)clientFactory, NioUdtProvider.BYTE_PROVIDER);
            try {
                ((Bootstrap)((Bootstrap)boot.group((EventLoopGroup)connectGroup)).channelFactory(NioUdtProvider.BYTE_CONNECTOR)).handler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                    protected void initChannel(UdtChannel ch) throws Exception {
                        ChannelPipeline pipeline = ch.pipeline();
                        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter()));
                        pipeline.addLast("decoder", (ChannelHandler)new StringDecoder(CharsetUtil.UTF_8));
                        pipeline.addLast("encoder", (ChannelHandler)new StringEncoder(CharsetUtil.UTF_8));
                        pipeline.addLast("handler", (ChannelHandler)new ClientHandler());
                    }
                });
                this.channel = boot.connect((SocketAddress)this.address).sync().channel();
                this.isRunning = true;
                log.info("Client ready.");
                this.waitForRunning(false);
                log.info("Client closing...");
                this.channel.close().sync();
                this.isShutdown = true;
                log.info("Client is done.");
            }
            catch (Throwable e) {
                log.error("Client failed.", e);
            }
            finally {
                connectGroup.shutdownGracefully().syncUninterruptibly();
            }
        }

        void shutdown() {
            this.isRunning = false;
        }

        void waitForActive(boolean isActive) throws Exception {
            for (int k = 0; k < 50; ++k) {
                Thread.sleep(100L);
                ClientHandler handler = (ClientHandler)this.channel.pipeline().get(ClientHandler.class);
                if (handler == null || isActive != handler.isActive) continue;
                return;
            }
        }

        void waitForRunning(boolean isRunning) throws Exception {
            for (int k = 0; k < 50; ++k) {
                if (isRunning == this.isRunning) {
                    return;
                }
                Thread.sleep(100L);
            }
        }

        private void waitForShutdown() throws Exception {
            for (int k = 0; k < 50; ++k) {
                if (this.isShutdown) {
                    return;
                }
                Thread.sleep(100L);
            }
        }
    }
}

