/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SocketSslEchoTest
extends AbstractSocketTest {
    private static final InternalLogger logger;
    private static final int FIRST_MESSAGE_SIZE = 16384;
    private static final Random random;
    private static final File CERT_FILE;
    private static final File KEY_FILE;
    static final byte[] data;
    private final SslContext serverCtx;
    private final SslContext clientCtx;
    private final Renegotiation renegotiation;
    private final boolean serverUsesDelegatedTaskExecutor;
    private final boolean clientUsesDelegatedTaskExecutor;
    private final boolean autoRead;
    private final boolean useChunkedWriteHandler;
    private final boolean useCompositeByteBuf;
    private final AtomicReference<Throwable> clientException = new AtomicReference();
    private final AtomicReference<Throwable> serverException = new AtomicReference();
    private final AtomicInteger clientSendCounter = new AtomicInteger();
    private final AtomicInteger clientRecvCounter = new AtomicInteger();
    private final AtomicInteger serverRecvCounter = new AtomicInteger();
    private final AtomicInteger clientNegoCounter = new AtomicInteger();
    private final AtomicInteger serverNegoCounter = new AtomicInteger();
    private volatile Channel clientChannel;
    private volatile Channel serverChannel;
    private volatile SslHandler clientSslHandler;
    private volatile SslHandler serverSslHandler;
    private final EchoClientHandler clientHandler = new EchoClientHandler(this.clientRecvCounter, this.clientNegoCounter, this.clientException);
    private final EchoServerHandler serverHandler = new EchoServerHandler(this.serverRecvCounter, this.serverNegoCounter, this.serverException);

    @Parameterized.Parameters(name="{index}: serverEngine = {0}, clientEngine = {1}, renegotiation = {2}, serverUsesDelegatedTaskExecutor = {3}, clientUsesDelegatedTaskExecutor = {4}, autoRead = {5}, useChunkedWriteHandler = {6}, useCompositeByteBuf = {7}")
    public static Collection<Object[]> data() throws Exception {
        ArrayList<SslContext> serverContexts = new ArrayList<SslContext>();
        serverContexts.add(SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.JDK).build());
        ArrayList<SslContext> clientContexts = new ArrayList<SslContext>();
        clientContexts.add(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(CERT_FILE).build());
        boolean hasOpenSsl = OpenSsl.isAvailable();
        if (hasOpenSsl) {
            serverContexts.add(SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.OPENSSL).build());
            clientContexts.add(SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(CERT_FILE).build());
        } else {
            logger.warn("OpenSSL is unavailable and thus will not be tested.", OpenSsl.unavailabilityCause());
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslContext sc : serverContexts) {
            for (SslContext cc : clientContexts) {
                for (RenegotiationType rt : RenegotiationType.values()) {
                    if (rt != RenegotiationType.NONE && (sc instanceof OpenSslContext || cc instanceof OpenSslContext)) continue;
                    Renegotiation r = rt == RenegotiationType.NONE ? Renegotiation.NONE : new Renegotiation(rt, "SSL_RSA_WITH_3DES_EDE_CBC_SHA");
                    for (int i = 0; i < 32; ++i) {
                        params.add(new Object[]{sc, cc, r, (i & 0x10) != 0, (i & 8) != 0, (i & 4) != 0, (i & 2) != 0, (i & 1) != 0});
                    }
                }
            }
        }
        return params;
    }

    public SocketSslEchoTest(SslContext serverCtx, SslContext clientCtx, Renegotiation renegotiation, boolean serverUsesDelegatedTaskExecutor, boolean clientUsesDelegatedTaskExecutor, boolean autoRead, boolean useChunkedWriteHandler, boolean useCompositeByteBuf) {
        this.serverCtx = serverCtx;
        this.clientCtx = clientCtx;
        this.serverUsesDelegatedTaskExecutor = serverUsesDelegatedTaskExecutor;
        this.clientUsesDelegatedTaskExecutor = clientUsesDelegatedTaskExecutor;
        this.renegotiation = renegotiation;
        this.autoRead = autoRead;
        this.useChunkedWriteHandler = useChunkedWriteHandler;
        this.useCompositeByteBuf = useCompositeByteBuf;
    }

    @Test(timeout=30000L)
    public void testSslEcho() throws Throwable {
        this.run();
    }

    @AfterClass
    public static void compressHeapDumps() throws Exception {
        TestUtils.compressHeapDumps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSslEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final ExecutorService delegatedTaskExecutor = Executors.newCachedThreadPool();
        this.reset();
        sb.childOption(ChannelOption.AUTO_READ, (Object)this.autoRead);
        cb.option(ChannelOption.AUTO_READ, (Object)this.autoRead);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                SocketSslEchoTest.this.serverChannel = sch;
                if (SocketSslEchoTest.this.serverUsesDelegatedTaskExecutor) {
                    SSLEngine sse = SocketSslEchoTest.this.serverCtx.newEngine(sch.alloc());
                    SocketSslEchoTest.this.serverSslHandler = new SslHandler(sse, (Executor)delegatedTaskExecutor);
                } else {
                    SocketSslEchoTest.this.serverSslHandler = SocketSslEchoTest.this.serverCtx.newHandler(sch.alloc());
                }
                sch.pipeline().addLast("ssl", (ChannelHandler)SocketSslEchoTest.this.serverSslHandler);
                if (SocketSslEchoTest.this.useChunkedWriteHandler) {
                    sch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                }
                sch.pipeline().addLast("handler", (ChannelHandler)SocketSslEchoTest.this.serverHandler);
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                SocketSslEchoTest.this.clientChannel = sch;
                if (SocketSslEchoTest.this.clientUsesDelegatedTaskExecutor) {
                    SSLEngine cse = SocketSslEchoTest.this.clientCtx.newEngine(sch.alloc());
                    SocketSslEchoTest.this.clientSslHandler = new SslHandler(cse, (Executor)delegatedTaskExecutor);
                } else {
                    SocketSslEchoTest.this.clientSslHandler = SocketSslEchoTest.this.clientCtx.newHandler(sch.alloc());
                }
                sch.pipeline().addLast("ssl", (ChannelHandler)SocketSslEchoTest.this.clientSslHandler);
                if (SocketSslEchoTest.this.useChunkedWriteHandler) {
                    sch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                }
                sch.pipeline().addLast("handler", (ChannelHandler)SocketSslEchoTest.this.clientHandler);
            }
        });
        Channel sc = sb.bind().sync().channel();
        cb.connect().sync();
        Future clientHandshakeFuture = this.clientSslHandler.handshakeFuture();
        this.clientChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data, (int)0, (int)16384));
        this.clientSendCounter.set(16384);
        clientHandshakeFuture.sync();
        boolean needsRenegotiation = this.renegotiation.type == RenegotiationType.CLIENT_INITIATED;
        Future renegoFuture = null;
        while (this.clientSendCounter.get() < data.length) {
            int clientSendCounterVal = this.clientSendCounter.get();
            int length = Math.min(random.nextInt(65536), data.length - clientSendCounterVal);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])data, (int)clientSendCounterVal, (int)length);
            if (this.useCompositeByteBuf) {
                buf = Unpooled.compositeBuffer().addComponent(true, buf);
            }
            ChannelFuture future = this.clientChannel.writeAndFlush((Object)buf);
            this.clientSendCounter.set(clientSendCounterVal += length);
            future.sync();
            if (!needsRenegotiation || clientSendCounterVal < data.length / 2) continue;
            needsRenegotiation = false;
            this.clientSslHandler.engine().setEnabledCipherSuites(new String[]{this.renegotiation.cipherSuite});
            renegoFuture = this.clientSslHandler.renegotiate();
            this.logStats("CLIENT RENEGOTIATES");
            Assert.assertThat((Object)renegoFuture, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)clientHandshakeFuture))));
        }
        while (this.clientRecvCounter.get() < data.length && this.serverException.get() == null && this.serverException.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.serverRecvCounter.get() < data.length && this.serverException.get() == null && this.clientException.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (renegoFuture != null) {
            renegoFuture.sync();
        }
        if (this.serverHandler.renegoFuture != null) {
            this.serverHandler.renegoFuture.sync();
        }
        this.serverChannel.close().awaitUninterruptibly();
        this.clientChannel.close().awaitUninterruptibly();
        sc.close().awaitUninterruptibly();
        delegatedTaskExecutor.shutdown();
        if (this.serverException.get() != null && !(this.serverException.get() instanceof IOException)) {
            throw this.serverException.get();
        }
        if (this.clientException.get() != null && !(this.clientException.get() instanceof IOException)) {
            throw this.clientException.get();
        }
        if (this.serverException.get() != null) {
            throw this.serverException.get();
        }
        if (this.clientException.get() != null) {
            throw this.clientException.get();
        }
        try {
            switch (this.renegotiation.type) {
                case SERVER_INITIATED: {
                    Assert.assertThat((Object)this.serverSslHandler.engine().getSession().getCipherSuite(), (Matcher)Matchers.is((Object)this.renegotiation.cipherSuite));
                    Assert.assertThat((Object)this.serverNegoCounter.get(), (Matcher)Matchers.is((Object)2));
                    Assert.assertThat((Object)this.clientNegoCounter.get(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)1), (Matcher)Matchers.is((Object)2)));
                    return;
                }
                case CLIENT_INITIATED: {
                    Assert.assertThat((Object)this.serverNegoCounter.get(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)1), (Matcher)Matchers.is((Object)2)));
                    Assert.assertThat((Object)this.clientSslHandler.engine().getSession().getCipherSuite(), (Matcher)Matchers.is((Object)this.renegotiation.cipherSuite));
                    Assert.assertThat((Object)this.clientNegoCounter.get(), (Matcher)Matchers.is((Object)2));
                    return;
                }
                case NONE: {
                    Assert.assertThat((Object)this.serverNegoCounter.get(), (Matcher)Matchers.is((Object)1));
                    Assert.assertThat((Object)this.clientNegoCounter.get(), (Matcher)Matchers.is((Object)1));
                    return;
                }
            }
            return;
        }
        finally {
            this.logStats("STATS");
        }
    }

    private void reset() {
        this.clientException.set(null);
        this.serverException.set(null);
        this.clientSendCounter.set(0);
        this.clientRecvCounter.set(0);
        this.serverRecvCounter.set(0);
        this.clientNegoCounter.set(0);
        this.serverNegoCounter.set(0);
        this.clientChannel = null;
        this.serverChannel = null;
        this.clientSslHandler = null;
        this.serverSslHandler = null;
    }

    void logStats(String message) {
        logger.debug("{}:\n\tclient { sent: {}, rcvd: {}, nego: {}, cipher: {} },\n\tserver { rcvd: {}, nego: {}, cipher: {} }", new Object[]{message, this.clientSendCounter, this.clientRecvCounter, this.clientNegoCounter, this.clientSslHandler.engine().getSession().getCipherSuite(), this.serverRecvCounter, this.serverNegoCounter, this.serverSslHandler.engine().getSession().getCipherSuite()});
    }

    static {
        SelfSignedCertificate ssc;
        logger = InternalLoggerFactory.getInstance(SocketSslEchoTest.class);
        random = new Random();
        data = new byte[0x100000];
        random.nextBytes(data);
        try {
            ssc = new SelfSignedCertificate();
        }
        catch (CertificateException e) {
            throw new Error(e);
        }
        CERT_FILE = ssc.certificate();
        KEY_FILE = ssc.privateKey();
    }

    private class EchoServerHandler
    extends EchoHandler {
        volatile Future<Channel> renegoFuture;

        EchoServerHandler(AtomicInteger recvCounter, AtomicInteger negoCounter, AtomicReference<Throwable> exception) {
            super(recvCounter, negoCounter, exception);
        }

        public final void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            this.renegoFuture = null;
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.recvCounter.get();
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])actual);
            if (SocketSslEchoTest.this.useCompositeByteBuf) {
                buf = Unpooled.compositeBuffer().addComponent(true, buf);
            }
            ctx.write((Object)buf);
            this.recvCounter.addAndGet(actual.length);
            if (((SocketSslEchoTest)SocketSslEchoTest.this).renegotiation.type == RenegotiationType.SERVER_INITIATED && this.recvCounter.get() > data.length / 2 && this.renegoFuture == null) {
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                Future hf = sslHandler.handshakeFuture();
                Assert.assertThat((Object)hf.isDone(), (Matcher)Matchers.is((Object)true));
                sslHandler.engine().setEnabledCipherSuites(new String[]{((SocketSslEchoTest)SocketSslEchoTest.this).renegotiation.cipherSuite});
                SocketSslEchoTest.this.logStats("SERVER RENEGOTIATES");
                this.renegoFuture = sslHandler.renegotiate();
                Assert.assertThat(this.renegoFuture, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)hf))));
                Assert.assertThat(this.renegoFuture, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)sslHandler.handshakeFuture())));
                Assert.assertThat((Object)this.renegoFuture.isDone(), (Matcher)Matchers.is((Object)false));
            }
        }
    }

    private class EchoClientHandler
    extends EchoHandler {
        EchoClientHandler(AtomicInteger recvCounter, AtomicInteger negoCounter, AtomicReference<Throwable> exception) {
            super(recvCounter, negoCounter, exception);
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.recvCounter.get();
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            this.recvCounter.addAndGet(actual.length);
        }
    }

    @ChannelHandler.Sharable
    private abstract class EchoHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        protected final AtomicInteger recvCounter;
        protected final AtomicInteger negoCounter;
        protected final AtomicReference<Throwable> exception;

        EchoHandler(AtomicInteger recvCounter, AtomicInteger negoCounter, AtomicReference<Throwable> exception) {
            this.recvCounter = recvCounter;
            this.negoCounter = negoCounter;
            this.exception = exception;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (!SocketSslEchoTest.this.autoRead) {
                ctx.read();
            }
        }

        public final void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            try {
                ctx.flush();
            }
            finally {
                if (!SocketSslEchoTest.this.autoRead) {
                    ctx.read();
                }
            }
        }

        public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvt = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvt.cause() != null) {
                    logger.warn("Handshake failed:", handshakeEvt.cause());
                }
                Assert.assertSame((Object)SslHandshakeCompletionEvent.SUCCESS, (Object)evt);
                this.negoCounter.incrementAndGet();
                SocketSslEchoTest.this.logStats("HANDSHAKEN");
            }
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the client side:", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }

    protected static class Renegotiation {
        static final Renegotiation NONE = new Renegotiation(RenegotiationType.NONE, null);
        final RenegotiationType type;
        final String cipherSuite;

        Renegotiation(RenegotiationType type, String cipherSuite) {
            this.type = type;
            this.cipherSuite = cipherSuite;
        }

        public String toString() {
            if (this.type == RenegotiationType.NONE) {
                return "NONE";
            }
            return (Object)((Object)this.type) + "(" + this.cipherSuite + ')';
        }
    }

    protected static enum RenegotiationType {
        NONE,
        CLIENT_INITIATED,
        SERVER_INITIATED;

    }
}

