/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class AbstractTestsuiteTest<T extends AbstractBootstrap<?, ?>> {
    private final Class<T> clazz;
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    protected volatile T cb;
    @Rule
    public final TestName testName = new TestName();

    protected AbstractTestsuiteTest(Class<T> clazz) {
        this.clazz = clazz;
    }

    protected abstract List<TestsuitePermutation.BootstrapFactory<T>> newFactories();

    protected List<ByteBufAllocator> newAllocators() {
        return TestsuitePermutation.allocator();
    }

    protected void run() throws Throwable {
        List<TestsuitePermutation.BootstrapFactory<T>> combos = this.newFactories();
        for (ByteBufAllocator allocator : this.newAllocators()) {
            int i = 0;
            for (TestsuitePermutation.BootstrapFactory<T> e : combos) {
                this.cb = e.newInstance();
                this.configure(this.cb, allocator);
                this.logger.info(String.format("Running: %s %d of %d with %s", this.testName.getMethodName(), ++i, combos.size(), StringUtil.simpleClassName((Object)allocator)));
                try {
                    Method m = this.getClass().getMethod(TestUtils.testMethodName(this.testName), this.clazz);
                    m.invoke((Object)this, this.cb);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
            }
        }
    }

    protected abstract void configure(T var1, ByteBufAllocator var2);
}

