/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.FileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SocketFileRegionTest
extends AbstractSocketTest {
    static final byte[] data = new byte[0xA00000];

    @Test
    public void testFileRegion() throws Throwable {
        this.run();
    }

    @Test
    public void testCustomFileRegion() throws Throwable {
        this.run();
    }

    @Test
    public void testFileRegionNotAutoRead() throws Throwable {
        this.run();
    }

    @Test
    public void testFileRegionVoidPromise() throws Throwable {
        this.run();
    }

    @Test
    public void testFileRegionVoidPromiseNotAutoRead() throws Throwable {
        this.run();
    }

    public void testFileRegion(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, false, true, true);
    }

    public void testCustomFileRegion(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, false, true, false);
    }

    public void testFileRegionVoidPromise(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, true, true, true);
    }

    public void testFileRegionNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, false, false, true);
    }

    public void testFileRegionVoidPromiseNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, true, false, true);
    }

    private static void testFileRegion0(ServerBootstrap sb, Bootstrap cb, boolean voidPromise, final boolean autoRead, boolean defaultFileRegion) throws Throwable {
        int i;
        sb.childOption(ChannelOption.AUTO_READ, (Object)autoRead);
        cb.option(ChannelOption.AUTO_READ, (Object)autoRead);
        int bufferSize = 1024;
        File file = File.createTempFile("netty-", ".tmp");
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        Random random = PlatformDependent.threadLocalRandom();
        int startOffset = random.nextInt(8192);
        for (i = 0; i < startOffset; ++i) {
            out.write(random.nextInt());
        }
        out.write(data, 1024, data.length - 1024);
        for (i = random.nextInt(8192); i > 0; --i) {
            out.write(random.nextInt());
        }
        out.close();
        SimpleChannelInboundHandler<Object> ch = new SimpleChannelInboundHandler<Object>(){

            public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                if (!autoRead) {
                    ctx.read();
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
            }
        };
        TestHandler sh = new TestHandler(autoRead);
        sb.childHandler((ChannelHandler)sh);
        cb.handler((ChannelHandler)ch);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        Object region = new DefaultFileRegion(new FileInputStream(file).getChannel(), (long)startOffset, (long)(data.length - 1024));
        Object emptyRegion = new DefaultFileRegion(new FileInputStream(file).getChannel(), 0L, 0L);
        if (!defaultFileRegion) {
            region = new FileRegionWrapper((FileRegion)region);
            emptyRegion = new FileRegionWrapper((FileRegion)emptyRegion);
        }
        if (voidPromise) {
            Assert.assertEquals((Object)cc.voidPromise(), (Object)cc.write((Object)Unpooled.wrappedBuffer((byte[])data, (int)0, (int)1024), cc.voidPromise()));
            Assert.assertEquals((Object)cc.voidPromise(), (Object)cc.write(emptyRegion, cc.voidPromise()));
            Assert.assertEquals((Object)cc.voidPromise(), (Object)cc.writeAndFlush(region, cc.voidPromise()));
        } else {
            Assert.assertNotEquals((Object)cc.voidPromise(), (Object)cc.write((Object)Unpooled.wrappedBuffer((byte[])data, (int)0, (int)1024)));
            Assert.assertNotEquals((Object)cc.voidPromise(), (Object)cc.write(emptyRegion));
            Assert.assertNotEquals((Object)cc.voidPromise(), (Object)cc.writeAndFlush(region));
        }
        while (sh.counter < data.length && sh.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().sync();
        cc.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        Assert.assertThat((Object)sh.counter, (Matcher)CoreMatchers.is((Object)data.length));
    }

    static {
        PlatformDependent.threadLocalRandom().nextBytes(data);
    }

    private static final class FileRegionWrapper
    implements FileRegion {
        private final FileRegion region;

        FileRegionWrapper(FileRegion region) {
            this.region = region;
        }

        public int refCnt() {
            return this.region.refCnt();
        }

        public long position() {
            return this.region.position();
        }

        @Deprecated
        public long transfered() {
            return this.region.transferred();
        }

        public boolean release() {
            return this.region.release();
        }

        public long transferred() {
            return this.region.transferred();
        }

        public long count() {
            return this.region.count();
        }

        public boolean release(int decrement) {
            return this.region.release(decrement);
        }

        public long transferTo(WritableByteChannel target, long position) throws IOException {
            return this.region.transferTo(target, position);
        }

        public FileRegion retain() {
            this.region.retain();
            return this;
        }

        public FileRegion retain(int increment) {
            this.region.retain(increment);
            return this;
        }

        public FileRegion touch() {
            this.region.touch();
            return this;
        }

        public FileRegion touch(Object hint) {
            this.region.touch(hint);
            return this;
        }
    }

    private static class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final boolean autoRead;
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;

        TestHandler(boolean autoRead) {
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
            if (!this.autoRead) {
                ctx.read();
            }
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            this.counter += actual.length;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (!this.autoRead) {
                ctx.read();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }
}

