/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.testsuite.transport.socket.AbstractDatagramTest;
import io.netty.util.NetUtil;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DatagramMulticastTest
extends AbstractDatagramTest {
    @Test
    public void testMulticast() throws Throwable {
        this.run();
    }

    public void testMulticast(Bootstrap sb, Bootstrap cb) throws Throwable {
        MulticastTestHandler mhandler = new MulticastTestHandler();
        sb.handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }
        });
        cb.handler((ChannelHandler)mhandler);
        sb.option(ChannelOption.IP_MULTICAST_IF, (Object)NetUtil.LOOPBACK_IF);
        sb.option(ChannelOption.SO_REUSEADDR, (Object)true);
        cb.option(ChannelOption.IP_MULTICAST_IF, (Object)NetUtil.LOOPBACK_IF);
        cb.option(ChannelOption.SO_REUSEADDR, (Object)true);
        cb.localAddress(this.addr.getPort());
        Channel sc = sb.bind().sync().channel();
        if (sc instanceof OioDatagramChannel) {
            sc.close().awaitUninterruptibly();
            return;
        }
        DatagramChannel cc = (DatagramChannel)cb.bind().sync().channel();
        String group = "230.0.0.1";
        InetSocketAddress groupAddress = SocketUtils.socketAddress((String)group, (int)this.addr.getPort());
        cc.joinGroup(groupAddress, NetUtil.LOOPBACK_IF).sync();
        sc.writeAndFlush((Object)new DatagramPacket(Unpooled.copyInt((int)1), groupAddress)).sync();
        Assert.assertTrue((boolean)mhandler.await());
        cc.leaveGroup(groupAddress, NetUtil.LOOPBACK_IF).sync();
        Thread.sleep(1000L);
        sc.writeAndFlush((Object)new DatagramPacket(Unpooled.copyInt((int)1), groupAddress)).sync();
        mhandler.await();
        sc.close().awaitUninterruptibly();
        cc.close().awaitUninterruptibly();
    }

    private static final class MulticastTestHandler
    extends SimpleChannelInboundHandler<DatagramPacket> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private boolean done;
        private volatile boolean fail;

        private MulticastTestHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
            if (this.done) {
                this.fail = true;
            }
            Assert.assertEquals((long)1L, (long)((ByteBuf)msg.content()).readInt());
            this.latch.countDown();
            this.done = true;
        }

        public boolean await() throws Exception {
            boolean success = this.latch.await(10L, TimeUnit.SECONDS);
            if (this.fail) {
                Assert.fail();
            }
            return success;
        }
    }
}

