/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class TrafficShapingTest
extends AbstractSocketTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(TrafficShapingTest.class);
    static final int messageSize = 1024;
    static final int bandwidthFactor = 15;
    static final int minfactor = 7;
    static final int maxfactor = 22;
    static final long stepms = 66L;
    static final long minimalms = Math.max(33L, 20L) / 10L * 10L;
    static final long check = Math.max(Math.min(100L, minimalms / 2L) / 10L * 10L, 20L);
    private static final Random random = new Random();
    static final byte[] data = new byte[1024];
    private static EventExecutorGroup group;
    private static ScheduledExecutorService executor;

    @BeforeClass
    public static void createGroup() {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.setLevel(Level.INFO);
        logger.info("Bandwidth: 7 <= 15 <= 22 StepMs: 66 MinMs: " + minimalms + " CheckMs: " + check);
        group = new DefaultEventExecutorGroup(8);
    }

    @AfterClass
    public static void destroyGroup() throws Exception {
        group.shutdownGracefully().sync();
    }

    private static long[] computeWaitRead(int[] multipleMessage) {
        long[] minimalWaitBetween = new long[multipleMessage.length + 1];
        minimalWaitBetween[0] = 0L;
        for (int i = 0; i < multipleMessage.length; ++i) {
            minimalWaitBetween[i + 1] = (long)(multipleMessage[i] - 1) * 66L + minimalms;
        }
        return minimalWaitBetween;
    }

    private static long[] computeWaitWrite(int[] multipleMessage) {
        long[] minimalWaitBetween = new long[multipleMessage.length + 1];
        for (int i = 0; i < multipleMessage.length; ++i) {
            minimalWaitBetween[i] = (long)(multipleMessage[i] - 1) * 66L + minimalms;
        }
        return minimalWaitBetween;
    }

    @Test(timeout=10000L)
    public void testNoTrafficShapping() throws Throwable {
        logger.info("TEST NO TRAFFIC");
        this.run();
    }

    public void testNoTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1};
        long[] minimalWaitBetween = null;
        TrafficShapingTest.testTrafficShapping0(sb, cb, false, false, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=15000L)
    public void testExecNoTrafficShapping() throws Throwable {
        logger.info("TEST EXEC NO TRAFFIC");
        this.run();
    }

    public void testExecNoTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1};
        long[] minimalWaitBetween = null;
        TrafficShapingTest.testTrafficShapping0(sb, cb, true, false, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testWriteTrafficShapping() throws Throwable {
        logger.info("TEST WRITE");
        this.run();
    }

    public void testWriteTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitWrite(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, false, false, true, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testReadTrafficShapping() throws Throwable {
        logger.info("TEST READ");
        this.run();
    }

    public void testReadTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitRead(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, false, true, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testWrite1TrafficShapping() throws Throwable {
        logger.info("TEST WRITE");
        this.run();
    }

    public void testWrite1TrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 1, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitWrite(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, false, false, true, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testRead1TrafficShapping() throws Throwable {
        logger.info("TEST READ");
        this.run();
    }

    public void testRead1TrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 1, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitRead(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, false, true, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=15000L)
    public void testExecWriteTrafficShapping() throws Throwable {
        logger.info("TEST EXEC WRITE");
        this.run();
    }

    public void testExecWriteTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitWrite(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, true, false, true, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testExecReadTrafficShapping() throws Throwable {
        logger.info("TEST EXEC READ");
        this.run();
    }

    public void testExecReadTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitRead(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, true, true, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testWriteGlobalTrafficShapping() throws Throwable {
        logger.info("TEST GLOBAL WRITE");
        this.run();
    }

    public void testWriteGlobalTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitWrite(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, false, false, true, true, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testReadGlobalTrafficShapping() throws Throwable {
        logger.info("TEST GLOBAL READ");
        this.run();
    }

    public void testReadGlobalTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = null;
        int[] multipleMessage = new int[]{1, 2, 1, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitRead(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, false, true, false, true, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testAutoReadTrafficShapping() throws Throwable {
        logger.info("TEST AUTO READ");
        this.run();
    }

    public void testAutoReadTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = new int[]{1, -1, -1, 1, -2, 0, 1, 0, -3, 0, 1, 2, 0};
        int[] multipleMessage = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitRead(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, false, true, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testAutoReadGlobalTrafficShapping() throws Throwable {
        logger.info("TEST AUTO READ GLOBAL");
        this.run();
    }

    public void testAutoReadGlobalTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = new int[]{1, -1, -1, 1, -2, 0, 1, 0, -3, 0, 1, 2, 0};
        int[] multipleMessage = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitRead(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, false, true, false, true, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testAutoReadExecTrafficShapping() throws Throwable {
        logger.info("TEST AUTO READ EXEC");
        this.run();
    }

    public void testAutoReadExecTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = new int[]{1, -1, -1, 1, -2, 0, 1, 0, -3, 0, 1, 2, 0};
        int[] multipleMessage = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitRead(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, true, true, false, false, autoRead, minimalWaitBetween, multipleMessage);
    }

    @Test(timeout=10000L)
    public void testAutoReadExecGlobalTrafficShapping() throws Throwable {
        logger.info("TEST AUTO READ EXEC GLOBAL");
        this.run();
    }

    public void testAutoReadExecGlobalTrafficShapping(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        int[] autoRead = new int[]{1, -1, -1, 1, -2, 0, 1, 0, -3, 0, 1, 2, 0};
        int[] multipleMessage = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        long[] minimalWaitBetween = TrafficShapingTest.computeWaitRead(multipleMessage);
        TrafficShapingTest.testTrafficShapping0(sb, cb, true, true, false, true, autoRead, minimalWaitBetween, multipleMessage);
    }

    private static void testTrafficShapping0(ServerBootstrap sb, Bootstrap cb, final boolean additionalExecutor, final boolean limitRead, final boolean limitWrite, boolean globalLimit, int[] autoRead, long[] minimalWaitBetween, int[] multipleMessage) throws Throwable {
        logger.info("Exec: " + additionalExecutor + " Read: " + limitRead + " Write: " + limitWrite + " Global: " + globalLimit);
        ValidTimestampedHandler sh = new ValidTimestampedHandler(autoRead, multipleMessage);
        Promise promise = group.next().newPromise();
        ClientTrafficHandler ch = new ClientTrafficHandler((Promise<Boolean>)promise, minimalWaitBetween, multipleMessage, autoRead);
        Object handler = limitRead ? (globalLimit ? new GlobalTrafficShapingHandler((ScheduledExecutorService)group, 0L, 15360L, check) : new ChannelTrafficShapingHandler(0L, 15360L, check)) : (limitWrite ? (globalLimit ? new GlobalTrafficShapingHandler((ScheduledExecutorService)group, 15360L, 0L, check) : new ChannelTrafficShapingHandler(15360L, 0L, check)) : null);
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>((AbstractTrafficShapingHandler)handler, sh){
            final /* synthetic */ AbstractTrafficShapingHandler val$handler;
            final /* synthetic */ ValidTimestampedHandler val$sh;
            {
                this.val$handler = abstractTrafficShapingHandler;
                this.val$sh = validTimestampedHandler;
            }

            protected void initChannel(SocketChannel c) throws Exception {
                if (limitRead) {
                    if (additionalExecutor) {
                        c.pipeline().addLast(group, new ChannelHandler[]{this.val$handler});
                    } else {
                        c.pipeline().addLast(new ChannelHandler[]{this.val$handler});
                    }
                }
                if (additionalExecutor) {
                    c.pipeline().addLast(group, new ChannelHandler[]{this.val$sh});
                } else {
                    c.pipeline().addLast(new ChannelHandler[]{this.val$sh});
                }
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>((AbstractTrafficShapingHandler)handler, ch){
            final /* synthetic */ AbstractTrafficShapingHandler val$handler;
            final /* synthetic */ ClientTrafficHandler val$ch;
            {
                this.val$handler = abstractTrafficShapingHandler;
                this.val$ch = clientTrafficHandler;
            }

            protected void initChannel(SocketChannel c) throws Exception {
                if (limitWrite) {
                    if (additionalExecutor) {
                        c.pipeline().addLast(group, new ChannelHandler[]{this.val$handler});
                    } else {
                        c.pipeline().addLast(new ChannelHandler[]{this.val$handler});
                    }
                }
                if (additionalExecutor) {
                    c.pipeline().addLast(group, new ChannelHandler[]{this.val$ch});
                } else {
                    c.pipeline().addLast(new ChannelHandler[]{this.val$ch});
                }
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        int totalNb = 0;
        for (int i = 1; i < multipleMessage.length; ++i) {
            totalNb += multipleMessage[i];
        }
        Long start = System.currentTimeMillis();
        int nb = multipleMessage[0];
        for (int i = 0; i < nb; ++i) {
            cc.write((Object)cc.alloc().buffer().writeBytes(data));
        }
        cc.flush();
        promise.await();
        Long stop = System.currentTimeMillis();
        Assert.assertTrue((String)("Error during exceution of TrafficShapping: " + promise.cause()), (boolean)promise.isSuccess());
        float average = (float)(totalNb * 1024) / (float)(stop - start);
        logger.info("Average of traffic: " + average + " compare to " + 15);
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (autoRead != null) {
            Thread.sleep(minimalms);
        }
        if (autoRead == null && minimalWaitBetween != null) {
            Assert.assertTrue((String)("Overall Traffic not ok since > 22: " + average), (average <= 22.0f ? 1 : 0) != 0);
            if (additionalExecutor) {
                Assert.assertTrue((String)("Overall Traffic not ok since < 0.25: " + average), ((double)average >= 0.25 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)("Overall Traffic not ok since < 7: " + average), (average >= 7.0f ? 1 : 0) != 0);
            }
        }
        if (handler != null && globalLimit) {
            ((GlobalTrafficShapingHandler)handler).release();
        }
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        executor = Executors.newScheduledThreadPool(10);
        random.nextBytes(data);
    }

    private static class ValidTimestampedHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final int[] autoRead;
        private final int[] multipleMessage;
        volatile Channel channel;
        volatile int step;
        final AtomicReference<Throwable> exception = new AtomicReference();

        ValidTimestampedHandler(int[] autoRead, int[] multipleMessage) {
            this.autoRead = autoRead;
            this.multipleMessage = Arrays.copyOf(multipleMessage, multipleMessage.length);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            int i;
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            long timestamp = System.currentTimeMillis();
            int nb = actual.length / 1024;
            int isAutoRead = 0;
            int laststep = this.step;
            for (i = 0; i < nb; ++i) {
                int n = this.step;
                this.multipleMessage[n] = this.multipleMessage[n] - 1;
                if (this.multipleMessage[this.step] != 0) continue;
                if (this.autoRead != null) {
                    isAutoRead = this.autoRead[this.step];
                }
                ++this.step;
            }
            if (laststep != this.step && this.autoRead != null && isAutoRead != 2) {
                if (isAutoRead != 0) {
                    logger.info("Set AutoRead: " + (isAutoRead > 0) + " Step: " + this.step);
                    this.channel.config().setAutoRead(isAutoRead > 0);
                } else {
                    logger.info("AutoRead: NO Step:" + this.step);
                }
            }
            logger.debug("Get: " + actual.length + " TS " + timestamp + " NB: " + nb);
            for (i = 0; i < nb; ++i) {
                this.channel.write((Object)Unpooled.copyLong((long)timestamp));
            }
            this.channel.flush();
            if (laststep != this.step && isAutoRead != 0) {
                if (isAutoRead < 0) {
                    long wait;
                    final int exactStep = this.step;
                    long l = wait = isAutoRead == -1 ? minimalms : 66L + minimalms;
                    if (isAutoRead == -3) {
                        wait = 198L;
                    }
                    executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            logger.info("Reset AutoRead: Step " + exactStep);
                            ValidTimestampedHandler.this.channel.config().setAutoRead(true);
                        }
                    }, wait, TimeUnit.MILLISECONDS);
                } else if (isAutoRead > 1) {
                    logger.info("Will Set AutoRead: Rrue, Step: " + this.step);
                    executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            logger.info("Set AutoRead: Rrue, Step: " + ValidTimestampedHandler.this.step);
                            ValidTimestampedHandler.this.channel.config().setAutoRead(true);
                        }
                    }, 66L + minimalms, TimeUnit.MILLISECONDS);
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                cause.printStackTrace();
                ctx.close();
            }
        }
    }

    private static class ClientTrafficHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int step;
        private long currentLastTime = System.currentTimeMillis();
        private final long[] minimalWaitBetween;
        private final int[] multipleMessage;
        private final int[] autoRead;
        final Promise<Boolean> promise;

        ClientTrafficHandler(Promise<Boolean> promise, long[] minimalWaitBetween, int[] multipleMessage, int[] autoRead) {
            this.minimalWaitBetween = minimalWaitBetween;
            this.multipleMessage = Arrays.copyOf(multipleMessage, multipleMessage.length);
            this.promise = promise;
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            long lastTimestamp = 0L;
            while (in.isReadable()) {
                lastTimestamp = in.readLong();
                int n = this.step;
                this.multipleMessage[n] = this.multipleMessage[n] - 1;
            }
            if (this.multipleMessage[this.step] > 0) {
                return;
            }
            long minimalWait = this.minimalWaitBetween != null ? this.minimalWaitBetween[this.step] : 0L;
            int ar = 0;
            if (this.autoRead != null) {
                minimalWait = this.step > 0 && this.autoRead[this.step - 1] != 0 ? ((ar = this.autoRead[this.step - 1]) > 0 ? -1L : minimalms / 3L) : 0L;
            }
            logger.info("Step: " + this.step + " Interval: " + (lastTimestamp - this.currentLastTime) + " compareTo " + minimalWait + " (" + ar + ")");
            Assert.assertTrue((String)("The interval of time is incorrect:" + (lastTimestamp - this.currentLastTime) + " not> " + minimalWait), (lastTimestamp - this.currentLastTime >= minimalWait ? 1 : 0) != 0);
            this.currentLastTime = lastTimestamp;
            ++this.step;
            if (this.multipleMessage.length > this.step) {
                int nb = this.multipleMessage[this.step];
                for (int i = 0; i < nb; ++i) {
                    this.channel.write((Object)this.channel.alloc().buffer().writeBytes(data));
                }
                this.channel.flush();
            } else {
                this.promise.setSuccess((Object)true);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                cause.printStackTrace();
                this.promise.setFailure(cause);
                ctx.close();
            }
        }
    }
}

