/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SocketFileRegionTest
extends AbstractSocketTest {
    static final byte[] data = new byte[0xA00000];

    @Test
    public void testFileRegion() throws Throwable {
        this.run();
    }

    @Test
    public void testFileRegionNotAutoRead() throws Throwable {
        this.run();
    }

    @Test
    public void testFileRegionVoidPromise() throws Throwable {
        this.run();
    }

    @Test
    public void testFileRegionVoidPromiseNotAutoRead() throws Throwable {
        this.run();
    }

    public void testFileRegion(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, false, true);
    }

    public void testFileRegionVoidPromise(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, true, true);
    }

    public void testFileRegionNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, false, false);
    }

    public void testFileRegionVoidPromiseNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, true, false);
    }

    private static void testFileRegion0(ServerBootstrap sb, Bootstrap cb, boolean voidPromise, final boolean autoRead) throws Throwable {
        int i;
        File file = File.createTempFile("netty-", ".tmp");
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int startOffset = random.nextInt(8192);
        for (i = 0; i < startOffset; ++i) {
            out.write(random.nextInt());
        }
        out.write(data);
        for (i = random.nextInt(8192); i > 0; --i) {
            out.write(random.nextInt());
        }
        out.close();
        SimpleChannelInboundHandler<Object> ch = new SimpleChannelInboundHandler<Object>(){

            public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                if (!autoRead) {
                    ctx.read();
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
            }
        };
        TestHandler sh = new TestHandler(autoRead);
        sb.childHandler((ChannelHandler)sh);
        cb.handler((ChannelHandler)ch);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        DefaultFileRegion region = new DefaultFileRegion(new FileInputStream(file).getChannel(), (long)startOffset, (long)data.length);
        if (voidPromise) {
            Assert.assertEquals((Object)cc.voidPromise(), (Object)cc.writeAndFlush((Object)region, cc.voidPromise()));
        } else {
            Assert.assertNotEquals((Object)cc.voidPromise(), (Object)cc.writeAndFlush((Object)region));
        }
        while (sh.counter < data.length && sh.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().sync();
        cc.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        Assert.assertThat((Object)sh.counter, (Matcher)CoreMatchers.is((Object)data.length));
    }

    static {
        ThreadLocalRandom.current().nextBytes(data);
    }

    private static class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final boolean autoRead;
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;

        TestHandler(boolean autoRead) {
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            this.counter += actual.length;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (!this.autoRead) {
                ctx.read();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }
}

