/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import org.junit.Assert;
import org.junit.Test;

public class SocketBufReleaseTest
extends AbstractSocketTest {
    private static final EventExecutor executor = new DefaultEventExecutorGroup(1, (ThreadFactory)new DefaultThreadFactory(SocketBufReleaseTest.class, true)).next();

    @Test
    public void testBufRelease() throws Throwable {
        this.run();
    }

    public void testBufRelease(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        BufWriterHandler serverHandler = new BufWriterHandler();
        BufWriterHandler clientHandler = new BufWriterHandler();
        sb.childHandler((ChannelHandler)serverHandler);
        cb.handler((ChannelHandler)clientHandler);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect(sc.localAddress()).sync().channel();
        serverHandler.channelFuture.sync();
        sc.close().sync();
        cc.close().sync();
        serverHandler.check();
        clientHandler.check();
        serverHandler.release();
        clientHandler.release();
    }

    static /* synthetic */ EventExecutor access$200() {
        return executor;
    }

    private static class BufWriterHandler
    extends SimpleChannelInboundHandler<Object> {
        private final Random random = new Random();
        private final CountDownLatch latch = new CountDownLatch(1);
        private ByteBuf buf;
        private final Promise<Channel> channelFuture = new DefaultPromise(SocketBufReleaseTest.access$200());

        private BufWriterHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.channelFuture.setSuccess((Object)ctx.channel());
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            byte[] data = new byte[1024];
            this.random.nextBytes(data);
            this.buf = ctx.alloc().buffer();
            this.buf.writeBytes(data).retain();
            ctx.channel().writeAndFlush((Object)this.buf).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    BufWriterHandler.this.latch.countDown();
                }
            });
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        }

        public void check() throws InterruptedException {
            this.latch.await();
            Assert.assertEquals((long)1L, (long)this.buf.refCnt());
        }

        void release() {
            this.buf.release();
        }
    }
}

