/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.JdkSslClientContext;
import io.netty.handler.ssl.JdkSslServerContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SocketSslEchoTest
extends AbstractSocketTest {
    private static final InternalLogger logger;
    private static final int FIRST_MESSAGE_SIZE = 16384;
    private static final Random random;
    private static final File CERT_FILE;
    private static final File KEY_FILE;
    static final byte[] data;
    private final SslContext serverCtx;
    private final SslContext clientCtx;
    private final boolean serverUsesDelegatedTaskExecutor;
    private final boolean clientUsesDelegatedTaskExecutor;
    private final boolean useChunkedWriteHandler;
    private final boolean useCompositeByteBuf;

    @Parameterized.Parameters(name="{index}: serverEngine = {0}, clientEngine = {1}, serverUsesDelegatedTaskExecutor = {2}, clientUsesDelegatedTaskExecutor = {3}, useChunkedWriteHandler = {4}, useCompositeByteBuf = {5}")
    public static Collection<Object[]> data() throws Exception {
        ArrayList<Object> serverContexts = new ArrayList<Object>();
        serverContexts.add(new JdkSslServerContext(CERT_FILE, KEY_FILE));
        ArrayList<JdkSslClientContext> clientContexts = new ArrayList<JdkSslClientContext>();
        clientContexts.add(new JdkSslClientContext(CERT_FILE));
        boolean hasOpenSsl = OpenSsl.isAvailable();
        if (hasOpenSsl) {
            serverContexts.add(new OpenSslServerContext(CERT_FILE, KEY_FILE));
        } else {
            logger.warn("OpenSSL is unavailable and thus will not be tested.", OpenSsl.unavailabilityCause());
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslContext sslContext : serverContexts) {
            for (SslContext sslContext2 : clientContexts) {
                for (int i = 0; i < 16; ++i) {
                    params.add(new Object[]{sslContext, sslContext2, (i & 8) != 0, (i & 4) != 0, (i & 2) != 0, (i & 1) != 0});
                }
            }
        }
        return params;
    }

    public SocketSslEchoTest(SslContext serverCtx, SslContext clientCtx, boolean serverUsesDelegatedTaskExecutor, boolean clientUsesDelegatedTaskExecutor, boolean useChunkedWriteHandler, boolean useCompositeByteBuf) {
        this.serverCtx = serverCtx;
        this.clientCtx = clientCtx;
        this.serverUsesDelegatedTaskExecutor = serverUsesDelegatedTaskExecutor;
        this.clientUsesDelegatedTaskExecutor = clientUsesDelegatedTaskExecutor;
        this.useChunkedWriteHandler = useChunkedWriteHandler;
        this.useCompositeByteBuf = useCompositeByteBuf;
    }

    @Test(timeout=30000L)
    public void testSslEcho() throws Throwable {
        this.run();
    }

    public void testSslEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testSslEcho(sb, cb, true);
    }

    @Test(timeout=30000L)
    public void testSslEchoNotAutoRead() throws Throwable {
        this.run();
    }

    public void testSslEchoNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testSslEcho(sb, cb, false);
    }

    private void testSslEcho(ServerBootstrap sb, Bootstrap cb, boolean autoRead) throws Throwable {
        int length;
        final ExecutorService delegatedTaskExecutor = Executors.newCachedThreadPool();
        final EchoHandler sh = new EchoHandler(true, this.useCompositeByteBuf, autoRead);
        final EchoHandler ch = new EchoHandler(false, this.useCompositeByteBuf, autoRead);
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                if (SocketSslEchoTest.this.serverUsesDelegatedTaskExecutor) {
                    SSLEngine sse = SocketSslEchoTest.this.serverCtx.newEngine(sch.alloc());
                    sch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sse, (Executor)delegatedTaskExecutor));
                } else {
                    sch.pipeline().addFirst("ssl", (ChannelHandler)SocketSslEchoTest.this.serverCtx.newHandler(sch.alloc()));
                }
                if (SocketSslEchoTest.this.useChunkedWriteHandler) {
                    sch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                }
                sch.pipeline().addLast("handler", (ChannelHandler)sh);
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                if (SocketSslEchoTest.this.clientUsesDelegatedTaskExecutor) {
                    SSLEngine cse = SocketSslEchoTest.this.clientCtx.newEngine(sch.alloc());
                    sch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(cse, (Executor)delegatedTaskExecutor));
                } else {
                    sch.pipeline().addFirst("ssl", (ChannelHandler)SocketSslEchoTest.this.clientCtx.newHandler(sch.alloc()));
                }
                if (SocketSslEchoTest.this.useChunkedWriteHandler) {
                    sch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                }
                sch.pipeline().addLast("handler", (ChannelHandler)ch);
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        Future hf = ((SslHandler)cc.pipeline().get(SslHandler.class)).handshakeFuture();
        cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data, (int)0, (int)16384));
        AtomicBoolean firstByteWriteFutureDone = new AtomicBoolean();
        hf.sync();
        Assert.assertFalse((boolean)firstByteWriteFutureDone.get());
        for (int i = 16384; i < data.length; i += length) {
            length = Math.min(random.nextInt(65536), data.length - i);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])data, (int)i, (int)length);
            if (this.useCompositeByteBuf) {
                buf = Unpooled.compositeBuffer().addComponent(buf).writerIndex(buf.writerIndex());
            }
            ChannelFuture future = cc.writeAndFlush((Object)buf);
            future.sync();
        }
        while (ch.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (sh.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().awaitUninterruptibly();
        ch.channel.close().awaitUninterruptibly();
        sc.close().awaitUninterruptibly();
        delegatedTaskExecutor.shutdown();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        SelfSignedCertificate ssc;
        logger = InternalLoggerFactory.getInstance(SocketSslEchoTest.class);
        random = new Random();
        data = new byte[0x100000];
        random.nextBytes(data);
        try {
            ssc = new SelfSignedCertificate();
        }
        catch (CertificateException e) {
            throw new Error(e);
        }
        CERT_FILE = ssc.certificate();
        KEY_FILE = ssc.privateKey();
    }

    private static class EchoHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;
        private final boolean server;
        private final boolean composite;
        private final boolean autoRead;

        EchoHandler(boolean server, boolean composite, boolean autoRead) {
            this.server = server;
            this.composite = composite;
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            if (this.channel.parent() != null) {
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])actual);
                if (this.composite) {
                    buf = Unpooled.compositeBuffer().addComponent(buf).writerIndex(buf.writerIndex());
                }
                this.channel.write((Object)buf);
            }
            this.counter += actual.length;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            try {
                ctx.flush();
            }
            finally {
                if (!this.autoRead) {
                    ctx.read();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the " + (this.server ? "server" : "client") + " side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }
}

