/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.testsuite.transport.socket.AbstractClientSocketTest;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class SocketConnectionAttemptTest
extends AbstractClientSocketTest {
    private static final String BAD_HOST = SystemPropertyUtil.get((String)"io.netty.testsuite.badHost", (String)"netty.io");
    private static final int BAD_PORT = SystemPropertyUtil.getInt((String)"io.netty.testsuite.badPort", (int)65535);

    @Test(timeout=30000L)
    public void testConnectTimeout() throws Throwable {
        this.run();
    }

    public void testConnectTimeout(Bootstrap cb) throws Throwable {
        ((Bootstrap)cb.handler((ChannelHandler)new TestHandler())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000);
        ChannelFuture future = cb.connect(BAD_HOST, BAD_PORT);
        try {
            Assert.assertThat((Object)future.await(3000L), (Matcher)CoreMatchers.is((Object)true));
        }
        finally {
            future.channel().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectCancellation() throws Throwable {
        boolean badHostTimedOut = true;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(BAD_HOST, BAD_PORT), 10);
        }
        catch (ConnectException e) {
            badHostTimedOut = false;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        Assume.assumeThat((String)("The connection attempt to " + BAD_HOST + " does not time out."), (Object)badHostTimedOut, (Matcher)CoreMatchers.is((Object)true));
        this.run();
    }

    public void testConnectCancellation(Bootstrap cb) throws Throwable {
        ((Bootstrap)cb.handler((ChannelHandler)new TestHandler())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)4000);
        ChannelFuture future = cb.connect(BAD_HOST, BAD_PORT);
        try {
            if (future.await(1000L)) {
                if (future.isSuccess()) {
                    Assert.fail((String)("A connection attempt to " + BAD_HOST + " must not succeed."));
                } else {
                    throw future.cause();
                }
            }
            if (future.cancel(true)) {
                Assert.assertThat((Object)future.channel().closeFuture().await(500L), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)future.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
            }
        }
        finally {
            future.channel().close();
        }
    }

    static {
        InternalLogger logger = InternalLoggerFactory.getInstance(SocketConnectionAttemptTest.class);
        logger.debug("-Dio.netty.testsuite.badHost: {}", (Object)BAD_HOST);
        logger.debug("-Dio.netty.testsuite.badPort: {}", (Object)BAD_PORT);
    }

    private static class TestHandler
    extends ChannelInboundHandlerAdapter {
        private TestHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            InternalLoggerFactory.getInstance(SocketConnectionAttemptTest.class).warn("Unexpected exception:", cause);
        }
    }
}

