/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.testsuite.util.BogusSslContextFactory;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SocketSslEchoTest
extends AbstractSocketTest {
    private static final int FIRST_MESSAGE_SIZE = 16384;
    private static final Random random = new Random();
    static final byte[] data = new byte[0x100000];
    private final boolean serverUsesDelegatedTaskExecutor;
    private final boolean clientUsesDelegatedTaskExecutor;
    private final boolean useChunkedWriteHandler;
    private final boolean useCompositeByteBuf;

    @Parameterized.Parameters(name="{index}: serverUsesDelegatedTaskExecutor = {0}, clientUsesDelegatedTaskExecutor = {1}, useChunkedWriteHandler = {2}, useCompositeByteBuf = {3}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < 16; ++i) {
            params.add(new Object[]{(i & 8) != 0, (i & 4) != 0, (i & 2) != 0, (i & 1) != 0});
        }
        return params;
    }

    public SocketSslEchoTest(boolean serverUsesDelegatedTaskExecutor, boolean clientUsesDelegatedTaskExecutor, boolean useChunkedWriteHandler, boolean useCompositeByteBuf) {
        this.serverUsesDelegatedTaskExecutor = serverUsesDelegatedTaskExecutor;
        this.clientUsesDelegatedTaskExecutor = clientUsesDelegatedTaskExecutor;
        this.useChunkedWriteHandler = useChunkedWriteHandler;
        this.useCompositeByteBuf = useCompositeByteBuf;
    }

    @Test(timeout=30000L)
    public void testSslEcho() throws Throwable {
        this.run();
    }

    public void testSslEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testSslEcho(sb, cb, true);
    }

    @Test(timeout=30000L)
    public void testSslEchoNotAutoRead() throws Throwable {
        this.run();
    }

    public void testSslEchoNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        this.testSslEcho(sb, cb, false);
    }

    private void testSslEcho(ServerBootstrap sb, Bootstrap cb, boolean autoRead) throws Throwable {
        int length;
        final ExecutorService delegatedTaskExecutor = Executors.newCachedThreadPool();
        final EchoHandler sh = new EchoHandler(true, this.useCompositeByteBuf, autoRead);
        final EchoHandler ch = new EchoHandler(false, this.useCompositeByteBuf, autoRead);
        final SSLEngine sse = BogusSslContextFactory.getServerContext().createSSLEngine();
        final SSLEngine cse = BogusSslContextFactory.getClientContext().createSSLEngine();
        sse.setUseClientMode(false);
        cse.setUseClientMode(true);
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                if (SocketSslEchoTest.this.serverUsesDelegatedTaskExecutor) {
                    sch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sse, (Executor)delegatedTaskExecutor));
                } else {
                    sch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sse));
                }
                if (SocketSslEchoTest.this.useChunkedWriteHandler) {
                    sch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                }
                sch.pipeline().addLast("handler", (ChannelHandler)sh);
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                if (SocketSslEchoTest.this.clientUsesDelegatedTaskExecutor) {
                    sch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(cse, (Executor)delegatedTaskExecutor));
                } else {
                    sch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(cse));
                }
                if (SocketSslEchoTest.this.useChunkedWriteHandler) {
                    sch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                }
                sch.pipeline().addLast("handler", (ChannelHandler)ch);
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        Future hf = ((SslHandler)cc.pipeline().get(SslHandler.class)).handshakeFuture();
        cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data, (int)0, (int)16384));
        AtomicBoolean firstByteWriteFutureDone = new AtomicBoolean();
        hf.sync();
        Assert.assertFalse((boolean)firstByteWriteFutureDone.get());
        for (int i = 16384; i < data.length; i += length) {
            length = Math.min(random.nextInt(65536), data.length - i);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])data, (int)i, (int)length);
            if (this.useCompositeByteBuf) {
                buf = Unpooled.compositeBuffer().addComponent(buf).writerIndex(buf.writerIndex());
            }
            ChannelFuture future = cc.writeAndFlush((Object)buf);
            future.sync();
        }
        while (ch.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (sh.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().awaitUninterruptibly();
        ch.channel.close().awaitUninterruptibly();
        sc.close().awaitUninterruptibly();
        delegatedTaskExecutor.shutdown();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        random.nextBytes(data);
    }

    private class EchoHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;
        private final boolean server;
        private final boolean composite;
        private final boolean autoRead;

        EchoHandler(boolean server, boolean composite, boolean autoRead) {
            this.server = server;
            this.composite = composite;
            this.autoRead = autoRead;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            if (this.channel.parent() != null) {
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])actual);
                if (this.composite) {
                    buf = Unpooled.compositeBuffer().addComponent(buf).writerIndex(buf.writerIndex());
                }
                this.channel.write((Object)buf);
            }
            this.counter += actual.length;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            try {
                ctx.flush();
            }
            finally {
                if (!this.autoRead) {
                    ctx.read();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (SocketSslEchoTest.this.logger.isWarnEnabled()) {
                SocketSslEchoTest.this.logger.warn("Unexpected exception from the " + (this.server ? "server" : "client") + " side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }
}

