/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.spdy.SpdyFrameDecoder;
import io.netty.handler.codec.spdy.SpdyFrameEncoder;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class SocketSpdyEchoTest
extends AbstractSocketTest {
    private static final Random random = new Random();
    static final int ignoredBytes = 20;
    private SpdyVersion version;

    private static ByteBuf createFrames(int version) {
        ByteBuf frames = Unpooled.buffer((int)1174);
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(65535);
        frames.writeByte(255);
        frames.writeMedium(4);
        frames.writeInt(random.nextInt());
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(5);
        frames.writeInt(0);
        frames.writeInt(random.nextInt() & Integer.MAX_VALUE | 1);
        frames.writeByte(1);
        frames.writeMedium(1024);
        for (int i = 0; i < 256; ++i) {
            frames.writeInt(random.nextInt());
        }
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(1);
        frames.writeByte(3);
        frames.writeMedium(10);
        frames.writeInt(random.nextInt() & Integer.MAX_VALUE | 1);
        frames.writeInt(random.nextInt() & Integer.MAX_VALUE);
        frames.writeShort(32768);
        if (version < 3) {
            frames.writeShort(0);
        }
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(2);
        frames.writeByte(1);
        frames.writeMedium(4);
        frames.writeInt(random.nextInt() & Integer.MAX_VALUE | 1);
        if (version < 3) {
            frames.writeInt(0);
        }
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(3);
        frames.writeInt(8);
        frames.writeInt(random.nextInt() & Integer.MAX_VALUE | 1);
        frames.writeInt(random.nextInt() | 1);
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(4);
        frames.writeByte(1);
        frames.writeMedium(12);
        frames.writeInt(1);
        frames.writeByte(3);
        frames.writeMedium(random.nextInt());
        frames.writeInt(random.nextInt());
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(6);
        frames.writeInt(4);
        frames.writeInt(random.nextInt());
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(7);
        frames.writeInt(8);
        frames.writeInt(random.nextInt() & Integer.MAX_VALUE);
        frames.writeInt(random.nextInt() | 1);
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(8);
        frames.writeByte(1);
        frames.writeMedium(4);
        frames.writeInt(random.nextInt() & Integer.MAX_VALUE | 1);
        frames.writeByte(128);
        frames.writeByte(version);
        frames.writeShort(9);
        frames.writeInt(8);
        frames.writeInt(random.nextInt() & Integer.MAX_VALUE | 1);
        frames.writeInt(random.nextInt() & Integer.MAX_VALUE | 1);
        return frames;
    }

    @Test(timeout=15000L)
    public void testSpdyEcho() throws Throwable {
        this.version = SpdyVersion.SPDY_3;
        this.logger.info("Testing against SPDY v3");
        this.run();
        this.version = SpdyVersion.SPDY_3_1;
        this.logger.info("Testing against SPDY v3.1");
        this.run();
    }

    public void testSpdyEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        ByteBuf frames;
        switch (this.version) {
            case SPDY_3: 
            case SPDY_3_1: {
                frames = SocketSpdyEchoTest.createFrames(3);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version");
            }
        }
        final SpdyEchoTestServerHandler sh = new SpdyEchoTestServerHandler();
        SpdyEchoTestClientHandler ch = new SpdyEchoTestClientHandler(frames.copy());
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new SpdyFrameDecoder(SocketSpdyEchoTest.this.version), new SpdyFrameEncoder(SocketSpdyEchoTest.this.version), sh});
            }
        });
        cb.handler((ChannelHandler)ch);
        Channel sc = ((ServerBootstrap)sb.localAddress(0)).bind().sync().channel();
        int port = ((InetSocketAddress)sc.localAddress()).getPort();
        Channel cc = cb.remoteAddress(NetUtil.LOCALHOST, port).connect().sync().channel();
        cc.writeAndFlush((Object)frames);
        while (ch.counter < frames.writerIndex() - 20 && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    private static class SpdyEchoTestClientHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        final AtomicReference<Throwable> exception = new AtomicReference();
        final ByteBuf frames;
        volatile int counter;

        SpdyEchoTestClientHandler(ByteBuf frames) {
            this.frames = frames;
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)this.frames.getByte(20 + i + lastIdx), (long)actual[i]);
            }
            this.counter += actual.length;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }

    private static class SpdyEchoTestServerHandler
    extends ChannelInboundHandlerAdapter {
        final AtomicReference<Throwable> exception = new AtomicReference();

        private SpdyEchoTestServerHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.write(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }
}

