/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.testsuite.util.BogusSslContextFactory;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SocketStartTlsTest
extends AbstractSocketTest {
    private static final LogLevel LOG_LEVEL = LogLevel.TRACE;
    private static EventExecutorGroup executor;

    @BeforeClass
    public static void createExecutor() {
        executor = new DefaultEventExecutorGroup(2);
    }

    @AfterClass
    public static void shutdownExecutor() throws Exception {
        executor.shutdownGracefully().sync();
    }

    @Test(timeout=30000L)
    public void testStartTls() throws Throwable {
        this.run();
    }

    public void testStartTls(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final EventExecutorGroup executor = SocketStartTlsTest.executor;
        SSLEngine sse = BogusSslContextFactory.getServerContext().createSSLEngine();
        SSLEngine cse = BogusSslContextFactory.getClientContext().createSSLEngine();
        final StartTlsServerHandler sh = new StartTlsServerHandler(sse);
        final StartTlsClientHandler ch = new StartTlsClientHandler(cse);
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                ChannelPipeline p = sch.pipeline();
                p.addLast("logger", (ChannelHandler)new LoggingHandler(LOG_LEVEL));
                p.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(64), new StringDecoder(), new StringEncoder()});
                p.addLast(executor, new ChannelHandler[]{sh});
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                ChannelPipeline p = sch.pipeline();
                p.addLast("logger", (ChannelHandler)new LoggingHandler(LOG_LEVEL));
                p.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(64), new StringDecoder(), new StringEncoder()});
                p.addLast(executor, new ChannelHandler[]{ch});
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        while (cc.isActive() && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (sh.channel.isActive() && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().awaitUninterruptibly();
        cc.close().awaitUninterruptibly();
        sc.close().awaitUninterruptibly();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    private class StartTlsServerHandler
    extends SimpleChannelInboundHandler<String> {
        private final SslHandler sslHandler;
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();

        StartTlsServerHandler(SSLEngine engine) {
            engine.setUseClientMode(false);
            this.sslHandler = new SslHandler(engine, true);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
            if ("StartTlsRequest".equals(msg)) {
                ctx.pipeline().addAfter("logger", "ssl", (ChannelHandler)this.sslHandler);
                ctx.writeAndFlush((Object)"StartTlsResponse\n");
                return;
            }
            Assert.assertEquals((Object)"EncryptedRequest", (Object)msg);
            ctx.writeAndFlush((Object)"EncryptedResponse\n");
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (SocketStartTlsTest.this.logger.isWarnEnabled()) {
                SocketStartTlsTest.this.logger.warn("Unexpected exception from the server side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }

    private class StartTlsClientHandler
    extends SimpleChannelInboundHandler<String> {
        private final SslHandler sslHandler;
        private Future<Channel> handshakeFuture;
        final AtomicReference<Throwable> exception = new AtomicReference();

        StartTlsClientHandler(SSLEngine engine) {
            engine.setUseClientMode(true);
            this.sslHandler = new SslHandler(engine);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.writeAndFlush((Object)"StartTlsRequest\n");
        }

        public void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
            if ("StartTlsResponse".equals(msg)) {
                ctx.pipeline().addAfter("logger", "ssl", (ChannelHandler)this.sslHandler);
                this.handshakeFuture = this.sslHandler.handshakeFuture();
                ctx.writeAndFlush((Object)"EncryptedRequest\n");
                return;
            }
            Assert.assertEquals((Object)"EncryptedResponse", (Object)msg);
            Assert.assertNotNull(this.handshakeFuture);
            Assert.assertTrue((boolean)this.handshakeFuture.isSuccess());
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (SocketStartTlsTest.this.logger.isWarnEnabled()) {
                SocketStartTlsTest.this.logger.warn("Unexpected exception from the client side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }
}

