/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;
import io.netty.handler.codec.serialization.ObjectEncoder;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class SocketObjectEchoTest
extends AbstractSocketTest {
    static final Random random = new Random();
    static final String[] data = new String[1024];

    @Test
    public void testObjectEcho() throws Throwable {
        this.run();
    }

    public void testObjectEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final EchoHandler sh = new EchoHandler();
        final EchoHandler ch = new EchoHandler();
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                sch.pipeline().addLast(new ChannelHandler[]{new ObjectDecoder(ClassResolvers.cacheDisabled((ClassLoader)((Object)((Object)this)).getClass().getClassLoader())), new ObjectEncoder(), sh});
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                sch.pipeline().addLast(new ChannelHandler[]{new ObjectDecoder(ClassResolvers.cacheDisabled((ClassLoader)((Object)((Object)this)).getClass().getClassLoader())), new ObjectEncoder(), ch});
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        for (String element : data) {
            cc.writeAndFlush((Object)element);
        }
        while (ch.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (sh.counter < data.length && sh.exception.get() == null && ch.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        for (int i = 0; i < data.length; ++i) {
            int eLen = random.nextInt(512);
            char[] e = new char[eLen];
            for (int j = 0; j < eLen; ++j) {
                e[j] = (char)(97 + random.nextInt(26));
            }
            SocketObjectEchoTest.data[i] = new String(e);
        }
    }

    private static class EchoHandler
    extends ChannelInboundHandlerAdapter {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;

        private EchoHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Assert.assertEquals((Object)data[this.counter], (Object)msg);
            if (this.channel.parent() != null) {
                this.channel.write(msg);
            }
            ++this.counter;
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }
}

