/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.netty.handler.ipfilter;

import java.net.InetSocketAddress;
import shaded.io.netty.channel.ChannelHandler;
import shaded.io.netty.channel.ChannelHandlerContext;
import shaded.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import shaded.io.netty.handler.ipfilter.IpFilterRule;
import shaded.io.netty.handler.ipfilter.IpFilterRuleType;
import shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final IpFilterRule[] rules;

    public RuleBasedIpFilter(IpFilterRule ... rules) {
        this.rules = ObjectUtil.checkNotNull(rules, "rules");
    }

    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            if (rule == null) break;
            if (!rule.matches(remoteAddress)) continue;
            return rule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return true;
    }
}

