/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageList;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ChannelOutboundBuffer {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final int MIN_INITIAL_CAPACITY = 8;
    MessageList currentMessageList;
    int currentMessageIndex;
    private long currentMessageListSize;
    private MessageList[] messageLists;
    private long[] messageListSizes;
    private MessageList unflushedMessageList;
    private long unflushedMessageListSize;
    private int head;
    private int tail;
    private boolean inFail;
    private final AbstractChannel channel;
    private long pendingOutboundBytes;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> WRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "writable");
    private volatile int writable = 1;

    ChannelOutboundBuffer(AbstractChannel channel) {
        this(channel, 16);
    }

    ChannelOutboundBuffer(AbstractChannel channel, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expected: >= 0)");
        }
        if (initialCapacity >= 8) {
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        } else {
            initialCapacity = 8;
        }
        this.channel = channel;
        this.messageLists = new MessageList[initialCapacity];
        this.messageListSizes = new long[initialCapacity];
    }

    void addMessage(Object msg, ChannelPromise promise) {
        MessageList unflushedMessageList = this.unflushedMessageList;
        if (unflushedMessageList == null) {
            this.unflushedMessageList = unflushedMessageList = MessageList.newInstance();
        }
        unflushedMessageList.add(msg, promise);
        int size = this.channel.calculateMessageSize(msg);
        this.unflushedMessageListSize += (long)size;
        this.incrementPendingOutboundBytes(size);
    }

    void addFlush() {
        MessageList unflushedMessageList = this.unflushedMessageList;
        if (unflushedMessageList == null) {
            return;
        }
        int tail = this.tail;
        this.messageLists[tail] = unflushedMessageList;
        this.messageListSizes[tail] = this.unflushedMessageListSize;
        this.unflushedMessageList = null;
        this.unflushedMessageListSize = 0L;
        this.tail = tail + 1 & this.messageLists.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    private void incrementPendingOutboundBytes(int size) {
        if (size == 0) {
            return;
        }
        long newWriteBufferSize = this.pendingOutboundBytes += (long)size;
        int highWaterMark = this.channel.config().getWriteBufferHighWaterMark();
        if (newWriteBufferSize > (long)highWaterMark && WRITABLE_UPDATER.compareAndSet(this, 1, 0)) {
            this.channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    private void decrementPendingOutboundBytes(long size) {
        if (size == 0L) {
            return;
        }
        long newWriteBufferSize = this.pendingOutboundBytes -= size;
        int lowWaterMark = this.channel.config().getWriteBufferLowWaterMark();
        if ((newWriteBufferSize == 0L || newWriteBufferSize < (long)lowWaterMark) && WRITABLE_UPDATER.compareAndSet(this, 0, 1)) {
            this.channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.messageLists.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        MessageList[] a1 = new MessageList[newCapacity];
        System.arraycopy(this.messageLists, p, a1, 0, r);
        System.arraycopy(this.messageLists, 0, a1, r, p);
        this.messageLists = a1;
        long[] a2 = new long[newCapacity];
        System.arraycopy(this.messageListSizes, p, a2, 0, r);
        System.arraycopy(this.messageListSizes, 0, a2, r, p);
        this.messageListSizes = a2;
        this.head = 0;
        this.tail = n;
    }

    boolean next() {
        this.decrementPendingOutboundBytes(this.currentMessageListSize);
        int h = this.head;
        MessageList e = this.messageLists[h];
        if (e == null) {
            this.currentMessageListSize = 0L;
            this.currentMessageList = null;
            return false;
        }
        this.currentMessageList = this.messageLists[h];
        this.currentMessageIndex = 0;
        this.currentMessageListSize = this.messageListSizes[h];
        this.messageLists[h] = null;
        this.messageListSizes[h] = 0L;
        this.head = h + 1 & this.messageLists.length - 1;
        return true;
    }

    boolean getWritable() {
        return WRITABLE_UPDATER.get(this) == 1;
    }

    int size() {
        return this.tail - this.head & this.messageLists.length - 1;
    }

    boolean isEmpty() {
        return this.head == this.tail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearUnflushed(Throwable cause) {
        MessageList unflushed = this.unflushedMessageList;
        if (unflushed == null) {
            return;
        }
        Object[] messages = unflushed.messages();
        ChannelPromise[] promises = unflushed.promises();
        int size = unflushed.size();
        try {
            for (int i = 0; i < size; ++i) {
                ReferenceCountUtil.release(messages[i]);
                ChannelPromise p = promises[i];
                if (p instanceof VoidChannelPromise || p.tryFailure(cause)) continue;
                logger.warn("Promise done already: {} - new exception is:", (Object)p, (Object)cause);
            }
        }
        finally {
            unflushed.recycle();
            this.decrementPendingOutboundBytes(this.unflushedMessageListSize);
            this.unflushedMessageListSize = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fail(Throwable cause) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            if (this.currentMessageList == null && !this.next()) {
                return;
            }
            do {
                if (this.currentMessageList == null) continue;
                MessageList current = this.currentMessageList;
                Object[] messages = current.messages();
                ChannelPromise[] promises = current.promises();
                int size = current.size();
                try {
                    for (int i = this.currentMessageIndex; i < size; ++i) {
                        ReferenceCountUtil.release(messages[i]);
                        ChannelPromise p = promises[i];
                        if (p instanceof VoidChannelPromise || p.tryFailure(cause)) continue;
                        logger.warn("Promise done already: {} - new exception is:", (Object)p, (Object)cause);
                    }
                }
                finally {
                    current.recycle();
                }
            } while (this.next());
        }
        finally {
            this.inFail = false;
        }
    }
}

