/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.lib;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginPropsUDT {
    protected static final String AOL_CPP_COMPILER = "cpp.compiler";
    protected static final String AOL_JNI_EXTENSION = "jni.extension";
    protected static final String AOL_LINKER_DEPENDENCY = "linker.dependency";
    protected static final String AOL_SHARED_PREFIX = "shared.prefix";
    protected static final String EMPTY_VALUE = "";
    protected static final Logger log = LoggerFactory.getLogger(PluginPropsUDT.class);
    protected static final String NAR_AOL_PROPERTIES = "aol.properties";
    protected static final String OS_ARCH = System.getProperty("os.arch");
    protected static final String OS_NAME = System.getProperty("os.name");
    protected static final Properties props = new Properties();

    protected static List<String> currentDependencyLibraries() {
        String[] entryArray;
        ArrayList<String> list = new ArrayList<String>();
        String entryText = PluginPropsUDT.property(PluginPropsUDT.currentNarKeyLinkerDependency());
        if (entryText == null || entryText.length() == 0) {
            return list;
        }
        for (String entry : entryArray = entryText.split("\\s")) {
            list.add(entry.trim());
        }
        return list;
    }

    protected static String currentNarKey() {
        return PluginPropsUDT.formatNarKey(PluginPropsUDT.narARCH(), PluginPropsUDT.narOS(), PluginPropsUDT.narLINK());
    }

    protected static String currentNarKey(String suffix) {
        return PluginPropsUDT.currentNarKey() + "." + suffix;
    }

    protected static String currentNarKeyCppCompiler() {
        return PluginPropsUDT.currentNarKey(AOL_CPP_COMPILER);
    }

    protected static String currentNarKeyJniExtension() {
        return PluginPropsUDT.currentNarKey(AOL_JNI_EXTENSION);
    }

    protected static String currentNarKeyLinkerDependency() {
        return PluginPropsUDT.currentNarKey(AOL_LINKER_DEPENDENCY);
    }

    protected static String currentNarKeySharedPrefix() {
        return PluginPropsUDT.currentNarKey(AOL_SHARED_PREFIX);
    }

    protected static String currentNarPath() {
        return PluginPropsUDT.formatNarPath(PluginPropsUDT.narARCH(), PluginPropsUDT.narOS(), PluginPropsUDT.narLINK());
    }

    protected static List<String> currentReleaseLibraries(String coreName) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : PluginPropsUDT.currentDependencyLibraries()) {
            String path = PluginPropsUDT.formatMainReleasePath(name);
            list.add(path);
        }
        String name = PluginPropsUDT.formatMainLibraryName(coreName);
        String path = PluginPropsUDT.formatMainReleasePath(name);
        list.add(path);
        return list;
    }

    protected static List<String> currentStagingLibraries(String coreName) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : PluginPropsUDT.currentDependencyLibraries()) {
            String path = PluginPropsUDT.formatTestingDependencyPath(name);
            list.add(path);
        }
        String path = PluginPropsUDT.formatMainStagingPath(coreName);
        list.add(path);
        return list;
    }

    protected static List<String> currentTestingLibraries(String coreName) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : PluginPropsUDT.currentDependencyLibraries()) {
            String path = PluginPropsUDT.formatTestingDependencyPath(name);
            list.add(path);
        }
        String path = PluginPropsUDT.formatMainTestingPath(coreName);
        list.add(path);
        return list;
    }

    protected static String formatMainLibraryName(String coreName) {
        String prefix = PluginPropsUDT.property(PluginPropsUDT.currentNarKeySharedPrefix());
        String extension = PluginPropsUDT.property(PluginPropsUDT.currentNarKeyJniExtension());
        return String.format("%s%s.%s", prefix, coreName, extension);
    }

    protected static String formatMainReleasePath(String name) {
        String aol = PluginPropsUDT.currentNarPath();
        return String.format("/lib/%s/jni/%s", aol, name);
    }

    protected static String formatMainStagingPath(String coreName) {
        String aol = PluginPropsUDT.currentNarPath();
        String mainName = PluginPropsUDT.formatMainLibraryName(coreName);
        return String.format("/%s-%s-jni/lib/%s/jni/%s", coreName, aol, aol, mainName);
    }

    protected static String formatMainTestingPath(String coreName) {
        String mainName = PluginPropsUDT.formatMainLibraryName(coreName);
        return String.format("/%s", mainName);
    }

    protected static String formatNarKey(String arch, String os, String link) {
        return String.format("%s.%s.%s", arch, os, link);
    }

    protected static String formatNarPath(String arch, String os, String link) {
        return String.format("%s-%s-%s", arch, os, link);
    }

    protected static String formatTestingDependencyPath(String name) {
        String aol = PluginPropsUDT.currentNarPath();
        return String.format("/aol/%s/lib/%s", aol, name);
    }

    protected static boolean isSupportedPlatform() {
        return !EMPTY_VALUE.equals(PluginPropsUDT.property(PluginPropsUDT.currentNarKeyCppCompiler()));
    }

    protected static String narARCH() {
        return OS_ARCH;
    }

    protected static String narLINK() {
        return "gpp";
    }

    protected static String narOS() {
        if (OS_NAME.contains("Mac OS X")) {
            return "MacOSX";
        }
        if (OS_NAME.contains("Windows")) {
            return "Windows";
        }
        return OS_NAME;
    }

    protected static String property(String key) {
        String value = props.getProperty(key);
        if (value instanceof String) {
            return value;
        }
        return EMPTY_VALUE;
    }

    static {
        try {
            log.info("ARCH/OS/LINK = {}/{}/{}", new Object[]{PluginPropsUDT.narARCH(), PluginPropsUDT.narOS(), PluginPropsUDT.narLINK()});
            log.debug("Loading aol.properties.");
            InputStream input = PluginPropsUDT.class.getClassLoader().getResourceAsStream(NAR_AOL_PROPERTIES);
            props.load(input);
        }
        catch (Throwable e) {
            log.error("Failed to load aol.properties.", e);
        }
    }
}

