/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.buffer.BufType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.embedded.AbstractEmbeddedChannel;

public class EmbeddedByteChannel
extends AbstractEmbeddedChannel<ByteBuf> {
    private static final ChannelMetadata METADATA = new ChannelMetadata(BufType.BYTE, false);

    public EmbeddedByteChannel(ChannelHandler ... handlers) {
        super(Unpooled.buffer(), handlers);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ByteBuf inboundBuffer() {
        return this.pipeline().inboundByteBuffer();
    }

    @Override
    public ByteBuf lastOutboundBuffer() {
        return (ByteBuf)this.lastOutboundBuffer;
    }

    @Override
    public ByteBuf readOutbound() {
        if (!this.lastOutboundBuffer().isReadable()) {
            return null;
        }
        try {
            ByteBuf byteBuf = this.lastOutboundBuffer().readBytes(this.lastOutboundBuffer().readableBytes());
            return byteBuf;
        }
        finally {
            this.lastOutboundBuffer().clear();
        }
    }

    @Override
    protected void writeInbound0(ByteBuf data) {
        this.inboundBuffer().writeBytes(data);
    }

    @Override
    protected boolean hasReadableOutboundBuffer() {
        return this.lastOutboundBuffer().isReadable();
    }

    @Override
    protected void doFlushByteBuffer(ByteBuf buf) throws Exception {
        this.lastOutboundBuffer().writeBytes(buf);
    }
}

