/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.BufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedByteChannel;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.ArrayDeque;
import java.util.Queue;

public abstract class HttpContentEncoder
extends MessageToMessageCodec<HttpMessage, HttpObject> {
    private final Queue<String> acceptEncodingQueue = new ArrayDeque<String>();
    private EmbeddedByteChannel encoder;
    private HttpMessage message;
    private boolean encodeStarted;

    @Override
    protected Object decode(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
        String acceptedEncoding = msg.headers().get("Accept-Encoding");
        if (acceptedEncoding == null) {
            acceptedEncoding = "identity";
        }
        this.acceptEncodingQueue.add(acceptedEncoding);
        BufUtil.retain(msg);
        return msg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object encode(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().code() == 100) {
            BufUtil.retain(msg);
            return msg;
        }
        if (msg instanceof FullHttpMessage && !((FullHttpMessage)msg).data().isReadable()) {
            String acceptEncoding = this.acceptEncodingQueue.poll();
            if (acceptEncoding != null) return ((FullHttpMessage)msg).retain();
            throw new IllegalStateException("cannot send more responses than requests");
        }
        if (msg instanceof HttpMessage) {
            assert (this.message == null);
            if (msg instanceof HttpContent) {
                if (msg instanceof HttpRequest) {
                    HttpRequest req = (HttpRequest)msg;
                    this.message = new DefaultHttpRequest(req.getProtocolVersion(), req.getMethod(), req.getUri());
                    this.message.headers().set(req.headers());
                } else {
                    if (!(msg instanceof HttpResponse)) return msg;
                    HttpResponse res = (HttpResponse)msg;
                    this.message = new DefaultHttpResponse(res.getProtocolVersion(), res.getStatus());
                    this.message.headers().set(res.headers());
                }
            } else {
                this.message = (HttpMessage)msg;
            }
            this.cleanup();
        }
        if (!(msg instanceof HttpContent)) return null;
        HttpContent c = (HttpContent)msg;
        if (!this.encodeStarted) {
            this.encodeStarted = true;
            HttpMessage message = this.message;
            HttpHeaders headers = message.headers();
            this.message = null;
            String acceptEncoding = this.acceptEncodingQueue.poll();
            if (acceptEncoding == null) {
                throw new IllegalStateException("cannot send more responses than requests");
            }
            Result result = this.beginEncode(message, c, acceptEncoding);
            if (result == null) {
                if (!(c instanceof LastHttpContent)) return new Object[]{message, new DefaultHttpContent(c.data().retain())};
                return new Object[]{message, new DefaultLastHttpContent(c.data().retain())};
            }
            this.encoder = result.contentEncoder();
            headers.set("Content-Encoding", result.targetContentEncoding());
            Object[] encoded = this.encodeContent(message, c);
            if (HttpHeaders.isTransferEncodingChunked(message) || encoded.length != 3 || !headers.contains("Content-Length")) return encoded;
            long length = ((ByteBufHolder)encoded[1]).data().readableBytes() + ((ByteBufHolder)encoded[2]).data().readableBytes();
            headers.set("Content-Length", Long.toString(length));
            return encoded;
        }
        if (this.encoder == null) return c.retain();
        return this.encodeContent(null, c);
    }

    private Object[] encodeContent(HttpMessage header, HttpContent c) {
        ByteBuf newContent = Unpooled.buffer();
        ByteBuf content = c.data();
        this.encode(content, newContent);
        if (c instanceof LastHttpContent) {
            ByteBuf lastProduct = Unpooled.buffer();
            this.finishEncode(lastProduct);
            if (lastProduct.isReadable()) {
                if (header == null) {
                    return new Object[]{new DefaultHttpContent(newContent), new DefaultLastHttpContent(lastProduct)};
                }
                return new Object[]{header, new DefaultHttpContent(newContent), new DefaultLastHttpContent(lastProduct)};
            }
            if (header == null) {
                return new Object[]{new DefaultLastHttpContent(newContent)};
            }
            return new Object[]{header, new DefaultLastHttpContent(newContent)};
        }
        if (header == null) {
            return new Object[]{new DefaultHttpContent(newContent)};
        }
        return new Object[]{header, new DefaultHttpContent(newContent)};
    }

    protected abstract Result beginEncode(HttpMessage var1, HttpContent var2, String var3) throws Exception;

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.afterRemove(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.channelInactive(ctx);
    }

    private void cleanup() {
        if (this.encoder != null) {
            this.finishEncode(Unpooled.buffer());
        }
    }

    private void encode(ByteBuf in, ByteBuf out) {
        this.encoder.writeOutbound(in);
        this.fetchEncoderOutput(out);
    }

    private void finishEncode(ByteBuf out) {
        if (this.encoder.finish()) {
            this.fetchEncoderOutput(out);
        }
        this.encodeStarted = false;
        this.encoder = null;
    }

    private void fetchEncoderOutput(ByteBuf out) {
        ByteBuf buf;
        while ((buf = this.encoder.readOutbound()) != null) {
            out.writeBytes(buf);
        }
    }

    public static final class Result {
        private final String targetContentEncoding;
        private final EmbeddedByteChannel contentEncoder;

        public Result(String targetContentEncoding, EmbeddedByteChannel contentEncoder) {
            if (targetContentEncoding == null) {
                throw new NullPointerException("targetContentEncoding");
            }
            if (contentEncoder == null) {
                throw new NullPointerException("contentEncoder");
            }
            this.targetContentEncoding = targetContentEncoding;
            this.contentEncoder = contentEncoder;
        }

        public String targetContentEncoding() {
            return this.targetContentEncoding;
        }

        public EmbeddedByteChannel contentEncoder() {
            return this.contentEncoder;
        }
    }
}

