/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundByteHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.PartialFlushException;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.EncoderException;

public abstract class ByteToByteEncoder
extends ChannelOutboundByteHandlerAdapter {
    @Override
    protected void flush(ChannelHandlerContext ctx, ByteBuf in, ChannelPromise promise) throws Exception {
        ByteBuf out = ctx.nextOutboundByteBuffer();
        boolean encoded = false;
        while (in.isReadable()) {
            int oldInSize = in.readableBytes();
            try {
                this.encode(ctx, in, out);
                encoded = true;
            }
            catch (Throwable t) {
                Throwable cause = t instanceof CodecException ? t : new EncoderException(t);
                if (encoded) {
                    cause = new PartialFlushException("Unable to encoded all bytes", cause);
                }
                in.discardSomeReadBytes();
                promise.setFailure(cause);
                return;
            }
            if (oldInSize != in.readableBytes()) continue;
            break;
        }
        ctx.flush(promise);
    }

    protected abstract void encode(ChannelHandlerContext var1, ByteBuf var2, ByteBuf var3) throws Exception;
}

