/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.aio;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.socket.aio.AioSocketChannel;
import io.netty.channel.socket.aio.AioSocketChannelConfig;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class DefaultAioSocketChannelConfig
extends DefaultChannelConfig
implements AioSocketChannelConfig {
    private final AtomicReference<NetworkChannel> javaChannel = new AtomicReference();
    private volatile boolean allowHalfClosure;
    private volatile long readTimeoutInMillis;
    private volatile long writeTimeoutInMillis;
    private Map<SocketOption<?>, Object> options = PlatformDependent.newConcurrentHashMap();
    private static final int DEFAULT_RCV_BUF_SIZE = 32768;
    private static final int DEFAULT_SND_BUF_SIZE = 32768;
    private static final int DEFAULT_SO_LINGER = -1;
    private static final boolean DEFAULT_SO_KEEP_ALIVE = false;
    private static final int DEFAULT_IP_TOS = 0;
    private static final boolean DEFAULT_SO_REUSEADDR = false;
    private static final boolean DEFAULT_TCP_NODELAY = false;

    DefaultAioSocketChannelConfig(AioSocketChannel channel) {
        super(channel);
        this.enableTcpNoDelay();
    }

    DefaultAioSocketChannelConfig(AioSocketChannel channel, NetworkChannel javaChannel) {
        super(channel);
        this.javaChannel.set(javaChannel);
        this.enableTcpNoDelay();
    }

    private void enableTcpNoDelay() {
        if (PlatformDependent.canEnableTcpNoDelayByDefault()) {
            try {
                this.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.TCP_NODELAY, ChannelOption.SO_KEEPALIVE, ChannelOption.SO_REUSEADDR, ChannelOption.SO_LINGER, ChannelOption.IP_TOS, ChannelOption.AIO_READ_TIMEOUT, ChannelOption.AIO_WRITE_TIMEOUT, ChannelOption.ALLOW_HALF_CLOSURE);
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) {
        if (option == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (option == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (option == ChannelOption.TCP_NODELAY) {
            return (T)Boolean.valueOf(this.isTcpNoDelay());
        }
        if (option == ChannelOption.SO_KEEPALIVE) {
            return (T)Boolean.valueOf(this.isKeepAlive());
        }
        if (option == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (option == ChannelOption.SO_LINGER) {
            return (T)Integer.valueOf(this.getSoLinger());
        }
        if (option == ChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getTrafficClass());
        }
        if (option == ChannelOption.AIO_READ_TIMEOUT) {
            return (T)Long.valueOf(this.getReadTimeout());
        }
        if (option == ChannelOption.AIO_WRITE_TIMEOUT) {
            return (T)Long.valueOf(this.getWriteTimeout());
        }
        if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        return super.getOption(option);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)value);
        } else if (option == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)value);
        } else if (option == ChannelOption.TCP_NODELAY) {
            this.setTcpNoDelay((Boolean)value);
        } else if (option == ChannelOption.SO_KEEPALIVE) {
            this.setKeepAlive((Boolean)value);
        } else if (option == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)value);
        } else if (option == ChannelOption.SO_LINGER) {
            this.setSoLinger((Integer)value);
        } else if (option == ChannelOption.IP_TOS) {
            this.setTrafficClass((Integer)value);
        } else if (option == ChannelOption.AIO_READ_TIMEOUT) {
            this.setReadTimeout((Long)value);
        } else if (option == ChannelOption.AIO_WRITE_TIMEOUT) {
            this.setWriteTimeout((Long)value);
        } else if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            this.setAllowHalfClosure((Boolean)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    @Override
    public int getReceiveBufferSize() {
        return (Integer)this.getOption(StandardSocketOptions.SO_RCVBUF, 32768);
    }

    @Override
    public int getSendBufferSize() {
        return (Integer)this.getOption(StandardSocketOptions.SO_SNDBUF, 32768);
    }

    @Override
    public int getSoLinger() {
        return (Integer)this.getOption(StandardSocketOptions.SO_LINGER, -1);
    }

    @Override
    public int getTrafficClass() {
        return (Integer)this.getOption(StandardSocketOptions.IP_TOS, 0);
    }

    @Override
    public boolean isKeepAlive() {
        return (Boolean)this.getOption(StandardSocketOptions.SO_KEEPALIVE, false);
    }

    @Override
    public boolean isReuseAddress() {
        return (Boolean)this.getOption(StandardSocketOptions.SO_REUSEADDR, false);
    }

    @Override
    public boolean isTcpNoDelay() {
        return (Boolean)this.getOption(StandardSocketOptions.TCP_NODELAY, false);
    }

    @Override
    public AioSocketChannelConfig setKeepAlive(boolean keepAlive) {
        this.setOption(StandardSocketOptions.SO_KEEPALIVE, (Object)keepAlive);
        return this;
    }

    @Override
    public AioSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AioSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        this.setOption(StandardSocketOptions.SO_RCVBUF, (Object)receiveBufferSize);
        return this;
    }

    @Override
    public AioSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        this.setOption(StandardSocketOptions.SO_REUSEADDR, (Object)reuseAddress);
        return this;
    }

    @Override
    public AioSocketChannelConfig setSendBufferSize(int sendBufferSize) {
        this.setOption(StandardSocketOptions.SO_SNDBUF, (Object)sendBufferSize);
        return this;
    }

    @Override
    public AioSocketChannelConfig setSoLinger(int soLinger) {
        this.setOption(StandardSocketOptions.SO_LINGER, (Object)soLinger);
        return this;
    }

    @Override
    public AioSocketChannelConfig setTcpNoDelay(boolean tcpNoDelay) {
        this.setOption(StandardSocketOptions.TCP_NODELAY, (Object)tcpNoDelay);
        return this;
    }

    @Override
    public AioSocketChannelConfig setTrafficClass(int trafficClass) {
        this.setOption(StandardSocketOptions.IP_TOS, (Object)trafficClass);
        return this;
    }

    private Object getOption(SocketOption option, Object defaultValue) {
        if (this.javaChannel.get() == null) {
            Object value = this.options.get(option);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }
        try {
            return this.javaChannel.get().getOption(option);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void setOption(SocketOption option, Object defaultValue) {
        if (this.javaChannel.get() == null) {
            this.options.put(option, defaultValue);
            return;
        }
        try {
            this.javaChannel.get().setOption(option, defaultValue);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public AioSocketChannelConfig setReadTimeout(long readTimeoutInMillis) {
        if (readTimeoutInMillis < 0L) {
            throw new IllegalArgumentException("readTimeoutInMillis: " + readTimeoutInMillis);
        }
        this.readTimeoutInMillis = readTimeoutInMillis;
        return this;
    }

    @Override
    public AioSocketChannelConfig setWriteTimeout(long writeTimeoutInMillis) {
        if (writeTimeoutInMillis < 0L) {
            throw new IllegalArgumentException("writeTimeoutInMillis: " + writeTimeoutInMillis);
        }
        this.writeTimeoutInMillis = writeTimeoutInMillis;
        return this;
    }

    @Override
    public long getReadTimeout() {
        return this.readTimeoutInMillis;
    }

    @Override
    public long getWriteTimeout() {
        return this.writeTimeoutInMillis;
    }

    @Override
    public boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    @Override
    public AioSocketChannelConfig setAllowHalfClosure(boolean allowHalfClosure) {
        this.allowHalfClosure = allowHalfClosure;
        return this;
    }

    void assign(NetworkChannel javaChannel) {
        if (javaChannel == null) {
            throw new NullPointerException("javaChannel");
        }
        if (this.javaChannel.compareAndSet(null, javaChannel)) {
            this.propagateOptions();
        }
    }

    private void propagateOptions() {
        for (SocketOption<?> option : this.options.keySet()) {
            Object value = this.options.remove(option);
            if (value == null) continue;
            try {
                this.javaChannel.get().setOption(option, value);
            }
            catch (IOException e) {
                throw new ChannelException(e);
            }
        }
        this.options = null;
    }

    @Override
    public AioSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        return (AioSocketChannelConfig)super.setConnectTimeoutMillis(connectTimeoutMillis);
    }

    @Override
    public AioSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        return (AioSocketChannelConfig)super.setWriteSpinCount(writeSpinCount);
    }

    @Override
    public AioSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        return (AioSocketChannelConfig)super.setAllocator(allocator);
    }

    @Override
    public AioSocketChannelConfig setAutoRead(boolean autoRead) {
        return (AioSocketChannelConfig)super.setAutoRead(autoRead);
    }
}

