/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToByteEncoder;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.handler.codec.compression.Snappy;
import io.netty.handler.codec.compression.SnappyChecksumUtil;

public class SnappyFramedEncoder
extends ByteToByteEncoder {
    private static final int MIN_COMPRESSIBLE_LENGTH = 18;
    private static final byte[] STREAM_START = new byte[]{-128, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    private final Snappy snappy = new Snappy();
    private boolean started;

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        int dataLength;
        if (!in.isReadable()) {
            return;
        }
        if (!this.started) {
            this.started = true;
            out.writeBytes(STREAM_START);
        }
        if ((dataLength = in.readableBytes()) > 18) {
            ByteBuf slice;
            int lengthIdx;
            while (true) {
                lengthIdx = out.writerIndex() + 1;
                out.writeInt(0);
                if (dataLength <= 32768) break;
                slice = in.readSlice(32768);
                SnappyFramedEncoder.calculateAndWriteChecksum(slice, out);
                this.snappy.encode(slice, out, 32768);
                SnappyFramedEncoder.setChunkLength(out, lengthIdx);
                dataLength -= 32768;
            }
            slice = in.readSlice(dataLength);
            SnappyFramedEncoder.calculateAndWriteChecksum(slice, out);
            this.snappy.encode(slice, out, dataLength);
            SnappyFramedEncoder.setChunkLength(out, lengthIdx);
        } else {
            out.writeByte(1);
            SnappyFramedEncoder.writeChunkLength(out, dataLength + 4);
            SnappyFramedEncoder.calculateAndWriteChecksum(in, out);
            out.writeBytes(in, dataLength);
        }
    }

    private static void setChunkLength(ByteBuf out, int lengthIdx) {
        int chunkLength = out.writerIndex() - lengthIdx - 3;
        if (chunkLength >>> 24 != 0) {
            throw new CompressionException("compressed data too large: " + chunkLength);
        }
        out.setByte(lengthIdx, chunkLength & 0xFF);
        out.setByte(lengthIdx + 1, chunkLength >>> 8 & 0xFF);
        out.setByte(lengthIdx + 2, chunkLength >>> 16 & 0xFF);
    }

    private static void writeChunkLength(ByteBuf out, int chunkLength) {
        out.writeByte(chunkLength & 0xFF);
        out.writeByte(chunkLength >>> 8 & 0xFF);
        out.writeByte(chunkLength >>> 16 & 0xFF);
    }

    private static void calculateAndWriteChecksum(ByteBuf slice, ByteBuf out) {
        int checksum = SnappyChecksumUtil.calculateChecksum(slice);
        out.writeByte(checksum & 0xFF);
        out.writeByte(checksum >>> 8 & 0xFF);
        out.writeByte(checksum >>> 16 & 0xFF);
        out.writeByte(checksum >>> 24);
    }
}

