/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.Buf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.ReferenceCounted;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelHandlerContext;
import io.netty.channel.EventExecutor;
import io.netty.channel.EventExecutorGroup;
import io.netty.channel.FileRegion;
import io.netty.util.internal.InternalLogger;
import io.netty.util.internal.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;

final class DefaultChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    final Channel channel;
    final DefaultChannelHandlerContext head;
    final DefaultChannelHandlerContext tail;
    private final Map<String, DefaultChannelHandlerContext> name2ctx = new HashMap<String, DefaultChannelHandlerContext>(4);
    private boolean firedChannelActive;
    private boolean fireInboundBufferUpdatedOnActivation;
    final Map<EventExecutorGroup, EventExecutor> childExecutors = new IdentityHashMap<EventExecutorGroup, EventExecutor>();
    volatile boolean inboundBufferFreed;
    volatile boolean outboundBufferFreed;

    public DefaultChannelPipeline(Channel channel) {
        HeadHandler headHandler;
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        this.channel = channel;
        TailHandler tailHandler = new TailHandler();
        this.tail = new DefaultChannelHandlerContext(this, DefaultChannelPipeline.generateName(tailHandler), tailHandler);
        switch (channel.metadata().bufferType()) {
            case BYTE: {
                headHandler = new ByteHeadHandler(channel.unsafe());
                break;
            }
            case MESSAGE: {
                headHandler = new MessageHeadHandler(channel.unsafe());
                break;
            }
            default: {
                throw new Error("unknown buffer type: " + (Object)((Object)channel.metadata().bufferType()));
            }
        }
        this.head = new DefaultChannelHandlerContext(this, DefaultChannelPipeline.generateName(headHandler), headHandler);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPipeline addFirst(String name, ChannelHandler handler) {
        return this.addFirst(null, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addFirst(EventExecutorGroup group, final String name, ChannelHandler handler) {
        DefaultChannelHandlerContext newCtx;
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            this.checkDuplicateName(name);
            newCtx = new DefaultChannelHandlerContext(this, group, name, handler);
            if (!newCtx.channel().isRegistered() || newCtx.executor().inEventLoop()) {
                this.addFirst0(name, newCtx);
                return this;
            }
        }
        newCtx.executeOnEventLoop(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultChannelPipeline defaultChannelPipeline = DefaultChannelPipeline.this;
                synchronized (defaultChannelPipeline) {
                    DefaultChannelPipeline.this.checkDuplicateName(name);
                    DefaultChannelPipeline.this.addFirst0(name, newCtx);
                }
            }
        });
        return this;
    }

    private void addFirst0(String name, DefaultChannelHandlerContext newCtx) {
        DefaultChannelHandlerContext nextCtx = this.head.next;
        newCtx.prev = this.head;
        newCtx.next = nextCtx;
        DefaultChannelPipeline.callBeforeAdd(newCtx);
        this.head.next = newCtx;
        nextCtx.prev = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callAfterAdd(newCtx);
    }

    @Override
    public ChannelPipeline addLast(String name, ChannelHandler handler) {
        return this.addLast(null, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addLast(EventExecutorGroup group, final String name, ChannelHandler handler) {
        DefaultChannelHandlerContext newCtx;
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            this.checkDuplicateName(name);
            newCtx = new DefaultChannelHandlerContext(this, group, name, handler);
            if (!newCtx.channel().isRegistered() || newCtx.executor().inEventLoop()) {
                this.addLast0(name, newCtx);
                return this;
            }
        }
        newCtx.executeOnEventLoop(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultChannelPipeline defaultChannelPipeline = DefaultChannelPipeline.this;
                synchronized (defaultChannelPipeline) {
                    DefaultChannelPipeline.this.checkDuplicateName(name);
                    DefaultChannelPipeline.this.addLast0(name, newCtx);
                }
            }
        });
        return this;
    }

    private void addLast0(String name, DefaultChannelHandlerContext newCtx) {
        DefaultChannelHandlerContext prev;
        newCtx.prev = prev = this.tail.prev;
        newCtx.next = this.tail;
        DefaultChannelPipeline.callBeforeAdd(newCtx);
        prev.next = newCtx;
        this.tail.prev = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callAfterAdd(newCtx);
    }

    @Override
    public ChannelPipeline addBefore(String baseName, String name, ChannelHandler handler) {
        return this.addBefore(null, baseName, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addBefore(EventExecutorGroup group, String baseName, final String name, ChannelHandler handler) {
        DefaultChannelHandlerContext newCtx;
        DefaultChannelHandlerContext ctx;
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            ctx = this.getContextOrDie(baseName);
            this.checkDuplicateName(name);
            newCtx = new DefaultChannelHandlerContext(this, group, name, handler);
            if (!newCtx.channel().isRegistered() || newCtx.executor().inEventLoop()) {
                this.addBefore0(name, ctx, newCtx);
                return this;
            }
        }
        newCtx.executeOnEventLoop(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultChannelPipeline defaultChannelPipeline = DefaultChannelPipeline.this;
                synchronized (defaultChannelPipeline) {
                    DefaultChannelPipeline.this.checkDuplicateName(name);
                    DefaultChannelPipeline.this.addBefore0(name, ctx, newCtx);
                }
            }
        });
        return this;
    }

    private void addBefore0(String name, DefaultChannelHandlerContext ctx, DefaultChannelHandlerContext newCtx) {
        newCtx.prev = ctx.prev;
        newCtx.next = ctx;
        DefaultChannelPipeline.callBeforeAdd(newCtx);
        ctx.prev.next = newCtx;
        ctx.prev = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callAfterAdd(newCtx);
    }

    @Override
    public ChannelPipeline addAfter(String baseName, String name, ChannelHandler handler) {
        return this.addAfter(null, baseName, name, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelPipeline addAfter(EventExecutorGroup group, String baseName, final String name, ChannelHandler handler) {
        DefaultChannelHandlerContext newCtx;
        DefaultChannelHandlerContext ctx;
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            ctx = this.getContextOrDie(baseName);
            this.checkDuplicateName(name);
            newCtx = new DefaultChannelHandlerContext(this, group, name, handler);
            if (!newCtx.channel().isRegistered() || newCtx.executor().inEventLoop()) {
                this.addAfter0(name, ctx, newCtx);
                return this;
            }
        }
        newCtx.executeOnEventLoop(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultChannelPipeline defaultChannelPipeline = DefaultChannelPipeline.this;
                synchronized (defaultChannelPipeline) {
                    DefaultChannelPipeline.this.checkDuplicateName(name);
                    DefaultChannelPipeline.this.addAfter0(name, ctx, newCtx);
                }
            }
        });
        return this;
    }

    private void addAfter0(String name, DefaultChannelHandlerContext ctx, DefaultChannelHandlerContext newCtx) {
        this.checkDuplicateName(name);
        newCtx.prev = ctx;
        newCtx.next = ctx.next;
        DefaultChannelPipeline.callBeforeAdd(newCtx);
        ctx.next.prev = newCtx;
        ctx.next = newCtx;
        this.name2ctx.put(name, newCtx);
        this.callAfterAdd(newCtx);
    }

    @Override
    public ChannelPipeline addFirst(ChannelHandler ... handlers) {
        return this.addFirst((EventExecutorGroup)null, handlers);
    }

    @Override
    public ChannelPipeline addFirst(EventExecutorGroup executor, ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        if (handlers.length == 0 || handlers[0] == null) {
            return this;
        }
        for (int size = 1; size < handlers.length && handlers[size] != null; ++size) {
        }
        for (int i = size - 1; i >= 0; --i) {
            ChannelHandler h = handlers[i];
            this.addFirst(executor, DefaultChannelPipeline.generateName(h), h);
        }
        return this;
    }

    @Override
    public ChannelPipeline addLast(ChannelHandler ... handlers) {
        return this.addLast((EventExecutorGroup)null, handlers);
    }

    @Override
    public ChannelPipeline addLast(EventExecutorGroup executor, ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        for (ChannelHandler h : handlers) {
            if (h == null) break;
            this.addLast(executor, DefaultChannelPipeline.generateName(h), h);
        }
        return this;
    }

    private static String generateName(ChannelHandler handler) {
        String type = handler.getClass().getSimpleName();
        StringBuilder buf = new StringBuilder(type.length() + 10);
        buf.append(type);
        buf.append("-0");
        buf.append(Long.toHexString((long)System.identityHashCode(handler) & 0xFFFFFFFFL | 0x100000000L));
        buf.setCharAt(buf.length() - 9, 'x');
        return buf.toString();
    }

    @Override
    public ChannelPipeline remove(ChannelHandler handler) {
        this.remove(this.getContextOrDie(handler), false);
        return this;
    }

    @Override
    public ChannelPipeline removeAndForward(ChannelHandler handler) {
        this.remove(this.getContextOrDie(handler), true);
        return this;
    }

    @Override
    public ChannelHandler remove(String name) {
        return this.remove(this.getContextOrDie(name), false).handler();
    }

    @Override
    public ChannelHandler removeAndForward(String name) {
        return this.remove(this.getContextOrDie(name), true).handler();
    }

    @Override
    public <T extends ChannelHandler> T remove(Class<T> handlerType) {
        return (T)this.remove(this.getContextOrDie(handlerType), false).handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultChannelHandlerContext remove(final DefaultChannelHandlerContext ctx, final boolean forward) {
        DefaultChannelHandlerContext context;
        Future<?> future;
        assert (ctx != this.head && ctx != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            if (!ctx.channel().isRegistered() || ctx.executor().inEventLoop()) {
                this.remove0(ctx, forward);
                return ctx;
            }
            future = ctx.executor().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DefaultChannelPipeline defaultChannelPipeline = DefaultChannelPipeline.this;
                    synchronized (defaultChannelPipeline) {
                        DefaultChannelPipeline.this.remove0(ctx, forward);
                    }
                }
            });
            context = ctx;
        }
        DefaultChannelHandlerContext.waitForFuture(future);
        return context;
    }

    @Override
    public <T extends ChannelHandler> T removeAndForward(Class<T> handlerType) {
        return (T)this.remove(this.getContextOrDie(handlerType), true).handler();
    }

    private void remove0(DefaultChannelHandlerContext ctx, boolean forward) {
        DefaultChannelHandlerContext next;
        DefaultChannelPipeline.callBeforeRemove(ctx);
        DefaultChannelHandlerContext prev = ctx.prev;
        prev.next = next = ctx.next;
        next.prev = prev;
        this.name2ctx.remove(ctx.name());
        this.callAfterRemove(ctx, forward);
    }

    @Override
    public ChannelHandler removeFirst() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        return this.remove(this.head.next, false).handler();
    }

    @Override
    public ChannelHandler removeLast() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        return this.remove(this.tail.prev, false).handler();
    }

    @Override
    public ChannelPipeline replace(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        this.replace(this.getContextOrDie(oldHandler), newName, newHandler, false);
        return this;
    }

    @Override
    public ChannelPipeline replaceAndForward(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        this.replace(this.getContextOrDie(oldHandler), newName, newHandler, true);
        return this;
    }

    @Override
    public ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        return this.replace(this.getContextOrDie(oldName), newName, newHandler, false);
    }

    @Override
    public ChannelHandler replaceAndForward(String oldName, String newName, ChannelHandler newHandler) {
        return this.replace(this.getContextOrDie(oldName), newName, newHandler, true);
    }

    @Override
    public <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        return (T)this.replace(this.getContextOrDie(oldHandlerType), newName, newHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelHandler replace(final DefaultChannelHandlerContext ctx, final String newName, ChannelHandler newHandler, final boolean forward) {
        Future<?> future;
        assert (ctx != this.head && ctx != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelHandlerContext newCtx;
            boolean sameName = ctx.name().equals(newName);
            if (!sameName) {
                this.checkDuplicateName(newName);
            }
            if (!(newCtx = new DefaultChannelHandlerContext(this, ctx.executor, newName, newHandler)).channel().isRegistered() || newCtx.executor().inEventLoop()) {
                this.replace0(ctx, newName, newCtx, forward);
                return ctx.handler();
            }
            future = newCtx.executor().submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DefaultChannelPipeline defaultChannelPipeline = DefaultChannelPipeline.this;
                    synchronized (defaultChannelPipeline) {
                        DefaultChannelPipeline.this.replace0(ctx, newName, newCtx, forward);
                    }
                }
            });
        }
        DefaultChannelHandlerContext.waitForFuture(future);
        return ctx.handler();
    }

    @Override
    public <T extends ChannelHandler> T replaceAndForward(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        return (T)this.replace(this.getContextOrDie(oldHandlerType), newName, newHandler, true);
    }

    private void replace0(DefaultChannelHandlerContext ctx, String newName, DefaultChannelHandlerContext newCtx, boolean forward) {
        boolean sameName = ctx.name().equals(newName);
        DefaultChannelHandlerContext prev = ctx.prev;
        DefaultChannelHandlerContext next = ctx.next;
        newCtx.prev = prev;
        newCtx.next = next;
        DefaultChannelPipeline.callBeforeRemove(ctx);
        DefaultChannelPipeline.callBeforeAdd(newCtx);
        prev.next = newCtx;
        next.prev = newCtx;
        if (!sameName) {
            this.name2ctx.remove(ctx.name());
        }
        this.name2ctx.put(newName, newCtx);
        ChannelPipelineException removeException = null;
        ChannelPipelineException addException = null;
        boolean removed = false;
        try {
            this.callAfterRemove(ctx, forward);
            removed = true;
        }
        catch (ChannelPipelineException e) {
            removeException = e;
        }
        boolean added = false;
        try {
            this.callAfterAdd(newCtx);
            added = true;
        }
        catch (ChannelPipelineException e) {
            addException = e;
        }
        if (!removed && !added) {
            logger.warn(removeException.getMessage(), removeException);
            logger.warn(addException.getMessage(), addException);
            throw new ChannelPipelineException("Both " + ctx.handler().getClass().getName() + ".afterRemove() and " + newCtx.handler().getClass().getName() + ".afterAdd() failed; see logs.");
        }
        if (!removed) {
            throw removeException;
        }
        if (!added) {
            throw addException;
        }
    }

    private static void callBeforeAdd(ChannelHandlerContext ctx) {
        ChannelHandler handler = ctx.handler();
        if (handler instanceof ChannelHandlerAdapter) {
            ChannelHandlerAdapter h = (ChannelHandlerAdapter)handler;
            if (!h.isSharable() && h.added) {
                throw new ChannelPipelineException(h.getClass().getName() + " is not a @Sharable handler, so can't be added or removed multiple times.");
            }
            h.added = true;
        }
        try {
            handler.beforeAdd(ctx);
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(handler.getClass().getName() + ".beforeAdd() has thrown an exception; not adding.", t);
        }
    }

    private void callAfterAdd(ChannelHandlerContext ctx) {
        try {
            ctx.handler().afterAdd(ctx);
        }
        catch (Throwable t) {
            boolean removed;
            block5: {
                removed = false;
                try {
                    this.remove((DefaultChannelHandlerContext)ctx, false);
                    removed = true;
                }
                catch (Throwable t2) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Failed to remove a handler: " + ctx.name(), t2);
                }
            }
            if (removed) {
                throw new ChannelPipelineException(ctx.handler().getClass().getName() + ".afterAdd() has thrown an exception; removed.", t);
            }
            throw new ChannelPipelineException(ctx.handler().getClass().getName() + ".afterAdd() has thrown an exception; also failed to remove.", t);
        }
    }

    private static void callBeforeRemove(ChannelHandlerContext ctx) {
        try {
            ctx.handler().beforeRemove(ctx);
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(ctx.handler().getClass().getName() + ".beforeRemove() has thrown an exception; not removing.", t);
        }
    }

    private void callAfterRemove(DefaultChannelHandlerContext ctx, boolean forward) {
        ChannelHandler handler = ctx.handler();
        try {
            handler.afterRemove(ctx);
        }
        catch (Throwable t) {
            throw new ChannelPipelineException(ctx.handler().getClass().getName() + ".afterRemove() has thrown an exception.", t);
        }
        if (forward) {
            ctx.forwardBufferContent();
        } else {
            ctx.clearBuffer();
        }
        ctx.removed = true;
        if (!this.channel.isRegistered()) {
            ctx.freeHandlerBuffersAfterRemoval();
        }
    }

    @Override
    public ChannelHandler first() {
        DefaultChannelHandlerContext first = this.head.next;
        if (first == null) {
            return null;
        }
        return first.handler();
    }

    @Override
    public ChannelHandlerContext firstContext() {
        return this.head.next;
    }

    @Override
    public ChannelHandler last() {
        DefaultChannelHandlerContext last = this.tail.prev;
        if (last == this.head) {
            return null;
        }
        return last.handler();
    }

    @Override
    public ChannelHandlerContext lastContext() {
        DefaultChannelHandlerContext last = this.tail.prev;
        if (last == this.head) {
            return null;
        }
        return last;
    }

    @Override
    public ChannelHandler get(String name) {
        ChannelHandlerContext ctx = this.context(name);
        if (ctx == null) {
            return null;
        }
        return ctx.handler();
    }

    @Override
    public <T extends ChannelHandler> T get(Class<T> handlerType) {
        ChannelHandlerContext ctx = this.context(handlerType);
        if (ctx == null) {
            return null;
        }
        return (T)ctx.handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelHandlerContext context(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            return this.name2ctx.get(name);
        }
    }

    @Override
    public ChannelHandlerContext context(ChannelHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        DefaultChannelHandlerContext ctx = this.head.next;
        while (ctx != null) {
            if (ctx.handler() == handler) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public ChannelHandlerContext context(Class<? extends ChannelHandler> handlerType) {
        if (handlerType == null) {
            throw new NullPointerException("handlerType");
        }
        DefaultChannelHandlerContext ctx = this.head.next;
        while (ctx != null) {
            if (handlerType.isAssignableFrom(ctx.handler().getClass())) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public List<String> names() {
        ArrayList<String> list = new ArrayList<String>();
        DefaultChannelHandlerContext ctx = this.head.next;
        while (ctx != null) {
            list.add(ctx.name());
            ctx = ctx.next;
        }
        return list;
    }

    @Override
    public Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> map = new LinkedHashMap<String, ChannelHandler>();
        DefaultChannelHandlerContext ctx = this.head.next;
        while (ctx != this.tail) {
            map.put(ctx.name(), ctx.handler());
            ctx = ctx.next;
        }
        return map;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('{');
        DefaultChannelHandlerContext ctx = this.head.next;
        while (ctx != this.tail) {
            buf.append('(');
            buf.append(ctx.name());
            buf.append(" = ");
            buf.append(ctx.handler().getClass().getName());
            buf.append(')');
            ctx = ctx.next;
            if (ctx == this.tail) break;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public <T> MessageBuf<T> inboundMessageBuffer() {
        return this.head.nextInboundMessageBuffer();
    }

    @Override
    public ByteBuf inboundByteBuffer() {
        return this.head.nextInboundByteBuffer();
    }

    @Override
    public <T> MessageBuf<T> outboundMessageBuffer() {
        return this.tail.nextOutboundMessageBuffer();
    }

    @Override
    public ByteBuf outboundByteBuffer() {
        return this.tail.nextOutboundByteBuffer();
    }

    @Override
    public ChannelPipeline fireChannelRegistered() {
        this.head.fireChannelRegistered();
        return this;
    }

    @Override
    public ChannelPipeline fireChannelUnregistered() {
        this.head.fireChannelUnregistered();
        if (!this.channel.isOpen()) {
            this.head.invokeFreeInboundBuffer();
        }
        return this;
    }

    @Override
    public ChannelPipeline fireChannelActive() {
        this.firedChannelActive = true;
        this.head.fireChannelActive();
        if (this.channel.config().isAutoRead()) {
            this.channel.read();
        }
        if (this.fireInboundBufferUpdatedOnActivation) {
            this.fireInboundBufferUpdatedOnActivation = false;
            this.head.fireInboundBufferUpdated();
        }
        return this;
    }

    @Override
    public ChannelPipeline fireChannelInactive() {
        this.head.fireChannelInactive();
        return this;
    }

    @Override
    public ChannelPipeline fireExceptionCaught(Throwable cause) {
        this.head.fireExceptionCaught(cause);
        return this;
    }

    @Override
    public ChannelPipeline fireUserEventTriggered(Object event) {
        this.head.fireUserEventTriggered(event);
        return this;
    }

    @Override
    public ChannelPipeline fireInboundBufferUpdated() {
        if (!this.firedChannelActive) {
            this.fireInboundBufferUpdatedOnActivation = true;
            return this;
        }
        this.head.fireInboundBufferUpdated();
        return this;
    }

    @Override
    public ChannelPipeline fireChannelReadSuspended() {
        this.head.fireChannelReadSuspended();
        if (this.channel.config().isAutoRead()) {
            this.read();
        }
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.tail.bind(localAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.tail.connect(remoteAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.tail.connect(remoteAddress, localAddress);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.tail.disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.tail.close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.tail.deregister();
    }

    @Override
    public ChannelFuture flush() {
        return this.tail.flush();
    }

    @Override
    public ChannelFuture write(Object message) {
        return this.tail.write(message);
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.tail.bind(localAddress, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.tail.connect(remoteAddress, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.tail.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.tail.disconnect(promise);
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        return this.tail.close(promise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        return this.tail.deregister(promise);
    }

    @Override
    public void read() {
        this.tail.read();
    }

    @Override
    public ChannelFuture flush(ChannelPromise promise) {
        return this.tail.flush(promise);
    }

    @Override
    public ChannelFuture sendFile(FileRegion region) {
        return this.tail.sendFile(region);
    }

    @Override
    public ChannelFuture sendFile(FileRegion region, ChannelPromise promise) {
        return this.tail.sendFile(region, promise);
    }

    @Override
    public ChannelFuture write(Object message, ChannelPromise promise) {
        return this.tail.write(message, promise);
    }

    void notifyHandlerException(Throwable cause) {
        if (!(cause instanceof ChannelPipelineException)) {
            cause = new ChannelPipelineException(cause);
        }
        if (DefaultChannelPipeline.inExceptionCaught(cause)) {
            if (logger.isWarnEnabled()) {
                logger.warn("An exception was thrown by a user handler while handling an exceptionCaught event", cause);
            }
            return;
        }
        this.fireExceptionCaught(cause);
    }

    private static boolean inExceptionCaught(Throwable cause) {
        while (cause != null) {
            StackTraceElement[] trace = cause.getStackTrace();
            if (trace != null) {
                for (StackTraceElement t : trace) {
                    if (!"exceptionCaught".equals(t.getMethodName())) continue;
                    return true;
                }
            }
            cause = cause.getCause();
        }
        return false;
    }

    private void checkDuplicateName(String name) {
        if (this.name2ctx.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate handler name: " + name);
        }
    }

    private DefaultChannelHandlerContext getContextOrDie(String name) {
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)this.context(name);
        if (ctx == null) {
            throw new NoSuchElementException(name);
        }
        return ctx;
    }

    private DefaultChannelHandlerContext getContextOrDie(ChannelHandler handler) {
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)this.context(handler);
        if (ctx == null) {
            throw new NoSuchElementException(handler.getClass().getName());
        }
        return ctx;
    }

    private DefaultChannelHandlerContext getContextOrDie(Class<? extends ChannelHandler> handlerType) {
        DefaultChannelHandlerContext ctx = (DefaultChannelHandlerContext)this.context(handlerType);
        if (ctx == null) {
            throw new NoSuchElementException(handlerType.getName());
        }
        return ctx;
    }

    @Override
    public Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.toMap().entrySet().iterator();
    }

    private static final class MessageHeadHandler
    extends HeadHandler {
        private MessageHeadHandler(Channel.Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            int byteSinkSize = this.byteSink.readableBytes();
            if (byteSinkSize != 0) {
                this.byteSink.clear();
                logger.warn("Discarded {} outbound byte(s) that reached at the end of the pipeline. Please check your pipeline configuration.", (Object)byteSinkSize);
            }
            this.unsafe.flush(promise);
        }
    }

    private static final class ByteHeadHandler
    extends HeadHandler {
        private ByteHeadHandler(Channel.Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            Object m;
            int discardedMessages = 0;
            MessageBuf in = this.msgSink;
            while ((m = in.poll()) != null) {
                if (m instanceof ByteBuf) {
                    ByteBuf src = (ByteBuf)m;
                    this.byteSink.writeBytes(src, src.readerIndex(), src.readableBytes());
                } else {
                    ++discardedMessages;
                }
                if (!(m instanceof ReferenceCounted)) continue;
                ((ReferenceCounted)m).release();
            }
            if (discardedMessages != 0) {
                logger.warn("Discarded {} outbound message(s) that reached at the end of the pipeline. Please check your pipeline configuration.", (Object)discardedMessages);
            }
            this.unsafe.flush(promise);
        }
    }

    static abstract class HeadHandler
    implements ChannelOutboundHandler {
        protected final Channel.Unsafe unsafe;
        ByteBuf byteSink;
        MessageBuf<Object> msgSink;

        protected HeadHandler(Channel.Unsafe unsafe) {
            this.unsafe = unsafe;
        }

        void init(ChannelHandlerContext ctx) {
            switch (ctx.channel().metadata().bufferType()) {
                case BYTE: {
                    this.byteSink = ctx.alloc().ioBuffer();
                    this.msgSink = Unpooled.messageBuffer(0);
                    break;
                }
                case MESSAGE: {
                    this.byteSink = Unpooled.buffer(0);
                    this.msgSink = Unpooled.messageBuffer();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        @Override
        public final void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public final void afterAdd(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public final void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public final void afterRemove(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public final void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            this.unsafe.bind(localAddress, promise);
        }

        @Override
        public final void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            this.unsafe.connect(remoteAddress, localAddress, promise);
        }

        @Override
        public final void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            this.unsafe.disconnect(promise);
        }

        @Override
        public final void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            this.unsafe.close(promise);
        }

        @Override
        public final void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            this.unsafe.deregister(promise);
        }

        @Override
        public final void read(ChannelHandlerContext ctx) {
            this.unsafe.beginRead();
        }

        @Override
        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public final void sendFile(ChannelHandlerContext ctx, FileRegion region, ChannelPromise promise) throws Exception {
            this.unsafe.sendFile(region, promise);
        }

        @Override
        public final Buf newOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
            throw new Error();
        }

        @Override
        public final void freeOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
            this.msgSink.release();
            this.byteSink.release();
        }
    }

    static final class TailHandler
    implements ChannelInboundHandler {
        final ByteBuf byteSink = Unpooled.buffer(0);
        final MessageBuf<Object> msgSink = Unpooled.messageBuffer(0);

        TailHandler() {
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void channelReadSuspended(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void afterAdd(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("An exceptionCaught() event was fired, and it reached at the end of the pipeline. It usually means the last handler in the pipeline did not handle the exception.", cause);
        }

        @Override
        public Buf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
            throw new Error();
        }

        @Override
        public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
            this.byteSink.release();
            this.msgSink.release();
        }

        @Override
        public void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
            int msgSinkSize;
            int byteSinkSize = this.byteSink.readableBytes();
            if (byteSinkSize != 0) {
                this.byteSink.clear();
                logger.warn("Discarded {} inbound byte(s) that reached at the end of the pipeline. Please check your pipeline configuration.", (Object)byteSinkSize);
            }
            if ((msgSinkSize = this.msgSink.size()) != 0) {
                Object m;
                MessageBuf<Object> in = this.msgSink;
                while ((m = in.poll()) != null) {
                    if (!(m instanceof ReferenceCounted)) continue;
                    ((ReferenceCounted)m).release();
                }
                logger.warn("Discarded {} inbound message(s) that reached at the end of the pipeline. Please check your pipeline configuration.", (Object)msgSinkSize);
            }
        }
    }
}

