/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.testsuite.http2.HelloWorldHttp1Handler;
import io.netty.testsuite.http2.HelloWorldHttp2HandlerBuilder;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;

public class Http2ServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

        public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec((Http2ConnectionHandler)new HelloWorldHttp2HandlerBuilder().build());
            }
            return null;
        }
    };
    private final int maxHttpContentLength;

    Http2ServerInitializer() {
        this(16384);
    }

    Http2ServerInitializer(int maxHttpContentLength) {
        if (maxHttpContentLength < 0) {
            throw new IllegalArgumentException("maxHttpContentLength (expected >= 0): " + maxHttpContentLength);
        }
        this.maxHttpContentLength = maxHttpContentLength;
    }

    public void initChannel(SocketChannel ch) {
        this.configureClearText(ch);
    }

    private void configureClearText(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        HttpServerCodec sourceCodec = new HttpServerCodec();
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory);
        CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, (ChannelHandler)new HelloWorldHttp2HandlerBuilder().build());
        p.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
        p.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpMessage>(){

            protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                System.err.println("Directly talking: " + msg.protocolVersion() + " (no upgrade was attempted)");
                ChannelPipeline pipeline = ctx.pipeline();
                ChannelHandlerContext thisCtx = pipeline.context((ChannelHandler)this);
                pipeline.addAfter(thisCtx.name(), null, (ChannelHandler)new HelloWorldHttp1Handler("Direct. No Upgrade Attempted."));
                pipeline.replace((ChannelHandler)this, null, (ChannelHandler)new HttpObjectAggregator(Http2ServerInitializer.this.maxHttpContentLength));
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
        }});
        p.addLast(new ChannelHandler[]{new UserEventLogger()});
    }

    private static class UserEventLogger
    extends ChannelInboundHandlerAdapter {
        private UserEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            System.out.println("User Event Triggered: " + evt);
            ctx.fireUserEventTriggered(evt);
        }
    }
}

