/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.DefaultHostsFileEntriesResolver;
import io.netty.resolver.HostsFileEntries;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class DefaultHostsFileEntriesResolverTest {
    @Test
    public void testCaseInsensitivity() throws Exception {
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver();
        Assert.assertEquals((Object)resolver.normalize("localhost"), (Object)resolver.normalize("LOCALHOST"));
    }

    @Test
    public void shouldntFindWhenAddressTypeDoesntMatch() {
        HashMap<String, Inet4Address> inet4Entries = new HashMap<String, Inet4Address>();
        HashMap inet6Entries = new HashMap();
        inet4Entries.put("localhost", NetUtil.LOCALHOST4);
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(new HostsFileEntries(inet4Entries, inet6Entries));
        InetAddress address = resolver.address("localhost", ResolvedAddressTypes.IPV6_ONLY);
        Assert.assertNull((String)"Should pick an IPv6 address", (Object)address);
    }

    @Test
    public void shouldPickIpv4WhenBothAreDefinedButIpv4IsPreferred() {
        HashMap<String, Inet4Address> inet4Entries = new HashMap<String, Inet4Address>();
        HashMap<String, Inet6Address> inet6Entries = new HashMap<String, Inet6Address>();
        inet4Entries.put("localhost", NetUtil.LOCALHOST4);
        inet6Entries.put("localhost", NetUtil.LOCALHOST6);
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(new HostsFileEntries(inet4Entries, inet6Entries));
        InetAddress address = resolver.address("localhost", ResolvedAddressTypes.IPV4_PREFERRED);
        Assert.assertTrue((String)"Should pick an IPv4 address", (boolean)(address instanceof Inet4Address));
    }

    @Test
    public void shouldPickIpv6WhenBothAreDefinedButIpv6IsPreferred() {
        HashMap<String, Inet4Address> inet4Entries = new HashMap<String, Inet4Address>();
        HashMap<String, Inet6Address> inet6Entries = new HashMap<String, Inet6Address>();
        inet4Entries.put("localhost", NetUtil.LOCALHOST4);
        inet6Entries.put("localhost", NetUtil.LOCALHOST6);
        DefaultHostsFileEntriesResolver resolver = new DefaultHostsFileEntriesResolver(new HostsFileEntries(inet4Entries, inet6Entries));
        InetAddress address = resolver.address("localhost", ResolvedAddressTypes.IPV6_PREFERRED);
        Assert.assertTrue((String)"Should pick an IPv6 address", (boolean)(address instanceof Inet6Address));
    }
}

