/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.SingletonDnsServerAddressStreamProvider;
import io.netty.resolver.dns.TestDnsServer;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SearchDomainTest {
    private TestDnsServer dnsServer;
    private EventLoopGroup group;
    private DnsNameResolver resolver;

    private DnsNameResolverBuilder newResolver() {
        return new DnsNameResolverBuilder(this.group.next()).channelType(NioDatagramChannel.class).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(this.dnsServer.localAddress())).maxQueriesPerResolve(1).optResourceEnabled(false).ndots(1);
    }

    @Before
    public void before() {
        this.group = new NioEventLoopGroup(1);
    }

    @After
    public void destroy() {
        if (this.dnsServer != null) {
            this.dnsServer.stop();
            this.dnsServer = null;
        }
        if (this.resolver != null) {
            this.resolver.close();
        }
        this.group.shutdownGracefully();
    }

    @Test
    public void testResolve() throws Exception {
        HashSet<String> domains = new HashSet<String>();
        domains.add("host1.foo.com");
        domains.add("host1");
        domains.add("host3");
        domains.add("host4.sub.foo.com");
        domains.add("host5.sub.foo.com");
        domains.add("host5.sub");
        TestDnsServer.MapRecordStoreA store = new TestDnsServer.MapRecordStoreA(domains);
        this.dnsServer = new TestDnsServer(store);
        this.dnsServer.start();
        this.resolver = this.newResolver().searchDomains(Collections.singletonList("foo.com")).ndots(2).build();
        String a = "host1.foo.com";
        String resolved = SearchDomainTest.assertResolve(this.resolver, a);
        Assert.assertEquals((Object)store.getAddress("host1.foo.com"), (Object)resolved);
        resolved = SearchDomainTest.assertResolve(this.resolver, "host1");
        Assert.assertEquals((Object)store.getAddress("host1.foo.com"), (Object)resolved);
        resolved = SearchDomainTest.assertResolve(this.resolver, "host1.");
        Assert.assertEquals((Object)store.getAddress("host1"), (Object)resolved);
        SearchDomainTest.assertNotResolve(this.resolver, "host2");
        resolved = SearchDomainTest.assertResolve(this.resolver, "host3");
        Assert.assertEquals((Object)store.getAddress("host3"), (Object)resolved);
        resolved = SearchDomainTest.assertResolve(this.resolver, "host3.");
        Assert.assertEquals((Object)store.getAddress("host3"), (Object)resolved);
        resolved = SearchDomainTest.assertResolve(this.resolver, "host4.sub");
        Assert.assertEquals((Object)store.getAddress("host4.sub.foo.com"), (Object)resolved);
        resolved = SearchDomainTest.assertResolve(this.resolver, "host5.sub");
        Assert.assertEquals((Object)store.getAddress("host5.sub.foo.com"), (Object)resolved);
    }

    @Test
    public void testResolveAll() throws Exception {
        HashSet<String> domains = new HashSet<String>();
        domains.add("host1.foo.com");
        domains.add("host1");
        domains.add("host3");
        domains.add("host4.sub.foo.com");
        domains.add("host5.sub.foo.com");
        domains.add("host5.sub");
        TestDnsServer.MapRecordStoreA store = new TestDnsServer.MapRecordStoreA(domains, 2);
        this.dnsServer = new TestDnsServer(store);
        this.dnsServer.start();
        this.resolver = this.newResolver().searchDomains(Collections.singletonList("foo.com")).ndots(2).build();
        String a = "host1.foo.com";
        List<String> resolved = SearchDomainTest.assertResolveAll(this.resolver, a);
        Assert.assertEquals(store.getAddresses("host1.foo.com"), resolved);
        resolved = SearchDomainTest.assertResolveAll(this.resolver, "host1");
        Assert.assertEquals(store.getAddresses("host1.foo.com"), resolved);
        resolved = SearchDomainTest.assertResolveAll(this.resolver, "host1.");
        Assert.assertEquals(store.getAddresses("host1"), resolved);
        SearchDomainTest.assertNotResolveAll(this.resolver, "host2");
        resolved = SearchDomainTest.assertResolveAll(this.resolver, "host3");
        Assert.assertEquals(store.getAddresses("host3"), resolved);
        resolved = SearchDomainTest.assertResolveAll(this.resolver, "host3.");
        Assert.assertEquals(store.getAddresses("host3"), resolved);
        resolved = SearchDomainTest.assertResolveAll(this.resolver, "host4.sub");
        Assert.assertEquals(store.getAddresses("host4.sub.foo.com"), resolved);
        resolved = SearchDomainTest.assertResolveAll(this.resolver, "host5.sub");
        Assert.assertEquals(store.getAddresses("host5.sub.foo.com"), resolved);
    }

    @Test
    public void testMultipleSearchDomain() throws Exception {
        HashSet<String> domains = new HashSet<String>();
        domains.add("host1.foo.com");
        domains.add("host2.bar.com");
        domains.add("host3.bar.com");
        domains.add("host3.foo.com");
        TestDnsServer.MapRecordStoreA store = new TestDnsServer.MapRecordStoreA(domains);
        this.dnsServer = new TestDnsServer(store);
        this.dnsServer.start();
        this.resolver = this.newResolver().searchDomains(Arrays.asList("foo.com", "bar.com")).build();
        String resolved = SearchDomainTest.assertResolve(this.resolver, "host1");
        Assert.assertEquals((Object)store.getAddress("host1.foo.com"), (Object)resolved);
        resolved = SearchDomainTest.assertResolve(this.resolver, "host2");
        Assert.assertEquals((Object)store.getAddress("host2.bar.com"), (Object)resolved);
        resolved = SearchDomainTest.assertResolve(this.resolver, "host3");
        Assert.assertEquals((Object)store.getAddress("host3.foo.com"), (Object)resolved);
        SearchDomainTest.assertNotResolve(this.resolver, "host4");
    }

    @Test
    public void testSearchDomainWithNdots2() throws Exception {
        HashSet<String> domains = new HashSet<String>();
        domains.add("host1.sub.foo.com");
        domains.add("host2.sub.foo.com");
        domains.add("host2.sub");
        TestDnsServer.MapRecordStoreA store = new TestDnsServer.MapRecordStoreA(domains);
        this.dnsServer = new TestDnsServer(store);
        this.dnsServer.start();
        this.resolver = this.newResolver().searchDomains(Collections.singleton("foo.com")).ndots(2).build();
        String resolved = SearchDomainTest.assertResolve(this.resolver, "host1.sub");
        Assert.assertEquals((Object)store.getAddress("host1.sub.foo.com"), (Object)resolved);
        resolved = SearchDomainTest.assertResolve(this.resolver, "host2.sub");
        Assert.assertEquals((Object)store.getAddress("host2.sub.foo.com"), (Object)resolved);
    }

    @Test
    public void testSearchDomainWithNdots0() throws Exception {
        HashSet<String> domains = new HashSet<String>();
        domains.add("host1");
        domains.add("host1.foo.com");
        domains.add("host2.foo.com");
        TestDnsServer.MapRecordStoreA store = new TestDnsServer.MapRecordStoreA(domains);
        this.dnsServer = new TestDnsServer(store);
        this.dnsServer.start();
        this.resolver = this.newResolver().searchDomains(Collections.singleton("foo.com")).ndots(0).build();
        String resolved = SearchDomainTest.assertResolve(this.resolver, "host1");
        Assert.assertEquals((Object)store.getAddress("host1"), (Object)resolved);
        resolved = SearchDomainTest.assertResolve(this.resolver, "host1.foo.com");
        Assert.assertEquals((Object)store.getAddress("host1.foo.com"), (Object)resolved);
        SearchDomainTest.assertNotResolve(this.resolver, "host2");
    }

    private static void assertNotResolve(DnsNameResolver resolver, String inetHost) throws InterruptedException {
        Future fut = resolver.resolve(inetHost);
        Assert.assertTrue((boolean)fut.await(10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)fut.isSuccess());
    }

    private static void assertNotResolveAll(DnsNameResolver resolver, String inetHost) throws InterruptedException {
        Future fut = resolver.resolveAll(inetHost);
        Assert.assertTrue((boolean)fut.await(10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)fut.isSuccess());
    }

    private static String assertResolve(DnsNameResolver resolver, String inetHost) throws InterruptedException {
        Future fut = resolver.resolve(inetHost);
        Assert.assertTrue((boolean)fut.await(10L, TimeUnit.SECONDS));
        return ((InetAddress)fut.getNow()).getHostAddress();
    }

    private static List<String> assertResolveAll(DnsNameResolver resolver, String inetHost) throws InterruptedException {
        Future fut = resolver.resolveAll(inetHost);
        Assert.assertTrue((boolean)fut.await(10L, TimeUnit.SECONDS));
        ArrayList<String> list = new ArrayList<String>();
        for (InetAddress addr : (List)fut.getNow()) {
            list.add(addr.getHostAddress());
        }
        return list;
    }

    @Test
    public void testExceptionMsgContainsSearchDomain() throws Exception {
        TestDnsServer.MapRecordStoreA store = new TestDnsServer.MapRecordStoreA(Collections.<String>emptySet());
        this.dnsServer = new TestDnsServer(store);
        this.dnsServer.start();
        this.resolver = this.newResolver().searchDomains(Collections.singletonList("foo.com")).ndots(1).build();
        Future fut = this.resolver.resolve("unknown.hostname");
        Assert.assertTrue((boolean)fut.await(10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)fut.isSuccess());
        Throwable cause = fut.cause();
        MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(UnknownHostException.class));
        MatcherAssert.assertThat((String)"search domain is included in UnknownHostException", (Object)cause.getMessage(), (Matcher)StringContains.containsString((String)"foo.com"));
    }

    @Test
    public void testExceptionMsgDoesNotContainSearchDomainIfNdotsIsNotReached() throws Exception {
        TestDnsServer.MapRecordStoreA store = new TestDnsServer.MapRecordStoreA(Collections.<String>emptySet());
        this.dnsServer = new TestDnsServer(store);
        this.dnsServer.start();
        this.resolver = this.newResolver().searchDomains(Collections.singletonList("foo.com")).ndots(2).build();
        Future fut = this.resolver.resolve("unknown.hostname");
        Assert.assertTrue((boolean)fut.await(10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)fut.isSuccess());
        Throwable cause = fut.cause();
        MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(UnknownHostException.class));
        MatcherAssert.assertThat((String)"search domain is included in UnknownHostException", (Object)cause.getMessage(), (Matcher)Matchers.not((Matcher)StringContains.containsString((String)"foo.com")));
    }
}

