/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.resolver.dns.DefaultAuthoritativeDnsServerCache;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DefaultAuthoritativeDnsServerCacheTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpire() throws Throwable {
        InetSocketAddress resolved1 = new InetSocketAddress(InetAddress.getByAddress("ns1", new byte[]{10, 0, 0, 1}), 53);
        InetSocketAddress resolved2 = new InetSocketAddress(InetAddress.getByAddress("ns2", new byte[]{10, 0, 0, 2}), 53);
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            final DefaultAuthoritativeDnsServerCache cache = new DefaultAuthoritativeDnsServerCache();
            cache.cache("netty.io", resolved1, 1L, loop);
            cache.cache("netty.io", resolved2, 10000L, loop);
            Throwable error = (Throwable)loop.schedule((Callable)new Callable<Throwable>(){

                @Override
                public Throwable call() {
                    try {
                        Assert.assertNull((Object)cache.get("netty.io"));
                        return null;
                    }
                    catch (Throwable cause) {
                        return cause;
                    }
                }
            }, 1L, TimeUnit.SECONDS).get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testExpireWithDifferentTTLs() {
        DefaultAuthoritativeDnsServerCacheTest.testExpireWithTTL0(1);
        DefaultAuthoritativeDnsServerCacheTest.testExpireWithTTL0(1000);
        DefaultAuthoritativeDnsServerCacheTest.testExpireWithTTL0(1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testExpireWithTTL0(int days) {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultAuthoritativeDnsServerCache cache = new DefaultAuthoritativeDnsServerCache();
            cache.cache("netty.io", new InetSocketAddress(NetUtil.LOCALHOST, 53), (long)days, loop);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddMultipleDnsServerForSameHostname() throws Exception {
        InetSocketAddress resolved1 = new InetSocketAddress(InetAddress.getByAddress("ns1", new byte[]{10, 0, 0, 1}), 53);
        InetSocketAddress resolved2 = new InetSocketAddress(InetAddress.getByAddress("ns2", new byte[]{10, 0, 0, 2}), 53);
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultAuthoritativeDnsServerCache cache = new DefaultAuthoritativeDnsServerCache();
            cache.cache("netty.io", resolved1, 100L, loop);
            cache.cache("netty.io", resolved2, 10000L, loop);
            DnsServerAddressStream entries = cache.get("netty.io");
            Assert.assertEquals((long)2L, (long)entries.size());
            Assert.assertEquals((Object)resolved1, (Object)entries.next());
            Assert.assertEquals((Object)resolved2, (Object)entries.next());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnresolvedReplacedByResolved() throws Exception {
        InetSocketAddress unresolved = InetSocketAddress.createUnresolved("ns1", 53);
        InetSocketAddress resolved1 = new InetSocketAddress(InetAddress.getByAddress("ns2", new byte[]{10, 0, 0, 2}), 53);
        InetSocketAddress resolved2 = new InetSocketAddress(InetAddress.getByAddress("ns1", new byte[]{10, 0, 0, 1}), 53);
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultAuthoritativeDnsServerCache cache = new DefaultAuthoritativeDnsServerCache();
            cache.cache("netty.io", unresolved, 100L, loop);
            cache.cache("netty.io", resolved1, 10000L, loop);
            DnsServerAddressStream entries = cache.get("netty.io");
            Assert.assertEquals((long)2L, (long)entries.size());
            Assert.assertEquals((Object)unresolved, (Object)entries.next());
            Assert.assertEquals((Object)resolved1, (Object)entries.next());
            cache.cache("netty.io", resolved2, 100L, loop);
            DnsServerAddressStream entries2 = cache.get("netty.io");
            Assert.assertEquals((long)2L, (long)entries2.size());
            Assert.assertEquals((Object)resolved2, (Object)entries2.next());
            Assert.assertEquals((Object)resolved1, (Object)entries2.next());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testUseNoComparator() throws Exception {
        DefaultAuthoritativeDnsServerCacheTest.testUseComparator0(true);
    }

    @Test
    public void testUseComparator() throws Exception {
        DefaultAuthoritativeDnsServerCacheTest.testUseComparator0(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testUseComparator0(boolean noComparator) throws Exception {
        InetSocketAddress unresolved = InetSocketAddress.createUnresolved("ns1", 53);
        InetSocketAddress resolved = new InetSocketAddress(InetAddress.getByAddress("ns2", new byte[]{10, 0, 0, 2}), 53);
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultAuthoritativeDnsServerCache cache = noComparator ? new DefaultAuthoritativeDnsServerCache(10000, 10000, null) : new DefaultAuthoritativeDnsServerCache(10000, 10000, (Comparator)new Comparator<InetSocketAddress>(){

                @Override
                public int compare(InetSocketAddress o1, InetSocketAddress o2) {
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    if (o1.isUnresolved()) {
                        return 1;
                    }
                    return -1;
                }
            });
            cache.cache("netty.io", unresolved, 100L, loop);
            cache.cache("netty.io", resolved, 10000L, loop);
            DnsServerAddressStream entries = cache.get("netty.io");
            Assert.assertEquals((long)2L, (long)entries.size());
            if (noComparator) {
                Assert.assertEquals((Object)unresolved, (Object)entries.next());
                Assert.assertEquals((Object)resolved, (Object)entries.next());
            } else {
                Assert.assertEquals((Object)resolved, (Object)entries.next());
                Assert.assertEquals((Object)unresolved, (Object)entries.next());
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

