/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DnsAddressResolverGroupTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseConfiguredEventLoop() throws InterruptedException {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        final EventLoop loop = group.next();
        DefaultEventLoopGroup defaultEventLoopGroup = new DefaultEventLoopGroup(1);
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder().eventLoop(loop).channelType(NioDatagramChannel.class);
        DnsAddressResolverGroup resolverGroup = new DnsAddressResolverGroup(builder);
        try {
            final Promise promise = loop.newPromise();
            AddressResolver resolver = resolverGroup.getResolver((EventExecutor)defaultEventLoopGroup.next());
            resolver.resolve(new SocketAddress(){
                private static final long serialVersionUID = 3169703458729818468L;
            }).addListener((GenericFutureListener)new FutureListener<Object>(){

                public void operationComplete(Future<Object> future) {
                    try {
                        Assert.assertThat((Object)future.cause(), (Matcher)Matchers.instanceOf(UnsupportedAddressTypeException.class));
                        Assert.assertTrue((boolean)loop.inEventLoop());
                        promise.setSuccess(null);
                    }
                    catch (Throwable cause) {
                        promise.setFailure(cause);
                    }
                }
            }).await();
            promise.sync();
        }
        finally {
            resolverGroup.close();
            group.shutdownGracefully();
            defaultEventLoopGroup.shutdownGracefully();
        }
    }
}

