/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.UnixResolverDnsServerAddressStreamProvider;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UnixResolverDnsServerAddressStreamProviderTest {
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void defaultLookupShouldReturnResultsIfOnlySingleFileSpecified() throws Exception {
        File f = this.buildFile("domain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, null);
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
    }

    @Test
    public void defaultReturnedWhenNoBetterMatch() throws Exception {
        File f = this.buildFile("domain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\n");
        File f2 = this.buildFile("domain squarecorp.local\nnameserver 127.0.0.4\nnameserver 127.0.0.5\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, new File[]{f2});
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
    }

    @Test
    public void moreRefinedSelectionReturnedWhenMatch() throws Exception {
        File f = this.buildFile("domain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\n");
        File f2 = this.buildFile("domain dc1.linecorp.local\nnameserver 127.0.0.4\nnameserver 127.0.0.5\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, new File[]{f2});
        DnsServerAddressStream stream = p.nameServerAddressStream("myhost.dc1.linecorp.local");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.4", stream.next());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.5", stream.next());
    }

    @Test
    public void ndotsIsParsedIfPresent() throws IOException {
        File f = this.buildFile("search localdomain\nnameserver 127.0.0.11\noptions ndots:0\n");
        Assert.assertEquals((long)0L, (long)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverFirstNdots((File)f));
        f = this.buildFile("search localdomain\nnameserver 127.0.0.11\noptions ndots:123 foo:goo\n");
        Assert.assertEquals((long)123L, (long)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverFirstNdots((File)f));
    }

    @Test
    public void defaultValueReturnedIfNdotsNotPresent() throws IOException {
        File f = this.buildFile("search localdomain\nnameserver 127.0.0.11\n");
        Assert.assertEquals((long)1L, (long)UnixResolverDnsServerAddressStreamProvider.parseEtcResolverFirstNdots((File)f));
    }

    @Test
    public void emptyEtcResolverDirectoryDoesNotThrow() throws IOException {
        File f = this.buildFile("domain linecorp.local\nnameserver 127.0.0.2\nnameserver 127.0.0.3\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, this.folder.newFolder().listFiles());
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
    }

    @Test
    public void searchDomainsWithOnlyDomain() throws IOException {
        File f = this.buildFile("domain linecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assert.assertEquals(Collections.singletonList("linecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsWithOnlySearch() throws IOException {
        File f = this.buildFile("search linecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assert.assertEquals(Collections.singletonList("linecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsWithMultipleSearch() throws IOException {
        File f = this.buildFile("search linecorp.local\nsearch squarecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assert.assertEquals(Arrays.asList("linecorp.local", "squarecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsWithMultipleSearchSeperatedByWhitespace() throws IOException {
        File f = this.buildFile("search linecorp.local squarecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assert.assertEquals(Arrays.asList("linecorp.local", "squarecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsWithMultipleSearchSeperatedByTab() throws IOException {
        File f = this.buildFile("search linecorp.local\tsquarecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assert.assertEquals(Arrays.asList("linecorp.local", "squarecorp.local"), (Object)domains);
    }

    @Test
    public void searchDomainsPrecedence() throws IOException {
        File f = this.buildFile("domain linecorp.local\nsearch squarecorp.local\nnameserver 127.0.0.2\n");
        List domains = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains((File)f);
        Assert.assertEquals(Collections.singletonList("squarecorp.local"), (Object)domains);
    }

    @Test
    public void ignoreInvalidEntries() throws Exception {
        File f = this.buildFile("domain netty.local\nnameserver nil\nnameserver 127.0.0.3\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, null);
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        Assert.assertEquals((long)1L, (long)stream.size());
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.3", stream.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File buildFile(String contents) throws IOException {
        File f = this.folder.newFile();
        FileOutputStream out = new FileOutputStream(f);
        try {
            ((OutputStream)out).write(contents.getBytes(CharsetUtil.UTF_8));
        }
        finally {
            ((OutputStream)out).close();
        }
        return f;
    }

    @Test
    public void ignoreComments() throws Exception {
        File f = this.buildFile("domain linecorp.local\nnameserver 127.0.0.2 #somecomment\n");
        UnixResolverDnsServerAddressStreamProvider p = new UnixResolverDnsServerAddressStreamProvider(f, null);
        DnsServerAddressStream stream = p.nameServerAddressStream("somehost");
        UnixResolverDnsServerAddressStreamProviderTest.assertHostNameEquals("127.0.0.2", stream.next());
    }

    private static void assertHostNameEquals(String expectedHostname, InetSocketAddress next) {
        Assert.assertEquals((String)("unexpected hostname: " + next), (Object)expectedHostname, (Object)next.getHostString());
    }
}

