/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.AuthoritativeDnsServerCache;
import io.netty.resolver.dns.DefaultAuthoritativeDnsServerCache;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.resolver.dns.DnsCnameCache;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import io.netty.resolver.dns.DnsQueryLifecycleObserver;
import io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.netty.resolver.dns.DnsResolveContext;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.resolver.dns.MultiDnsServerAddressStreamProvider;
import io.netty.resolver.dns.NoopAuthoritativeDnsServerCache;
import io.netty.resolver.dns.NoopDnsCache;
import io.netty.resolver.dns.NoopDnsQueryLifecycleObserverFactory;
import io.netty.resolver.dns.SequentialDnsServerAddressStream;
import io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;
import io.netty.resolver.dns.SingletonDnsServerAddressStreamProvider;
import io.netty.resolver.dns.TestDnsServer;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.io.encoder.DnsMessageEncoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordModifier;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.mina.core.buffer.IoBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DnsNameResolverTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
    private static final long DEFAULT_TEST_TIMEOUT_MS = 30000L;
    private static final Set<String> DOMAINS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("google.com", "youtube.com", "facebook.com", "baidu.com", "wikipedia.org", "yahoo.com", "reddit.com", "google.co.in", "qq.com", "amazon.com", "taobao.com", "tmall.com", "twitter.com", "vk.com", "live.com", "sohu.com", "instagram.com", "google.co.jp", "sina.com.cn", "jd.com", "weibo.com", "360.cn", "google.de", "google.co.uk", "google.com.br", "list.tmall.com", "google.ru", "google.fr", "yandex.ru", "netflix.com", "google.it", "google.com.hk", "linkedin.com", "pornhub.com", "t.co", "google.es", "twitch.tv", "alipay.com", "xvideos.com", "ebay.com", "yahoo.co.jp", "google.ca", "google.com.mx", "bing.com", "ok.ru", "imgur.com", "microsoft.com", "mail.ru", "imdb.com", "aliexpress.com", "hao123.com", "msn.com", "tumblr.com", "csdn.net", "wikia.com", "wordpress.com", "office.com", "google.com.tr", "livejasmin.com", "amazon.co.jp", "deloton.com", "apple.com", "google.com.au", "paypal.com", "google.com.tw", "bongacams.com", "popads.net", "whatsapp.com", "blogspot.com", "detail.tmall.com", "google.pl", "microsoftonline.com", "xhamster.com", "google.co.id", "github.com", "stackoverflow.com", "pinterest.com", "amazon.de", "diply.com", "amazon.co.uk", "so.com", "google.com.ar", "coccoc.com", "soso.com", "espn.com", "adobe.com", "google.com.ua", "tianya.cn", "xnxx.com", "googleusercontent.com", "savefrom.net", "google.com.pk", "amazon.in", "nicovideo.jp", "google.co.th", "dropbox.com", "thepiratebay.org", "google.com.sa", "google.com.eg", "pixnet.net", "localhost")));
    private static final Map<String, String> DOMAINS_PUNYCODE = new HashMap<String, String>();
    private static final Set<String> DOMAINS_ALL;
    private static final Set<String> EXCLUSIONS_RESOLVE_A;
    private static final Set<String> EXCLUSIONS_RESOLVE_AAAA;
    private static final Set<String> EXCLUSIONS_QUERY_MX;
    private static final TestDnsServer dnsServer;
    private static final EventLoopGroup group;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private static DnsNameResolverBuilder newResolver(boolean decodeToUnicode) {
        return DnsNameResolverTest.newResolver(decodeToUnicode, null);
    }

    private static DnsNameResolverBuilder newResolver(boolean decodeToUnicode, DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder(group.next()).dnsQueryLifecycleObserverFactory((DnsQueryLifecycleObserverFactory)new TestRecursiveCacheDnsQueryLifecycleObserverFactory()).channelType(NioDatagramChannel.class).maxQueriesPerResolve(1).decodeIdn(decodeToUnicode).optResourceEnabled(false).ndots(1);
        if (dnsServerAddressStreamProvider == null) {
            builder.nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer.localAddress()));
        } else {
            builder.nameServerProvider((DnsServerAddressStreamProvider)new MultiDnsServerAddressStreamProvider(new DnsServerAddressStreamProvider[]{dnsServerAddressStreamProvider, new SingletonDnsServerAddressStreamProvider(dnsServer.localAddress())}));
        }
        return builder;
    }

    private static DnsNameResolverBuilder newResolver() {
        return DnsNameResolverTest.newResolver(true);
    }

    private static DnsNameResolverBuilder newResolver(ResolvedAddressTypes resolvedAddressTypes) {
        return DnsNameResolverTest.newResolver().resolvedAddressTypes(resolvedAddressTypes);
    }

    private static DnsNameResolverBuilder newNonCachedResolver(ResolvedAddressTypes resolvedAddressTypes) {
        return DnsNameResolverTest.newResolver().resolveCache((DnsCache)NoopDnsCache.INSTANCE).resolvedAddressTypes(resolvedAddressTypes);
    }

    @BeforeClass
    public static void init() throws Exception {
        dnsServer.start();
    }

    @AfterClass
    public static void destroy() {
        dnsServer.stop();
        group.shutdownGracefully();
    }

    @Test
    public void testResolveAorAAAA() throws Exception {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(ResolvedAddressTypes.IPV4_PREFERRED).build();
        try {
            DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, DnsRecordType.AAAA);
        }
        finally {
            resolver.close();
        }
    }

    @Test
    public void testResolveAAAAorA() throws Exception {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(ResolvedAddressTypes.IPV6_PREFERRED).build();
        try {
            DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, DnsRecordType.A);
        }
        finally {
            resolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameServerCache() throws IOException, InterruptedException {
        String overriddenIP = "13.250.177.223";
        final TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                switch (question.getRecordType()) {
                    case A: {
                        HashMap<String, Object> attr = new HashMap<String, Object>();
                        attr.put("apacheDnsIpAddress".toLowerCase(Locale.US), "13.250.177.223");
                        return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), question.getRecordType(), attr));
                    }
                }
                return null;
            }
        });
        dnsServer2.start();
        try {
            final HashSet<String> overriddenHostnames = new HashSet<String>();
            for (String name : DOMAINS) {
                if (EXCLUSIONS_RESOLVE_A.contains(name) || !PlatformDependent.threadLocalRandom().nextBoolean()) continue;
                overriddenHostnames.add(name);
            }
            DnsNameResolver resolver = DnsNameResolverTest.newResolver(false, new DnsServerAddressStreamProvider(){

                public DnsServerAddressStream nameServerAddressStream(String hostname) {
                    return overriddenHostnames.contains(hostname) ? DnsServerAddresses.sequential((InetSocketAddress[])new InetSocketAddress[]{dnsServer2.localAddress()}).stream() : null;
                }
            }).build();
            try {
                Map<String, InetAddress> resultA = DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, DnsRecordType.AAAA);
                for (Map.Entry<String, InetAddress> resolvedEntry : resultA.entrySet()) {
                    if (resolvedEntry.getValue().isLoopbackAddress()) continue;
                    if (overriddenHostnames.contains(resolvedEntry.getKey())) {
                        Assert.assertEquals((String)("failed to resolve " + resolvedEntry.getKey()), (Object)"13.250.177.223", (Object)resolvedEntry.getValue().getHostAddress());
                        continue;
                    }
                    Assert.assertNotEquals((String)("failed to resolve " + resolvedEntry.getKey()), (Object)"13.250.177.223", (Object)resolvedEntry.getValue().getHostAddress());
                }
            }
            finally {
                resolver.close();
            }
        }
        finally {
            dnsServer2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveA() throws Exception {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(ResolvedAddressTypes.IPV4_ONLY).ttl(Integer.MAX_VALUE, Integer.MAX_VALUE).build();
        try {
            Map<String, InetAddress> resultA = DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, null);
            Map<String, InetAddress> resultB = DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, null);
            Assert.assertThat((Object)resultB.size(), (Matcher)Matchers.is((Object)resultA.size()));
            for (Map.Entry<String, InetAddress> e : resultA.entrySet()) {
                InetAddress expected = e.getValue();
                InetAddress actual = resultB.get(e.getKey());
                if (!actual.equals(expected)) {
                    System.err.println("Cache for " + e.getKey() + ": " + resolver.resolveAll(e.getKey()).getNow());
                }
                Assert.assertThat((Object)actual, (Matcher)Matchers.is((Object)expected));
            }
        }
        finally {
            resolver.close();
        }
    }

    @Test
    public void testResolveAAAA() throws Exception {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(ResolvedAddressTypes.IPV6_ONLY).build();
        try {
            DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_AAAA, null);
        }
        finally {
            resolver.close();
        }
    }

    @Test
    public void testNonCachedResolve() throws Exception {
        DnsNameResolver resolver = DnsNameResolverTest.newNonCachedResolver(ResolvedAddressTypes.IPV4_ONLY).build();
        try {
            DnsNameResolverTest.testResolve0(resolver, EXCLUSIONS_RESOLVE_A, null);
        }
        finally {
            resolver.close();
        }
    }

    @Test(timeout=30000L)
    public void testNonCachedResolveEmptyHostName() throws Exception {
        DnsNameResolverTest.testNonCachedResolveEmptyHostName("");
    }

    @Test(timeout=30000L)
    public void testNonCachedResolveNullHostName() throws Exception {
        DnsNameResolverTest.testNonCachedResolveEmptyHostName(null);
    }

    private static void testNonCachedResolveEmptyHostName(String inetHost) throws Exception {
        DnsNameResolver resolver = DnsNameResolverTest.newNonCachedResolver(ResolvedAddressTypes.IPV4_ONLY).build();
        try {
            InetAddress addr = (InetAddress)resolver.resolve(inetHost).syncUninterruptibly().getNow();
            Assert.assertEquals((Object)SocketUtils.addressByName((String)inetHost), (Object)addr);
        }
        finally {
            resolver.close();
        }
    }

    @Test(timeout=30000L)
    public void testNonCachedResolveAllEmptyHostName() throws Exception {
        DnsNameResolverTest.testNonCachedResolveAllEmptyHostName("");
    }

    @Test(timeout=30000L)
    public void testNonCachedResolveAllNullHostName() throws Exception {
        DnsNameResolverTest.testNonCachedResolveAllEmptyHostName(null);
    }

    private static void testNonCachedResolveAllEmptyHostName(String inetHost) throws UnknownHostException {
        DnsNameResolver resolver = DnsNameResolverTest.newNonCachedResolver(ResolvedAddressTypes.IPV4_ONLY).build();
        try {
            List addrs = (List)resolver.resolveAll(inetHost).syncUninterruptibly().getNow();
            Assert.assertEquals(Arrays.asList(SocketUtils.allAddressesByName((String)inetHost)), (Object)addrs);
        }
        finally {
            resolver.close();
        }
    }

    private static Map<String, InetAddress> testResolve0(DnsNameResolver resolver, Set<String> excludedDomains, DnsRecordType cancelledType) throws InterruptedException {
        Assert.assertThat((Object)resolver.isRecursionDesired(), (Matcher)Matchers.is((Object)true));
        HashMap<String, InetAddress> results = new HashMap<String, InetAddress>();
        LinkedHashMap<String, Future<InetAddress>> futures = new LinkedHashMap<String, Future<InetAddress>>();
        for (String string : DOMAINS) {
            if (excludedDomains.contains(string)) continue;
            DnsNameResolverTest.resolve(resolver, futures, string);
        }
        for (Map.Entry entry : futures.entrySet()) {
            String unresolved = (String)entry.getKey();
            InetAddress resolved = (InetAddress)((Future)entry.getValue()).sync().getNow();
            logger.info("{}: {}", (Object)unresolved, (Object)resolved.getHostAddress());
            Assert.assertThat((Object)resolved.getHostName(), (Matcher)Matchers.is((Object)unresolved));
            boolean typeMatches = false;
            for (InternetProtocolFamily f : resolver.resolvedInternetProtocolFamiliesUnsafe()) {
                Class<?> resolvedType = resolved.getClass();
                if (!f.addressType().isAssignableFrom(resolvedType)) continue;
                typeMatches = true;
            }
            Assert.assertThat((Object)typeMatches, (Matcher)Matchers.is((Object)true));
            results.put(resolved.getHostName(), resolved);
        }
        DnsNameResolverTest.assertQueryObserver(resolver, cancelledType);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryMx() {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver().build();
        try {
            Assert.assertThat((Object)resolver.isRecursionDesired(), (Matcher)Matchers.is((Object)true));
            LinkedHashMap<String, Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>> futures = new LinkedHashMap<String, Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>>();
            for (String string : DOMAINS) {
                if (EXCLUSIONS_QUERY_MX.contains(string)) continue;
                DnsNameResolverTest.queryMx(resolver, futures, string);
            }
            for (Map.Entry entry : futures.entrySet()) {
                String hostname = (String)entry.getKey();
                Future f = ((Future)entry.getValue()).awaitUninterruptibly();
                DnsResponse response = (DnsResponse)((AddressedEnvelope)f.getNow()).content();
                Assert.assertThat((Object)response.code(), (Matcher)Matchers.is((Object)DnsResponseCode.NOERROR));
                int answerCount = response.count(DnsSection.ANSWER);
                ArrayList<DnsRecord> mxList = new ArrayList<DnsRecord>(answerCount);
                for (int i = 0; i < answerCount; ++i) {
                    DnsRecord r = response.recordAt(DnsSection.ANSWER, i);
                    if (r.type() != DnsRecordType.MX) continue;
                    mxList.add(r);
                }
                Assert.assertThat((Object)mxList.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
                StringBuilder buf = new StringBuilder();
                for (DnsRecord r : mxList) {
                    ByteBuf recordContent = ((ByteBufHolder)r).content();
                    buf.append(StringUtil.NEWLINE);
                    buf.append('\t');
                    buf.append(r.name());
                    buf.append(' ');
                    buf.append(r.type().name());
                    buf.append(' ');
                    buf.append(recordContent.readUnsignedShort());
                    buf.append(' ');
                    buf.append(DnsResolveContext.decodeDomainName((ByteBuf)recordContent));
                }
                logger.info("{} has the following MX records:{}", (Object)hostname, (Object)buf);
                response.release();
                DnsNameResolverTest.assertNoQueriesMade(resolver);
            }
        }
        finally {
            resolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegativeTtl() throws Exception {
        final DnsNameResolver resolver = DnsNameResolverTest.newResolver().negativeTtl(10).build();
        try {
            DnsNameResolverTest.resolveNonExistentDomain(resolver);
            int size = 10000;
            final ArrayList exceptions = new ArrayList();
            Thread negativeLookupThread = new Thread(){

                @Override
                public void run() {
                    for (int i = 0; i < 10000; ++i) {
                        exceptions.add(DnsNameResolverTest.resolveNonExistentDomain(resolver));
                        if (this.isInterrupted()) break;
                    }
                }
            };
            negativeLookupThread.start();
            negativeLookupThread.join(30000L);
            if (negativeLookupThread.isAlive()) {
                negativeLookupThread.interrupt();
                Assert.fail((String)"Cached negative lookups did not finish quickly.");
            }
            Assert.assertThat(exceptions, (Matcher)Matchers.hasSize((int)10000));
        }
        finally {
            resolver.close();
        }
    }

    private static UnknownHostException resolveNonExistentDomain(DnsNameResolver resolver) {
        try {
            resolver.resolve("non-existent.netty.io").sync();
            Assert.fail();
            return null;
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(UnknownHostException.class)));
            TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = (TestRecursiveCacheDnsQueryLifecycleObserverFactory)resolver.dnsQueryLifecycleObserverFactory();
            TestDnsQueryLifecycleObserver observer = lifecycleObserverFactory.observers.poll();
            if (observer != null) {
                Object o = observer.events.poll();
                if (o instanceof QueryCancelledEvent) {
                    Assert.assertTrue((String)("unexpected type: " + observer.question), (observer.question.type() == DnsRecordType.CNAME || observer.question.type() == DnsRecordType.AAAA ? 1 : 0) != 0);
                } else if (o instanceof QueryWrittenEvent) {
                    QueryFailedEvent queryFailedEvent = (QueryFailedEvent)observer.events.poll();
                } else if (!(o instanceof QueryFailedEvent)) {
                    Assert.fail((String)("unexpected event type: " + o));
                }
                Assert.assertTrue((boolean)observer.events.isEmpty());
            }
            return (UnknownHostException)e;
        }
    }

    @Test
    public void testResolveIp() {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver().build();
        try {
            InetAddress address = (InetAddress)resolver.resolve("10.0.0.1").syncUninterruptibly().getNow();
            Assert.assertEquals((Object)"10.0.0.1", (Object)address.getHostAddress());
            DnsNameResolverTest.assertNoQueriesMade(resolver);
        }
        finally {
            resolver.close();
        }
    }

    @Test
    public void testResolveEmptyIpv4() {
        DnsNameResolverTest.testResolve0(ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, "");
    }

    @Test
    public void testResolveEmptyIpv6() {
        DnsNameResolverTest.testResolve0(ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, "");
    }

    @Test
    public void testResolveNullIpv4() {
        DnsNameResolverTest.testResolve0(ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, null);
    }

    @Test
    public void testResolveNullIpv6() {
        DnsNameResolverTest.testResolve0(ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolve0(ResolvedAddressTypes addressTypes, InetAddress expectedAddr, String name) {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(addressTypes).build();
        try {
            InetAddress address = (InetAddress)resolver.resolve(name).syncUninterruptibly().getNow();
            Assert.assertEquals((Object)expectedAddr, (Object)address);
            DnsNameResolverTest.assertNoQueriesMade(resolver);
        }
        finally {
            resolver.close();
        }
    }

    @Test
    public void testResolveAllEmptyIpv4() {
        DnsNameResolverTest.testResolveAll0(ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, "");
    }

    @Test
    public void testResolveAllEmptyIpv6() {
        DnsNameResolverTest.testResolveAll0(ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, "");
    }

    @Test
    public void testCNAMEResolveAllIpv4() throws IOException {
        DnsNameResolverTest.testCNAMERecursiveResolve(true);
    }

    @Test
    public void testCNAMEResolveAllIpv6() throws IOException {
        DnsNameResolverTest.testCNAMERecursiveResolve(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCNAMERecursiveResolve(boolean ipv4Preferred) throws IOException {
        String firstName = "firstname.com";
        String secondName = "secondname.com";
        String lastName = "lastname.com";
        String ipv4Addr = "1.2.3.4";
        String ipv6Addr = "::1";
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                ResourceRecordModifier rm;
                block5: {
                    block7: {
                        block6: {
                            block4: {
                                rm = new ResourceRecordModifier();
                                rm.setDnsClass(RecordClass.IN);
                                rm.setDnsName(question.getDomainName());
                                rm.setDnsTtl(100);
                                rm.setDnsType(RecordType.CNAME);
                                if (!question.getDomainName().equals("firstname.com")) break block4;
                                rm.put("apacheDnsDomainName", "secondname.com");
                                break block5;
                            }
                            if (!question.getDomainName().equals("secondname.com")) break block6;
                            rm.put("apacheDnsDomainName", "lastname.com");
                            break block5;
                        }
                        if (!question.getDomainName().equals("lastname.com")) break block7;
                        rm.setDnsType(question.getRecordType());
                        switch (question.getRecordType()) {
                            case A: {
                                rm.put("apacheDnsIpAddress", "1.2.3.4");
                                break block5;
                            }
                            case AAAA: {
                                rm.put("apacheDnsIpAddress", "::1");
                                break block5;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    return null;
                }
                return Collections.singleton(rm.getEntry());
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().recursionDesired(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            if (ipv4Preferred) {
                builder.resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED);
            } else {
                builder.resolvedAddressTypes(ResolvedAddressTypes.IPV6_PREFERRED);
            }
            resolver = builder.build();
            InetAddress resolvedAddress = (InetAddress)resolver.resolve("firstname.com").syncUninterruptibly().getNow();
            if (ipv4Preferred) {
                Assert.assertEquals((Object)"1.2.3.4", (Object)resolvedAddress.getHostAddress());
            } else {
                Assert.assertEquals((Object)"::1", (Object)NetUtil.toAddressString((InetAddress)resolvedAddress));
            }
            Assert.assertEquals((Object)"firstname.com", (Object)resolvedAddress.getHostName());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @Test
    public void testCNAMERecursiveResolveMultipleNameServersIPv4() throws IOException {
        DnsNameResolverTest.testCNAMERecursiveResolveMultipleNameServers(true);
    }

    @Test
    public void testCNAMERecursiveResolveMultipleNameServersIPv6() throws IOException {
        DnsNameResolverTest.testCNAMERecursiveResolveMultipleNameServers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testCNAMERecursiveResolveMultipleNameServers(boolean ipv4Preferred) throws IOException {
        String firstName = "firstname.nettyfoo.com";
        String lastName = "lastname.nettybar.com";
        String ipv4Addr = "1.2.3.4";
        String ipv6Addr = "::1";
        final AtomicBoolean hitServer2 = new AtomicBoolean();
        final TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
                hitServer2.set(true);
                if (question.getDomainName().equals("firstname.nettyfoo.com")) {
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(question.getDomainName());
                    rm.setDnsTtl(100);
                    rm.setDnsType(RecordType.CNAME);
                    rm.put("apacheDnsDomainName", "lastname.nettybar.com");
                    return Collections.singleton(rm.getEntry());
                }
                throw new DnsException(ResponseCode.REFUSED);
            }
        });
        final TestDnsServer dnsServer3 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
                if (question.getDomainName().equals("lastname.nettybar.com")) {
                    ResourceRecordModifier rm = new ResourceRecordModifier();
                    rm.setDnsClass(RecordClass.IN);
                    rm.setDnsName(question.getDomainName());
                    rm.setDnsTtl(100);
                    rm.setDnsType(question.getRecordType());
                    switch (question.getRecordType()) {
                        case A: {
                            rm.put("apacheDnsIpAddress", "1.2.3.4");
                            break;
                        }
                        case AAAA: {
                            rm.put("apacheDnsIpAddress", "::1");
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    return Collections.singleton(rm.getEntry());
                }
                throw new DnsException(ResponseCode.REFUSED);
            }
        });
        dnsServer2.start();
        dnsServer3.start();
        DnsNameResolver resolver = null;
        try {
            DefaultAuthoritativeDnsServerCache nsCache = new DefaultAuthoritativeDnsServerCache();
            nsCache.cache("nettyfoo.com.", dnsServer2.localAddress(), 10000L, group.next());
            resolver = new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), (DnsCache)NoopDnsCache.INSTANCE, (AuthoritativeDnsServerCache)nsCache, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 3000L, ipv4Preferred ? ResolvedAddressTypes.IPV4_ONLY : ResolvedAddressTypes.IPV6_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)new SequentialDnsServerAddressStreamProvider(new InetSocketAddress[]{dnsServer2.localAddress(), dnsServer3.localAddress()}), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true){

                InetSocketAddress newRedirectServerAddress(InetAddress server) {
                    int port = hitServer2.get() ? dnsServer3.localAddress().getPort() : dnsServer2.localAddress().getPort();
                    return new InetSocketAddress(server, port);
                }
            };
            InetAddress resolvedAddress = (InetAddress)resolver.resolve("firstname.nettyfoo.com").syncUninterruptibly().getNow();
            if (ipv4Preferred) {
                Assert.assertEquals((Object)"1.2.3.4", (Object)resolvedAddress.getHostAddress());
            } else {
                Assert.assertEquals((Object)"::1", (Object)NetUtil.toAddressString((InetAddress)resolvedAddress));
            }
            Assert.assertEquals((Object)"firstname.nettyfoo.com", (Object)resolvedAddress.getHostName());
        }
        finally {
            dnsServer2.stop();
            dnsServer3.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @Test
    public void testResolveAllNullIpv4() {
        DnsNameResolverTest.testResolveAll0(ResolvedAddressTypes.IPV4_ONLY, NetUtil.LOCALHOST4, null);
    }

    @Test
    public void testResolveAllNullIpv6() {
        DnsNameResolverTest.testResolveAll0(ResolvedAddressTypes.IPV6_ONLY, NetUtil.LOCALHOST6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolveAll0(ResolvedAddressTypes addressTypes, InetAddress expectedAddr, String name) {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(addressTypes).build();
        try {
            List addresses = (List)resolver.resolveAll(name).syncUninterruptibly().getNow();
            Assert.assertEquals((long)1L, (long)addresses.size());
            Assert.assertEquals((Object)expectedAddr, addresses.get(0));
            DnsNameResolverTest.assertNoQueriesMade(resolver);
        }
        finally {
            resolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveAllMx() {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver().build();
        try {
            Assert.assertThat((Object)resolver.isRecursionDesired(), (Matcher)Matchers.is((Object)true));
            LinkedHashMap<String, Future> futures = new LinkedHashMap<String, Future>();
            for (String string : DOMAINS) {
                if (EXCLUSIONS_QUERY_MX.contains(string)) continue;
                futures.put(string, resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion(string, DnsRecordType.MX)));
            }
            for (Map.Entry entry : futures.entrySet()) {
                String hostname = (String)entry.getKey();
                Future f = ((Future)entry.getValue()).awaitUninterruptibly();
                List mxList = (List)f.getNow();
                Assert.assertThat((Object)mxList.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
                StringBuilder buf = new StringBuilder();
                for (DnsRecord r : mxList) {
                    ByteBuf recordContent = ((ByteBufHolder)r).content();
                    buf.append(StringUtil.NEWLINE);
                    buf.append('\t');
                    buf.append(r.name());
                    buf.append(' ');
                    buf.append(r.type().name());
                    buf.append(' ');
                    buf.append(recordContent.readUnsignedShort());
                    buf.append(' ');
                    buf.append(DnsResolveContext.decodeDomainName((ByteBuf)recordContent));
                    ReferenceCountUtil.release((Object)r);
                }
                logger.info("{} has the following MX records:{}", (Object)hostname, (Object)buf);
            }
        }
        finally {
            resolver.close();
        }
    }

    @Test
    public void testResolveAllHostsFile() {
        DnsNameResolver resolver = new DnsNameResolverBuilder(group.next()).channelType(NioDatagramChannel.class).hostsFileEntriesResolver(new HostsFileEntriesResolver(){

            public InetAddress address(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
                if ("foo.com.".equals(inetHost)) {
                    try {
                        return InetAddress.getByAddress("foo.com", new byte[]{1, 2, 3, 4});
                    }
                    catch (UnknownHostException e) {
                        throw new Error(e);
                    }
                }
                return null;
            }
        }).build();
        List records = (List)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("foo.com.", DnsRecordType.A)).syncUninterruptibly().getNow();
        Assert.assertThat((Object)records, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(records.get(0), (Matcher)Matchers.instanceOf(DnsRawRecord.class));
        DnsRawRecord record = (DnsRawRecord)records.get(0);
        ByteBuf content = record.content();
        Assert.assertThat((Object)record.name(), (Matcher)Matchers.is((Object)"foo.com."));
        Assert.assertThat((Object)record.dnsClass(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)record.type(), (Matcher)Matchers.is((Object)DnsRecordType.A));
        Assert.assertThat((Object)content.readableBytes(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)content.readInt(), (Matcher)Matchers.is((Object)16909060));
        record.release();
    }

    @Test
    public void testResolveDecodeUnicode() {
        DnsNameResolverTest.testResolveUnicode(true);
    }

    @Test
    public void testResolveNotDecodeUnicode() {
        DnsNameResolverTest.testResolveUnicode(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolveUnicode(boolean decode) {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(decode).build();
        try {
            for (Map.Entry<String, String> entries : DOMAINS_PUNYCODE.entrySet()) {
                InetAddress address = (InetAddress)resolver.resolve(entries.getKey()).syncUninterruptibly().getNow();
                Assert.assertEquals((Object)(decode ? entries.getKey() : entries.getValue()), (Object)address.getHostName());
            }
            DnsNameResolverTest.assertQueryObserver(resolver, DnsRecordType.AAAA);
        }
        finally {
            resolver.close();
        }
    }

    @Test(timeout=30000L)
    public void secondDnsServerShouldBeUsedBeforeCNAMEFirstServerNotStarted() throws IOException {
        DnsNameResolverTest.secondDnsServerShouldBeUsedBeforeCNAME(false);
    }

    @Test(timeout=30000L)
    public void secondDnsServerShouldBeUsedBeforeCNAMEFirstServerFailResolve() throws IOException {
        DnsNameResolverTest.secondDnsServerShouldBeUsedBeforeCNAME(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void secondDnsServerShouldBeUsedBeforeCNAME(boolean startDnsServer1) throws IOException {
        String knownHostName = "netty.io";
        TestDnsServer dnsServer1 = new TestDnsServer(Collections.singleton("notnetty.com"));
        TestDnsServer dnsServer2 = new TestDnsServer(Collections.singleton("netty.io"));
        DnsNameResolver resolver = null;
        try {
            InetSocketAddress dnsServer1Address;
            if (startDnsServer1) {
                dnsServer1.start();
                dnsServer1Address = dnsServer1.localAddress();
            } else {
                dnsServer1Address = new InetSocketAddress("127.0.0.1", 22);
            }
            dnsServer2.start();
            TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = new TestRecursiveCacheDnsQueryLifecycleObserverFactory();
            DnsNameResolverBuilder builder = new DnsNameResolverBuilder(group.next()).dnsQueryLifecycleObserverFactory((DnsQueryLifecycleObserverFactory)lifecycleObserverFactory).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).channelType(NioDatagramChannel.class).queryTimeoutMillis(1000L).optResourceEnabled(false).ndots(1);
            builder.nameServerProvider((DnsServerAddressStreamProvider)new SequentialDnsServerAddressStreamProvider(new InetSocketAddress[]{dnsServer1Address, dnsServer2.localAddress()}));
            resolver = builder.build();
            Assert.assertNotNull((Object)resolver.resolve("netty.io").syncUninterruptibly().getNow());
            TestDnsQueryLifecycleObserver observer = lifecycleObserverFactory.observers.poll();
            Assert.assertNotNull((Object)observer);
            Assert.assertEquals((long)1L, (long)lifecycleObserverFactory.observers.size());
            Assert.assertEquals((long)2L, (long)observer.events.size());
            QueryWrittenEvent writtenEvent = (QueryWrittenEvent)observer.events.poll();
            Assert.assertEquals((Object)dnsServer1Address, (Object)writtenEvent.dnsServerAddress);
            QueryFailedEvent failedEvent = (QueryFailedEvent)observer.events.poll();
            observer = lifecycleObserverFactory.observers.poll();
            Assert.assertEquals((long)2L, (long)observer.events.size());
            writtenEvent = (QueryWrittenEvent)observer.events.poll();
            Assert.assertEquals((Object)dnsServer2.localAddress(), (Object)writtenEvent.dnsServerAddress);
            QuerySucceededEvent querySucceededEvent = (QuerySucceededEvent)observer.events.poll();
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
            dnsServer1.stop();
            dnsServer2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void aAndAAAAQueryShouldTryFirstDnsServerBeforeSecond() throws IOException {
        String knownHostName = "netty.io";
        TestDnsServer dnsServer1 = new TestDnsServer(Collections.singleton("notnetty.com"));
        TestDnsServer dnsServer2 = new TestDnsServer(Collections.singleton("netty.io"));
        DnsNameResolver resolver = null;
        try {
            dnsServer1.start();
            dnsServer2.start();
            TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = new TestRecursiveCacheDnsQueryLifecycleObserverFactory();
            DnsNameResolverBuilder builder = new DnsNameResolverBuilder(group.next()).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).dnsQueryLifecycleObserverFactory((DnsQueryLifecycleObserverFactory)lifecycleObserverFactory).channelType(NioDatagramChannel.class).optResourceEnabled(false).ndots(1);
            builder.nameServerProvider((DnsServerAddressStreamProvider)new SequentialDnsServerAddressStreamProvider(new InetSocketAddress[]{dnsServer1.localAddress(), dnsServer2.localAddress()}));
            resolver = builder.build();
            Assert.assertNotNull((Object)resolver.resolve("netty.io").syncUninterruptibly().getNow());
            TestDnsQueryLifecycleObserver observer = lifecycleObserverFactory.observers.poll();
            Assert.assertNotNull((Object)observer);
            Assert.assertEquals((long)1L, (long)lifecycleObserverFactory.observers.size());
            Assert.assertEquals((long)2L, (long)observer.events.size());
            QueryWrittenEvent writtenEvent = (QueryWrittenEvent)observer.events.poll();
            Assert.assertEquals((Object)dnsServer1.localAddress(), (Object)writtenEvent.dnsServerAddress);
            QueryFailedEvent failedEvent = (QueryFailedEvent)observer.events.poll();
            observer = lifecycleObserverFactory.observers.poll();
            Assert.assertEquals((long)2L, (long)observer.events.size());
            writtenEvent = (QueryWrittenEvent)observer.events.poll();
            Assert.assertEquals((Object)dnsServer2.localAddress(), (Object)writtenEvent.dnsServerAddress);
            QuerySucceededEvent querySucceededEvent = (QuerySucceededEvent)observer.events.poll();
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
            dnsServer1.stop();
            dnsServer2.stop();
        }
    }

    @Test
    public void testRecursiveResolveNoCache() throws Exception {
        DnsNameResolverTest.testRecursiveResolveCache(false);
    }

    @Test
    public void testRecursiveResolveCache() throws Exception {
        DnsNameResolverTest.testRecursiveResolveCache(true);
    }

    @Test
    public void testIpv4PreferredWhenIpv6First() throws Exception {
        DnsNameResolverTest.testResolvesPreferredWhenNonPreferredFirst0(ResolvedAddressTypes.IPV4_PREFERRED);
    }

    @Test
    public void testIpv6PreferredWhenIpv4First() throws Exception {
        DnsNameResolverTest.testResolvesPreferredWhenNonPreferredFirst0(ResolvedAddressTypes.IPV6_PREFERRED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolvesPreferredWhenNonPreferredFirst0(ResolvedAddressTypes types) throws Exception {
        String name = "netty.com";
        ArrayList<Set<ResourceRecord>> records = new ArrayList<Set<ResourceRecord>>();
        String ipv6Address = "0:0:0:0:0:0:1:1";
        String ipv4Address = "1.1.1.1";
        if (types == ResolvedAddressTypes.IPV4_PREFERRED) {
            records.add(Collections.singleton(TestDnsServer.newAddressRecord("netty.com", RecordType.AAAA, "0:0:0:0:0:0:1:1")));
            records.add(Collections.singleton(TestDnsServer.newAddressRecord("netty.com", RecordType.A, "1.1.1.1")));
        } else {
            records.add(Collections.singleton(TestDnsServer.newAddressRecord("netty.com", RecordType.A, "1.1.1.1")));
            records.add(Collections.singleton(TestDnsServer.newAddressRecord("netty.com", RecordType.AAAA, "0:0:0:0:0:0:1:1")));
        }
        final Iterator recordsIterator = records.iterator();
        RecordStore arbitrarilyOrderedStore = new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord questionRecord) {
                return (Set)recordsIterator.next();
            }
        };
        TestDnsServer nonCompliantDnsServer = new TestDnsServer(arbitrarilyOrderedStore);
        nonCompliantDnsServer.start();
        try {
            DnsNameResolver resolver = DnsNameResolverTest.newResolver(types).maxQueriesPerResolve(2).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(nonCompliantDnsServer.localAddress())).build();
            InetAddress resolved = (InetAddress)resolver.resolve("netty.com").syncUninterruptibly().getNow();
            if (types == ResolvedAddressTypes.IPV4_PREFERRED) {
                Assert.assertEquals((Object)"1.1.1.1", (Object)resolved.getHostAddress());
            } else {
                Assert.assertEquals((Object)"0:0:0:0:0:0:1:1", (Object)resolved.getHostAddress());
            }
            InetAddress ipv4InetAddress = InetAddress.getByAddress("netty.com", InetAddress.getByName("1.1.1.1").getAddress());
            InetAddress ipv6InetAddress = InetAddress.getByAddress("netty.com", InetAddress.getByName("0:0:0:0:0:0:1:1").getAddress());
            List resolvedAll = (List)resolver.resolveAll("netty.com").syncUninterruptibly().getNow();
            List<InetAddress> expected = types == ResolvedAddressTypes.IPV4_PREFERRED ? Arrays.asList(ipv4InetAddress, ipv6InetAddress) : Arrays.asList(ipv6InetAddress, ipv4InetAddress);
            Assert.assertEquals(expected, (Object)resolvedAll);
        }
        finally {
            nonCompliantDnsServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testRecursiveResolveCache(boolean cache) throws Exception {
        String hostname = "some.record.netty.io";
        String hostname2 = "some2.record.netty.io";
        final TestDnsServer dnsServerAuthority = new TestDnsServer(new HashSet<String>(Arrays.asList("some.record.netty.io", "some2.record.netty.io")));
        dnsServerAuthority.start();
        RedirectingTestDnsServer dnsServer = new RedirectingTestDnsServer("some.record.netty.io", dnsServerAuthority.localAddress().getAddress().getHostAddress());
        dnsServer.start();
        TestAuthoritativeDnsServerCache nsCache = new TestAuthoritativeDnsServerCache((AuthoritativeDnsServerCache)(cache ? new DefaultAuthoritativeDnsServerCache() : NoopAuthoritativeDnsServerCache.INSTANCE));
        TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = new TestRecursiveCacheDnsQueryLifecycleObserverFactory();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        DnsNameResolver resolver = new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), (DnsCache)NoopDnsCache.INSTANCE, nsCache, lifecycleObserverFactory, 3000L, ResolvedAddressTypes.IPV4_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer.localAddress()), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true){

            InetSocketAddress newRedirectServerAddress(InetAddress server) {
                if (server.equals(dnsServerAuthority.localAddress().getAddress())) {
                    return new InetSocketAddress(server, dnsServerAuthority.localAddress().getPort());
                }
                return super.newRedirectServerAddress(server);
            }
        };
        String expectedDnsName = PlatformDependent.javaVersion() == 7 ? "dns4.some.record.netty.io" : "dns4.some.record.netty.io.";
        try {
            resolver.resolveAll("some.record.netty.io").syncUninterruptibly();
            TestDnsQueryLifecycleObserver observer = lifecycleObserverFactory.observers.poll();
            Assert.assertNotNull((Object)observer);
            Assert.assertTrue((boolean)lifecycleObserverFactory.observers.isEmpty());
            Assert.assertEquals((long)4L, (long)observer.events.size());
            QueryWrittenEvent writtenEvent1 = (QueryWrittenEvent)observer.events.poll();
            Assert.assertEquals((Object)dnsServer.localAddress(), (Object)writtenEvent1.dnsServerAddress);
            QueryRedirectedEvent redirectedEvent = (QueryRedirectedEvent)observer.events.poll();
            Assert.assertEquals((Object)expectedDnsName, (Object)redirectedEvent.nameServers.get(0).getHostName());
            Assert.assertEquals((Object)dnsServerAuthority.localAddress(), (Object)redirectedEvent.nameServers.get(0));
            QueryWrittenEvent writtenEvent2 = (QueryWrittenEvent)observer.events.poll();
            Assert.assertEquals((Object)dnsServerAuthority.localAddress(), (Object)writtenEvent2.dnsServerAddress);
            QuerySucceededEvent succeededEvent = (QuerySucceededEvent)observer.events.poll();
            if (cache) {
                Assert.assertNull((Object)nsCache.cache.get("io."));
                Assert.assertNull((Object)nsCache.cache.get("netty.io."));
                DnsServerAddressStream entries = nsCache.cache.get("record.netty.io.");
                Assert.assertEquals((long)2L, (long)entries.size());
                Assert.assertFalse((boolean)entries.next().isUnresolved());
                Assert.assertTrue((boolean)entries.next().isUnresolved());
                Assert.assertNull((Object)nsCache.cache.get("some.record.netty.io"));
                resolver.resolveAll("some.record.netty.io").syncUninterruptibly();
                observer = lifecycleObserverFactory.observers.poll();
                Assert.assertNotNull((Object)observer);
                Assert.assertTrue((boolean)lifecycleObserverFactory.observers.isEmpty());
                Assert.assertEquals((long)2L, (long)observer.events.size());
                writtenEvent1 = (QueryWrittenEvent)observer.events.poll();
                Assert.assertEquals((Object)expectedDnsName, (Object)writtenEvent1.dnsServerAddress.getHostName());
                Assert.assertEquals((Object)dnsServerAuthority.localAddress(), (Object)writtenEvent1.dnsServerAddress);
                succeededEvent = (QuerySucceededEvent)observer.events.poll();
                resolver.resolveAll("some2.record.netty.io").syncUninterruptibly();
                observer = lifecycleObserverFactory.observers.poll();
                Assert.assertNotNull((Object)observer);
                Assert.assertTrue((boolean)lifecycleObserverFactory.observers.isEmpty());
                Assert.assertEquals((long)2L, (long)observer.events.size());
                writtenEvent1 = (QueryWrittenEvent)observer.events.poll();
                Assert.assertEquals((Object)expectedDnsName, (Object)writtenEvent1.dnsServerAddress.getHostName());
                Assert.assertEquals((Object)dnsServerAuthority.localAddress(), (Object)writtenEvent1.dnsServerAddress);
                succeededEvent = (QuerySucceededEvent)observer.events.poll();
                Assert.assertNull((Object)nsCache.cacheHits.get("io."));
                Assert.assertNull((Object)nsCache.cacheHits.get("netty.io."));
                Assert.assertNotNull((Object)nsCache.cacheHits.get("record.netty.io."));
                Assert.assertNull((Object)nsCache.cacheHits.get("some.record.netty.io."));
            }
        }
        finally {
            resolver.close();
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            dnsServer.stop();
            dnsServerAuthority.stop();
        }
    }

    @Test
    public void testFollowNsRedirectsNoopCaches() throws Exception {
        this.testFollowNsRedirects((DnsCache)NoopDnsCache.INSTANCE, (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE, false);
    }

    @Test
    public void testFollowNsRedirectsNoopDnsCache() throws Exception {
        this.testFollowNsRedirects((DnsCache)NoopDnsCache.INSTANCE, (AuthoritativeDnsServerCache)new DefaultAuthoritativeDnsServerCache(), false);
    }

    @Test
    public void testFollowNsRedirectsNoopAuthoritativeDnsServerCache() throws Exception {
        this.testFollowNsRedirects((DnsCache)new DefaultDnsCache(), (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE, false);
    }

    @Test
    public void testFollowNsRedirectsDefaultCaches() throws Exception {
        this.testFollowNsRedirects((DnsCache)new DefaultDnsCache(), (AuthoritativeDnsServerCache)new DefaultAuthoritativeDnsServerCache(), false);
    }

    @Test
    public void testFollowNsRedirectAndTrySecondNsOnTimeout() throws Exception {
        this.testFollowNsRedirects((DnsCache)NoopDnsCache.INSTANCE, (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE, true);
    }

    @Test
    public void testFollowNsRedirectAndTrySecondNsOnTimeoutDefaultCaches() throws Exception {
        this.testFollowNsRedirects((DnsCache)new DefaultDnsCache(), (AuthoritativeDnsServerCache)new DefaultAuthoritativeDnsServerCache(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowNsRedirects(DnsCache cache, AuthoritativeDnsServerCache authoritativeDnsServerCache, final boolean invalidNsFirst) throws Exception {
        String domain = "netty.io";
        String ns1Name = "ns1.netty.io";
        String ns2Name = "ns2.netty.io";
        final InetAddress expected = InetAddress.getByAddress("some.record.netty.io", new byte[]{10, 10, 10, 10});
        final DatagramSocket socket = new DatagramSocket(new InetSocketAddress(0));
        final TestDnsServer dnsServerAuthority = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                if (question.getDomainName().equals(expected.getHostName())) {
                    return Collections.singleton(TestDnsServer.newARecord(expected.getHostName(), expected.getHostAddress()));
                }
                return Collections.emptySet();
            }
        });
        dnsServerAuthority.start();
        TestDnsServer redirectServer = new TestDnsServer(new HashSet<String>(Arrays.asList(expected.getHostName(), "ns1.netty.io", "ns2.netty.io"))){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                for (QuestionRecord record : message.getQuestionRecords()) {
                    if (!record.getDomainName().equals(expected.getHostName())) continue;
                    message.getAdditionalRecords().clear();
                    message.getAnswerRecords().clear();
                    if (invalidNsFirst) {
                        message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns2.netty.io"));
                        message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns1.netty.io"));
                    } else {
                        message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns1.netty.io"));
                        message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns2.netty.io"));
                    }
                    return message;
                }
                return message;
            }
        };
        redirectServer.start();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        DnsNameResolver resolver = new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), cache, authoritativeDnsServerCache, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 2000L, ResolvedAddressTypes.IPV4_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(redirectServer.localAddress()), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true){

            InetSocketAddress newRedirectServerAddress(InetAddress server) {
                try {
                    if (server.getHostName().startsWith("ns1.netty.io")) {
                        return new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", dnsServerAuthority.localAddress().getAddress().getAddress()), dnsServerAuthority.localAddress().getPort());
                    }
                    if (server.getHostName().startsWith("ns2.netty.io")) {
                        return new InetSocketAddress(InetAddress.getByAddress("ns2.netty.io", NetUtil.LOCALHOST.getAddress()), socket.getLocalPort());
                    }
                }
                catch (UnknownHostException e) {
                    throw new IllegalStateException(e);
                }
                return super.newRedirectServerAddress(server);
            }
        };
        try {
            List resolved = (List)resolver.resolveAll(expected.getHostName()).syncUninterruptibly().getNow();
            Assert.assertEquals((long)1L, (long)resolved.size());
            Assert.assertEquals((Object)expected, resolved.get(0));
            List resolved2 = (List)resolver.resolveAll(expected.getHostName()).syncUninterruptibly().getNow();
            Assert.assertEquals((long)1L, (long)resolved2.size());
            Assert.assertEquals((Object)expected, resolved2.get(0));
            if (authoritativeDnsServerCache != NoopAuthoritativeDnsServerCache.INSTANCE) {
                DnsServerAddressStream cached = authoritativeDnsServerCache.get("netty.io.");
                Assert.assertEquals((long)2L, (long)cached.size());
                InetSocketAddress ns1Address = InetSocketAddress.createUnresolved("ns1.netty.io.", 53);
                InetSocketAddress ns2Address = InetSocketAddress.createUnresolved("ns2.netty.io.", 53);
                if (invalidNsFirst) {
                    Assert.assertEquals((Object)ns2Address, (Object)cached.next());
                    Assert.assertEquals((Object)ns1Address, (Object)cached.next());
                } else {
                    Assert.assertEquals((Object)ns1Address, (Object)cached.next());
                    Assert.assertEquals((Object)ns2Address, (Object)cached.next());
                }
            }
            if (cache != NoopDnsCache.INSTANCE) {
                List ns1Cached = cache.get("ns1.netty.io.", null);
                Assert.assertEquals((long)1L, (long)ns1Cached.size());
                DnsCacheEntry nsEntry = (DnsCacheEntry)ns1Cached.get(0);
                Assert.assertNotNull((Object)nsEntry.address());
                Assert.assertNull((Object)nsEntry.cause());
                List ns2Cached = cache.get("ns2.netty.io.", null);
                if (invalidNsFirst) {
                    Assert.assertEquals((long)1L, (long)ns2Cached.size());
                    DnsCacheEntry ns2Entry = (DnsCacheEntry)ns2Cached.get(0);
                    Assert.assertNotNull((Object)ns2Entry.address());
                    Assert.assertNull((Object)ns2Entry.cause());
                } else {
                    Assert.assertNull((Object)ns2Cached);
                }
                List expectedCached = cache.get(expected.getHostName(), null);
                Assert.assertEquals((long)1L, (long)expectedCached.size());
                DnsCacheEntry expectedEntry = (DnsCacheEntry)expectedCached.get(0);
                Assert.assertEquals((Object)expected, (Object)expectedEntry.address());
                Assert.assertNull((Object)expectedEntry.cause());
            }
        }
        finally {
            resolver.close();
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            redirectServer.stop();
            dnsServerAuthority.stop();
            socket.close();
        }
    }

    @Test
    public void testMultipleAdditionalRecordsForSameNSRecord() throws Exception {
        DnsNameResolverTest.testMultipleAdditionalRecordsForSameNSRecord(false);
    }

    @Test
    public void testMultipleAdditionalRecordsForSameNSRecordReordered() throws Exception {
        DnsNameResolverTest.testMultipleAdditionalRecordsForSameNSRecord(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testMultipleAdditionalRecordsForSameNSRecord(final boolean reversed) throws Exception {
        String domain = "netty.io";
        String hostname = "test.netty.io";
        String ns1Name = "ns1.netty.io";
        final InetSocketAddress ns1Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", new byte[]{10, 0, 0, 1}), 53);
        final InetSocketAddress ns2Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", new byte[]{10, 0, 0, 2}), 53);
        final InetSocketAddress ns3Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", new byte[]{10, 0, 0, 3}), 53);
        final InetSocketAddress ns4Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io", new byte[]{10, 0, 0, 4}), 53);
        TestDnsServer redirectServer = new TestDnsServer(new HashSet<String>(Arrays.asList("test.netty.io", "ns1.netty.io"))){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                for (QuestionRecord record : message.getQuestionRecords()) {
                    if (!record.getDomainName().equals("test.netty.io")) continue;
                    message.getAdditionalRecords().clear();
                    message.getAnswerRecords().clear();
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns1.netty.io"));
                    message.getAdditionalRecords().add(this.newARecord(ns1Address));
                    message.getAdditionalRecords().add(this.newARecord(ns2Address));
                    message.getAdditionalRecords().add(this.newARecord(ns3Address));
                    message.getAdditionalRecords().add(this.newARecord(ns4Address));
                    return message;
                }
                return message;
            }

            private ResourceRecord newARecord(InetSocketAddress address) {
                return TestDnsServer.newARecord(address.getHostName(), address.getAddress().getHostAddress());
            }
        };
        redirectServer.start();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        final CopyOnWriteArrayList cached = new CopyOnWriteArrayList();
        AuthoritativeDnsServerCache authoritativeDnsServerCache = new AuthoritativeDnsServerCache(){

            public DnsServerAddressStream get(String hostname) {
                return null;
            }

            public void cache(String hostname, InetSocketAddress address, long originalTtl, EventLoop loop) {
                cached.add(address);
            }

            public void clear() {
            }

            public boolean clear(String hostname) {
                return false;
            }
        };
        final AtomicReference redirectedRef = new AtomicReference();
        DnsNameResolver resolver = new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), (DnsCache)NoopDnsCache.INSTANCE, authoritativeDnsServerCache, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 2000L, ResolvedAddressTypes.IPV4_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(redirectServer.localAddress()), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true){

            protected DnsServerAddressStream newRedirectDnsServerStream(String hostname, List<InetSocketAddress> nameservers) {
                if (reversed) {
                    Collections.reverse(nameservers);
                }
                SequentialDnsServerAddressStream stream = new SequentialDnsServerAddressStream(nameservers, 0);
                redirectedRef.set(stream);
                return stream;
            }
        };
        try {
            Throwable cause = resolver.resolveAll("test.netty.io").await().cause();
            Assert.assertTrue((boolean)(cause instanceof UnknownHostException));
            DnsServerAddressStream redirected = (DnsServerAddressStream)redirectedRef.get();
            Assert.assertNotNull((Object)redirected);
            Assert.assertEquals((long)4L, (long)redirected.size());
            Assert.assertEquals((long)4L, (long)cached.size());
            if (reversed) {
                Assert.assertEquals((Object)ns4Address, (Object)redirected.next());
                Assert.assertEquals((Object)ns3Address, (Object)redirected.next());
                Assert.assertEquals((Object)ns2Address, (Object)redirected.next());
                Assert.assertEquals((Object)ns1Address, (Object)redirected.next());
            } else {
                Assert.assertEquals((Object)ns1Address, (Object)redirected.next());
                Assert.assertEquals((Object)ns2Address, (Object)redirected.next());
                Assert.assertEquals((Object)ns3Address, (Object)redirected.next());
                Assert.assertEquals((Object)ns4Address, (Object)redirected.next());
            }
            Assert.assertEquals((Object)ns1Address, cached.get(0));
            Assert.assertEquals((Object)ns2Address, cached.get(1));
            Assert.assertEquals((Object)ns3Address, cached.get(2));
            Assert.assertEquals((Object)ns4Address, cached.get(3));
        }
        finally {
            resolver.close();
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            redirectServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNSRecordsFromCache() throws Exception {
        String domain = "netty.io";
        String hostname = "test.netty.io";
        String ns0Name = "ns0.netty.io.";
        String ns1Name = "ns1.netty.io.";
        String ns2Name = "ns2.netty.io.";
        final InetSocketAddress ns0Address = new InetSocketAddress(InetAddress.getByAddress("ns0.netty.io.", new byte[]{10, 1, 0, 1}), 53);
        InetSocketAddress ns1Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io.", new byte[]{10, 0, 0, 1}), 53);
        InetSocketAddress ns2Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io.", new byte[]{10, 0, 0, 2}), 53);
        InetSocketAddress ns3Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io.", new byte[]{10, 0, 0, 3}), 53);
        InetSocketAddress ns4Address = new InetSocketAddress(InetAddress.getByAddress("ns1.netty.io.", new byte[]{10, 0, 0, 4}), 53);
        final InetSocketAddress ns5Address = new InetSocketAddress(InetAddress.getByAddress("ns2.netty.io.", new byte[]{10, 0, 0, 5}), 53);
        TestDnsServer redirectServer = new TestDnsServer(new HashSet<String>(Arrays.asList("test.netty.io", "ns1.netty.io."))){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                for (QuestionRecord record : message.getQuestionRecords()) {
                    if (!record.getDomainName().equals("test.netty.io")) continue;
                    message.getAdditionalRecords().clear();
                    message.getAnswerRecords().clear();
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns0.netty.io."));
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns1.netty.io."));
                    message.getAuthorityRecords().add(TestDnsServer.newNsRecord("netty.io", "ns2.netty.io."));
                    message.getAdditionalRecords().add(this.newARecord(ns0Address));
                    message.getAdditionalRecords().add(this.newARecord(ns5Address));
                    return message;
                }
                return message;
            }

            private ResourceRecord newARecord(InetSocketAddress address) {
                return TestDnsServer.newARecord(address.getHostName(), address.getAddress().getHostAddress());
            }
        };
        redirectServer.start();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        final CopyOnWriteArrayList cached = new CopyOnWriteArrayList();
        AuthoritativeDnsServerCache authoritativeDnsServerCache = new AuthoritativeDnsServerCache(){

            public DnsServerAddressStream get(String hostname) {
                return null;
            }

            public void cache(String hostname, InetSocketAddress address, long originalTtl, EventLoop loop) {
                cached.add(address);
            }

            public void clear() {
            }

            public boolean clear(String hostname) {
                return false;
            }
        };
        EventLoop loop = group.next();
        DefaultDnsCache cache = new DefaultDnsCache();
        cache.cache("ns1.netty.io.", null, ns1Address.getAddress(), 10000L, loop);
        cache.cache("ns1.netty.io.", null, ns2Address.getAddress(), 10000L, loop);
        cache.cache("ns1.netty.io.", null, ns3Address.getAddress(), 10000L, loop);
        cache.cache("ns1.netty.io.", null, ns4Address.getAddress(), 10000L, loop);
        final AtomicReference redirectedRef = new AtomicReference();
        DnsNameResolver resolver = new DnsNameResolver(loop, (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), (DnsCache)cache, authoritativeDnsServerCache, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 2000L, ResolvedAddressTypes.IPV4_ONLY, true, 10, true, 4096, false, HostsFileEntriesResolver.DEFAULT, (DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(redirectServer.localAddress()), DnsNameResolver.DEFAULT_SEARCH_DOMAINS, 0, true){

            protected DnsServerAddressStream newRedirectDnsServerStream(String hostname, List<InetSocketAddress> nameservers) {
                SequentialDnsServerAddressStream stream = new SequentialDnsServerAddressStream(nameservers, 0);
                redirectedRef.set(stream);
                return stream;
            }
        };
        try {
            Throwable cause = resolver.resolveAll("test.netty.io").await().cause();
            Assert.assertTrue((boolean)(cause instanceof UnknownHostException));
            DnsServerAddressStream redirected = (DnsServerAddressStream)redirectedRef.get();
            Assert.assertNotNull((Object)redirected);
            Assert.assertEquals((long)6L, (long)redirected.size());
            Assert.assertEquals((long)3L, (long)cached.size());
            Assert.assertEquals((Object)ns0Address, (Object)redirected.next());
            Assert.assertEquals((Object)ns1Address, (Object)redirected.next());
            Assert.assertEquals((Object)ns2Address, (Object)redirected.next());
            Assert.assertEquals((Object)ns3Address, (Object)redirected.next());
            Assert.assertEquals((Object)ns4Address, (Object)redirected.next());
            Assert.assertEquals((Object)ns5Address, (Object)redirected.next());
            Assert.assertEquals((Object)ns0Address, cached.get(0));
            Assert.assertEquals((Object)ns5Address, cached.get(1));
            Assert.assertEquals((Object)DnsNameResolverTest.unresolved(ns1Address), cached.get(2));
        }
        finally {
            resolver.close();
            group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            redirectServer.stop();
        }
    }

    private static InetSocketAddress unresolved(InetSocketAddress address) {
        return InetSocketAddress.createUnresolved(address.getHostString(), address.getPort());
    }

    private static void resolve(DnsNameResolver resolver, Map<String, Future<InetAddress>> futures, String hostname) {
        futures.put(hostname, (Future<InetAddress>)resolver.resolve(hostname));
    }

    private static void queryMx(DnsNameResolver resolver, Map<String, Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>> futures, String hostname) {
        futures.put(hostname, (Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>)resolver.query((DnsQuestion)new DefaultDnsQuestion(hostname, DnsRecordType.MX)));
    }

    private static void assertNoQueriesMade(DnsNameResolver resolver) {
        TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = (TestRecursiveCacheDnsQueryLifecycleObserverFactory)resolver.dnsQueryLifecycleObserverFactory();
        Assert.assertTrue((boolean)lifecycleObserverFactory.observers.isEmpty());
    }

    private static void assertQueryObserver(DnsNameResolver resolver, DnsRecordType cancelledType) {
        TestDnsQueryLifecycleObserver observer;
        TestRecursiveCacheDnsQueryLifecycleObserverFactory lifecycleObserverFactory = (TestRecursiveCacheDnsQueryLifecycleObserverFactory)resolver.dnsQueryLifecycleObserverFactory();
        while ((observer = lifecycleObserverFactory.observers.poll()) != null) {
            Object o = observer.events.poll();
            if (o instanceof QueryCancelledEvent) {
                Assert.assertEquals((Object)cancelledType, (Object)observer.question.type());
            } else if (o instanceof QueryWrittenEvent) {
                QuerySucceededEvent querySucceededEvent = (QuerySucceededEvent)observer.events.poll();
            } else {
                Assert.fail((String)("unexpected event type: " + o));
            }
            Assert.assertTrue((boolean)observer.events.isEmpty());
        }
    }

    @Test(timeout=3000L)
    public void testTimeoutNotCached() {
        DnsCache cache = new DnsCache(){

            public void clear() {
            }

            public boolean clear(String hostname) {
                return false;
            }

            public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
                return Collections.emptyList();
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
                Assert.fail((String)"Should not be cached");
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
                Assert.fail((String)"Should not be cached");
                return null;
            }
        };
        DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver();
        builder.queryTimeoutMillis(100L).authoritativeDnsServerCache(cache).resolveCache(cache).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(new InetSocketAddress(NetUtil.LOCALHOST, 12345)));
        DnsNameResolver resolver = builder.build();
        Future result = resolver.resolve("doesnotexist.netty.io").awaitUninterruptibly();
        Throwable cause = result.cause();
        Assert.assertTrue((boolean)(cause instanceof UnknownHostException));
        Assert.assertTrue((boolean)(cause.getCause() instanceof DnsNameResolverTimeoutException));
        Assert.assertTrue((boolean)DnsNameResolver.isTimeoutError((Throwable)cause));
        Assert.assertTrue((boolean)DnsNameResolver.isTransportOrTimeoutError((Throwable)cause));
        resolver.close();
    }

    @Test
    public void testDnsNameResolverBuilderCopy() {
        ReflectiveChannelFactory channelFactory = new ReflectiveChannelFactory(NioDatagramChannel.class);
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder(group.next()).channelFactory((ChannelFactory)channelFactory);
        DnsNameResolverBuilder copiedBuilder = builder.copy();
        ReflectiveChannelFactory newChannelFactory = new ReflectiveChannelFactory(NioDatagramChannel.class);
        builder.channelFactory((ChannelFactory)newChannelFactory);
        Assert.assertEquals((Object)channelFactory, (Object)copiedBuilder.channelFactory());
        Assert.assertEquals((Object)newChannelFactory, (Object)builder.channelFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFollowCNAMEEvenIfARecordIsPresent() throws IOException {
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                if (question.getDomainName().equals("cname.netty.io")) {
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("apacheDnsIpAddress".toLowerCase(), "10.0.0.99");
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.A, map1));
                }
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(2);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("apacheDnsDomainName".toLowerCase(), "cname.netty.io");
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.CNAME, map));
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("apacheDnsIpAddress".toLowerCase(), "10.0.0.2");
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.A, map1));
                return records;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().recursionDesired(true).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll("somehost.netty.io").syncUninterruptibly().getNow();
            Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
            Assert.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assert.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 2})));
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFollowCNAMELoop() throws IOException {
        this.expectedException.expect(UnknownHostException.class);
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(4);
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord("x." + question.getDomainName(), RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "10.0.0.99")));
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord("cname2.netty.io", RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname.netty.io")));
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord("cname.netty.io", RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname2.netty.io")));
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname.netty.io")));
                return records;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().recursionDesired(false).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            resolver.resolveAll("somehost.netty.io").syncUninterruptibly().getNow();
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @Test
    public void testSearchDomainQueryFailureForSingleAddressTypeCompletes() {
        this.expectedException.expect(UnknownHostException.class);
        this.testSearchDomainQueryFailureCompletes(ResolvedAddressTypes.IPV4_ONLY);
    }

    @Test
    public void testSearchDomainQueryFailureForMultipleAddressTypeCompletes() {
        this.expectedException.expect(UnknownHostException.class);
        this.testSearchDomainQueryFailureCompletes(ResolvedAddressTypes.IPV4_PREFERRED);
    }

    private void testSearchDomainQueryFailureCompletes(ResolvedAddressTypes types) {
        DnsNameResolver resolver = DnsNameResolverTest.newResolver().resolvedAddressTypes(types).ndots(1).searchDomains(Collections.singletonList(".")).build();
        try {
            resolver.resolve("invalid.com").syncUninterruptibly();
        }
        finally {
            resolver.close();
        }
    }

    @Test(timeout=2000L)
    public void testCachesClearedOnClose() throws Exception {
        final CountDownLatch resolveLatch = new CountDownLatch(1);
        final CountDownLatch authoritativeLatch = new CountDownLatch(1);
        DnsNameResolver resolver = DnsNameResolverTest.newResolver().resolveCache(new DnsCache(){

            public void clear() {
                resolveLatch.countDown();
            }

            public boolean clear(String hostname) {
                return false;
            }

            public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
                return null;
            }
        }).authoritativeDnsServerCache(new DnsCache(){

            public void clear() {
                authoritativeLatch.countDown();
            }

            public boolean clear(String hostname) {
                return false;
            }

            public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
                return null;
            }

            public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
                return null;
            }
        }).build();
        resolver.close();
        resolveLatch.await();
        authoritativeLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveACachedWithDot() {
        DefaultDnsCache cache = new DefaultDnsCache();
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(ResolvedAddressTypes.IPV4_ONLY).resolveCache((DnsCache)cache).build();
        try {
            String domain = DOMAINS.iterator().next();
            String domainWithDot = domain + '.';
            resolver.resolve(domain).syncUninterruptibly();
            List cached = cache.get(domain, null);
            List cached2 = cache.get(domainWithDot, null);
            Assert.assertEquals((long)1L, (long)cached.size());
            Assert.assertSame((Object)cached, (Object)cached2);
        }
        finally {
            resolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveACachedWithDotSearchDomain() throws Exception {
        TestDnsCache cache = new TestDnsCache((DnsCache)new DefaultDnsCache());
        TestDnsServer server = new TestDnsServer(Collections.singleton("test.netty.io"));
        server.start();
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(ResolvedAddressTypes.IPV4_ONLY).searchDomains(Collections.singletonList("netty.io")).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(server.localAddress())).resolveCache((DnsCache)cache).build();
        try {
            resolver.resolve("test").syncUninterruptibly();
            Assert.assertNull(cache.cacheHits.get("test.netty.io"));
            List cached = cache.cache.get("test.netty.io", null);
            List cached2 = cache.cache.get("test.netty.io.", null);
            Assert.assertEquals((long)1L, (long)cached.size());
            Assert.assertSame((Object)cached, (Object)cached2);
            resolver.resolve("test").syncUninterruptibly();
            List<? extends DnsCacheEntry> entries = cache.cacheHits.get("test.netty.io");
            Assert.assertFalse((boolean)entries.isEmpty());
        }
        finally {
            resolver.close();
            server.stop();
        }
    }

    @Test
    public void testChannelFactoryException() {
        final IllegalStateException exception = new IllegalStateException();
        try {
            DnsNameResolverTest.newResolver().channelFactory((ChannelFactory)new ChannelFactory<DatagramChannel>(){

                public DatagramChannel newChannel() {
                    throw exception;
                }
            }).build();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertSame((Object)exception, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCNameCached() throws Exception {
        final ConcurrentHashMap cache = new ConcurrentHashMap();
        final AtomicInteger cnameQueries = new AtomicInteger();
        final AtomicInteger aQueries = new AtomicInteger();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                if ("cname.netty.io".equals(question.getDomainName())) {
                    aQueries.incrementAndGet();
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "10.0.0.99")));
                }
                if ("x.netty.io".equals(question.getDomainName())) {
                    cnameQueries.incrementAndGet();
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname.netty.io")));
                }
                if ("y.netty.io".equals(question.getDomainName())) {
                    cnameQueries.incrementAndGet();
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "x.netty.io")));
                }
                return Collections.emptySet();
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().recursionDesired(true).resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress())).resolveCache((DnsCache)NoopDnsCache.INSTANCE).cnameCache(new DnsCnameCache(){

                public String get(String hostname) {
                    Assert.assertTrue((String)hostname, (boolean)hostname.endsWith("."));
                    return (String)cache.get(hostname);
                }

                public void cache(String hostname, String cname, long originalTtl, EventLoop loop) {
                    Assert.assertTrue((String)hostname, (boolean)hostname.endsWith("."));
                    cache.put(hostname, cname);
                }

                public void clear() {
                }

                public boolean clear(String hostname) {
                    return false;
                }
            });
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll("x.netty.io").syncUninterruptibly().getNow();
            Assert.assertEquals((long)1L, (long)resolvedAddresses.size());
            Assert.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assert.assertEquals((Object)"cname.netty.io.", cache.get("x.netty.io."));
            Assert.assertEquals((long)1L, (long)cnameQueries.get());
            Assert.assertEquals((long)1L, (long)aQueries.get());
            resolvedAddresses = (List)resolver.resolveAll("x.netty.io").syncUninterruptibly().getNow();
            Assert.assertEquals((long)1L, (long)resolvedAddresses.size());
            Assert.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assert.assertEquals((long)1L, (long)cnameQueries.get());
            Assert.assertEquals((long)2L, (long)aQueries.get());
            resolvedAddresses = (List)resolver.resolveAll("y.netty.io").syncUninterruptibly().getNow();
            Assert.assertEquals((long)1L, (long)resolvedAddresses.size());
            Assert.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assert.assertEquals((Object)"x.netty.io.", cache.get("y.netty.io."));
            Assert.assertEquals((long)2L, (long)cnameQueries.get());
            Assert.assertEquals((long)3L, (long)aQueries.get());
            resolvedAddresses = (List)resolver.resolveAll("y.netty.io").syncUninterruptibly().getNow();
            Assert.assertEquals((long)1L, (long)resolvedAddresses.size());
            Assert.assertTrue((boolean)resolvedAddresses.contains(InetAddress.getByAddress(new byte[]{10, 0, 0, 99})));
            Assert.assertEquals((long)2L, (long)cnameQueries.get());
            Assert.assertEquals((long)4L, (long)aQueries.get());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @Test
    public void testInstanceWithNullPreferredAddressType() {
        new DnsNameResolver(group.next(), (ChannelFactory)new ReflectiveChannelFactory(NioDatagramChannel.class), (DnsCache)NoopDnsCache.INSTANCE, (AuthoritativeDnsServerCache)NoopAuthoritativeDnsServerCache.INSTANCE, (DnsQueryLifecycleObserverFactory)NoopDnsQueryLifecycleObserverFactory.INSTANCE, 100L, null, true, 1, false, 4096, true, HostsFileEntriesResolver.DEFAULT, DnsServerAddressStreamProviders.platformDefault(), null, 1, true).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryTxt() throws Exception {
        String hostname = "txt.netty.io";
        String txt1 = "some text";
        String txt2 = "some more text";
        TestDnsServer server = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                if (question.getDomainName().equals("txt.netty.io")) {
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    map1.put("apacheDnsCharacterString".toLowerCase(), "some text");
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    map2.put("apacheDnsCharacterString".toLowerCase(), "some more text");
                    HashSet<ResourceRecord> records = new HashSet<ResourceRecord>();
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.TXT, map1));
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(question.getDomainName(), RecordType.TXT, map2));
                    return records;
                }
                return Collections.emptySet();
            }
        });
        server.start();
        DnsNameResolver resolver = DnsNameResolverTest.newResolver(ResolvedAddressTypes.IPV4_ONLY).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(server.localAddress())).build();
        try {
            AddressedEnvelope envelope = (AddressedEnvelope)resolver.query((DnsQuestion)new DefaultDnsQuestion("txt.netty.io", DnsRecordType.TXT)).syncUninterruptibly().getNow();
            Assert.assertNotNull((Object)envelope.sender());
            DnsResponse response = (DnsResponse)envelope.content();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)DnsResponseCode.NOERROR, (Object)response.code());
            int count = response.count(DnsSection.ANSWER);
            Assert.assertEquals((long)2L, (long)count);
            ArrayList<String> txts = new ArrayList<String>();
            for (int i = 0; i < 2; ++i) {
                txts.addAll(DnsNameResolverTest.decodeTxt(response.recordAt(DnsSection.ANSWER, i)));
            }
            Assert.assertTrue((boolean)txts.contains("some text"));
            Assert.assertTrue((boolean)txts.contains("some more text"));
            envelope.release();
        }
        finally {
            resolver.close();
            server.stop();
        }
    }

    private static List<String> decodeTxt(DnsRecord record) {
        short len;
        if (!(record instanceof DnsRawRecord)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        ByteBuf data = ((DnsRawRecord)record).content();
        int wIdx = data.writerIndex();
        for (int idx = data.readerIndex(); idx < wIdx; idx += len) {
            len = data.getUnsignedByte(idx++);
            list.add(data.toString(idx, (int)len, CharsetUtil.UTF_8));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotIncludeDuplicates() throws IOException {
        String name = "netty.io";
        String ipv4Addr = "1.2.3.4";
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(4);
                String qName = question.getDomainName().toLowerCase();
                if (qName.equals("netty.io")) {
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.CNAME, Collections.singletonMap("apacheDnsDomainName".toLowerCase(), "cname.netty.io")));
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "1.2.3.4")));
                } else {
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "1.2.3.4")));
                }
                return records;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().recursionDesired(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            builder.resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY);
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll("netty.io").syncUninterruptibly().getNow();
            Assert.assertEquals(Collections.singletonList(InetAddress.getByAddress("netty.io", new byte[]{1, 2, 3, 4})), (Object)resolvedAddresses);
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncludeDuplicates() throws IOException {
        String name = "netty.io";
        String ipv4Addr = "1.2.3.4";
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                LinkedHashSet<ResourceRecord> records = new LinkedHashSet<ResourceRecord>(2);
                String qName = question.getDomainName().toLowerCase();
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "1.2.3.4")));
                records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(qName, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "1.2.3.4")));
                return records;
            }
        });
        dnsServer2.start();
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().recursionDesired(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            builder.resolvedAddressTypes(ResolvedAddressTypes.IPV4_ONLY);
            resolver = builder.build();
            List resolvedAddresses = (List)resolver.resolveAll((DnsQuestion)new DefaultDnsQuestion("netty.io", DnsRecordType.A)).syncUninterruptibly().getNow();
            Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
            for (DnsRecord record : resolvedAddresses) {
                ReferenceCountUtil.release((Object)record);
            }
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropAAAA() throws IOException {
        String host = "somehost.netty.io";
        TestDnsServer dnsServer2 = new TestDnsServer(Collections.singleton(host));
        dnsServer2.start(true);
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().recursionDesired(false).queryTimeoutMillis(500L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            List addressList = (List)resolver.resolveAll(host).syncUninterruptibly().getNow();
            Assert.assertEquals((long)1L, (long)addressList.size());
            Assert.assertEquals((Object)host, (Object)((InetAddress)addressList.get(0)).getHostName());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=2000L)
    public void testDropAAAAResolveFast() throws IOException {
        String host = "somehost.netty.io";
        TestDnsServer dnsServer2 = new TestDnsServer(Collections.singleton(host));
        dnsServer2.start(true);
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().recursionDesired(false).queryTimeoutMillis(10000L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            InetAddress address = (InetAddress)resolver.resolve(host).syncUninterruptibly().getNow();
            Assert.assertEquals((Object)host, (Object)address.getHostName());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=2000L)
    public void testDropAAAAResolveAllFast() throws IOException {
        String host = "somehost.netty.io";
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
                String name = question.getDomainName();
                if (name.equals("somehost.netty.io")) {
                    HashSet<ResourceRecord> records = new HashSet<ResourceRecord>(2);
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(name, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "10.0.0.1")));
                    records.add((ResourceRecord)new TestDnsServer.TestResourceRecord(name, RecordType.A, Collections.singletonMap("apacheDnsIpAddress".toLowerCase(), "10.0.0.2")));
                    return records;
                }
                return null;
            }
        });
        dnsServer2.start(true);
        DnsNameResolver resolver = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().recursionDesired(false).queryTimeoutMillis(10000L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).completeOncePreferredResolved(true).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            resolver = builder.build();
            List addresses = (List)resolver.resolveAll("somehost.netty.io").syncUninterruptibly().getNow();
            Assert.assertEquals((long)2L, (long)addresses.size());
            for (InetAddress address : addresses) {
                Assert.assertThat((Object)address, (Matcher)Matchers.instanceOf(Inet4Address.class));
                Assert.assertEquals((Object)"somehost.netty.io", (Object)address.getHostName());
            }
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    @Test(timeout=5000L)
    public void testTruncatedWithoutTcpFallback() throws IOException {
        DnsNameResolverTest.testTruncated0(false, false);
    }

    @Test(timeout=5000L)
    public void testTruncatedWithTcpFallback() throws IOException {
        DnsNameResolverTest.testTruncated0(true, false);
    }

    @Test(timeout=5000L)
    public void testTruncatedWithTcpFallbackBecauseOfMtu() throws IOException {
        DnsNameResolverTest.testTruncated0(true, true);
    }

    private static DnsMessageModifier modifierFrom(DnsMessage message) {
        DnsMessageModifier modifier = new DnsMessageModifier();
        modifier.setAcceptNonAuthenticatedData(message.isAcceptNonAuthenticatedData());
        modifier.setAdditionalRecords(message.getAdditionalRecords());
        modifier.setAnswerRecords(message.getAnswerRecords());
        modifier.setAuthoritativeAnswer(message.isAuthoritativeAnswer());
        modifier.setAuthorityRecords(message.getAuthorityRecords());
        modifier.setMessageType(message.getMessageType());
        modifier.setOpCode(message.getOpCode());
        modifier.setQuestionRecords(message.getQuestionRecords());
        modifier.setRecursionAvailable(message.isRecursionAvailable());
        modifier.setRecursionDesired(message.isRecursionDesired());
        modifier.setReserved(message.isReserved());
        modifier.setResponseCode(message.getResponseCode());
        modifier.setTransactionId(message.getTransactionId());
        modifier.setTruncated(message.isTruncated());
        return modifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testTruncated0(boolean tcpFallback, final boolean truncatedBecauseOfMtu) throws IOException {
        String host = "somehost.netty.io";
        String txt = "this is a txt record";
        final AtomicReference messageRef = new AtomicReference();
        TestDnsServer dnsServer2 = new TestDnsServer(new RecordStore(){

            public Set<ResourceRecord> getRecords(QuestionRecord question) {
                String name = question.getDomainName();
                if (name.equals("somehost.netty.io")) {
                    return Collections.singleton(new TestDnsServer.TestResourceRecord(name, RecordType.TXT, Collections.singletonMap("apacheDnsCharacterString".toLowerCase(), "this is a txt record")));
                }
                return null;
            }
        }){

            @Override
            protected DnsMessage filterMessage(DnsMessage message) {
                messageRef.set(message);
                if (!truncatedBecauseOfMtu) {
                    DnsMessageModifier modifier = DnsNameResolverTest.modifierFrom(message);
                    modifier.setTruncated(true);
                    return modifier.getDnsMessage();
                }
                return message;
            }
        };
        dnsServer2.start();
        DnsNameResolver resolver = null;
        ServerSocket serverSocket = null;
        try {
            DnsNameResolverBuilder builder = DnsNameResolverTest.newResolver().queryTimeoutMillis(10000L).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).maxQueriesPerResolve(16).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(dnsServer2.localAddress()));
            if (tcpFallback) {
                serverSocket = new ServerSocket(dnsServer2.localAddress().getPort());
                serverSocket.setReuseAddress(true);
                builder.socketChannelType(NioSocketChannel.class);
            }
            resolver = builder.build();
            if (truncatedBecauseOfMtu) {
                resolver.ch.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        if (msg instanceof DatagramPacket) {
                            DatagramPacket packet = (DatagramPacket)msg;
                            ((ByteBuf)packet.content()).writerIndex(((ByteBuf)packet.content()).writerIndex() - 1);
                        }
                        ctx.fireChannelRead(msg);
                    }
                }});
            }
            Future envelopeFuture = resolver.query((DnsQuestion)new DefaultDnsQuestion("somehost.netty.io", DnsRecordType.TXT));
            if (tcpFallback) {
                Socket socket = serverSocket.accept();
                InputStream in = socket.getInputStream();
                Assert.assertTrue(((in.read() << 8 | in.read() & 0xFF) > 2 ? 1 : 0) != 0);
                int txnId = in.read() << 8 | in.read() & 0xFF;
                IoBuffer ioBuffer = IoBuffer.allocate((int)1024);
                DnsMessageModifier modifier = DnsNameResolverTest.modifierFrom((DnsMessage)messageRef.get());
                modifier.setTransactionId(txnId);
                new DnsMessageEncoder().encode(ioBuffer, modifier.getDnsMessage());
                ioBuffer.flip();
                ByteBuffer lenBuffer = ByteBuffer.allocate(2);
                lenBuffer.putShort((short)ioBuffer.remaining());
                lenBuffer.flip();
                while (lenBuffer.hasRemaining()) {
                    socket.getOutputStream().write(lenBuffer.get());
                }
                while (ioBuffer.hasRemaining()) {
                    socket.getOutputStream().write(ioBuffer.get());
                }
                socket.getOutputStream().flush();
                envelopeFuture.syncUninterruptibly();
                socket.close();
                serverSocket.close();
            }
            AddressedEnvelope envelope = (AddressedEnvelope)envelopeFuture.syncUninterruptibly().getNow();
            Assert.assertNotNull((Object)envelope.sender());
            DnsResponse response = (DnsResponse)envelope.content();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((Object)DnsResponseCode.NOERROR, (Object)response.code());
            int count = response.count(DnsSection.ANSWER);
            Assert.assertEquals((long)1L, (long)count);
            List<String> texts = DnsNameResolverTest.decodeTxt(response.recordAt(DnsSection.ANSWER, 0));
            Assert.assertEquals((long)1L, (long)texts.size());
            Assert.assertEquals((Object)"this is a txt record", (Object)texts.get(0));
            if (tcpFallback) {
                Assert.assertFalse((boolean)((DnsResponse)envelope.content()).isTruncated());
            } else {
                Assert.assertTrue((boolean)((DnsResponse)envelope.content()).isTruncated());
            }
            Assert.assertTrue((boolean)envelope.release());
        }
        finally {
            dnsServer2.stop();
            if (resolver != null) {
                resolver.close();
            }
        }
    }

    static {
        DOMAINS_PUNYCODE.put("b\u00fcchner.de", "xn--bchner-3ya.de");
        DOMAINS_PUNYCODE.put("m\u00fcller.de", "xn--mller-kva.de");
        HashSet<String> all = new HashSet<String>(DOMAINS.size() + DOMAINS_PUNYCODE.size());
        all.addAll(DOMAINS);
        all.addAll(DOMAINS_PUNYCODE.values());
        DOMAINS_ALL = Collections.unmodifiableSet(all);
        EXCLUSIONS_RESOLVE_A = new HashSet<String>();
        Collections.addAll(EXCLUSIONS_RESOLVE_A, "akamaihd.net", "googleusercontent.com", "");
        EXCLUSIONS_RESOLVE_AAAA = new HashSet<String>();
        EXCLUSIONS_RESOLVE_AAAA.addAll(EXCLUSIONS_RESOLVE_A);
        EXCLUSIONS_RESOLVE_AAAA.addAll(DOMAINS);
        EXCLUSIONS_RESOLVE_AAAA.removeAll(Arrays.asList("google.com", "facebook.com", "youtube.com", "wikipedia.org", "google.co.in", "blogspot.com", "vk.com", "google.de", "google.co.jp", "google.co.uk", "google.fr", "google.com.br", "google.ru", "google.it", "google.es", "google.com.mx", "xhamster.com", "google.ca", "google.co.id", "blogger.com", "flipkart.com", "google.com.tr", "google.com.au", "google.pl", "google.com.hk", "blogspot.in"));
        EXCLUSIONS_QUERY_MX = new HashSet<String>();
        Collections.addAll(EXCLUSIONS_QUERY_MX, "hao123.com", "blogspot.com", "t.co", "espn.go.com", "people.com.cn", "googleusercontent.com", "blogspot.in", "localhost", "");
        dnsServer = new TestDnsServer(DOMAINS_ALL);
        group = new NioEventLoopGroup(1);
    }

    private static class RedirectingTestDnsServer
    extends TestDnsServer {
        private final String dnsAddress;
        private final String domain;

        RedirectingTestDnsServer(String domain, String dnsAddress) {
            super(Collections.singleton(domain));
            this.domain = domain;
            this.dnsAddress = dnsAddress;
        }

        @Override
        protected DnsMessage filterMessage(DnsMessage message) {
            int idx;
            message.getAnswerRecords().clear();
            message.getAuthorityRecords().clear();
            message.getAdditionalRecords().clear();
            String name = this.domain;
            int i = 0;
            while ((idx = name.indexOf(46)) > 0) {
                name = name.substring(idx + 1);
                String dnsName = "dns" + idx + '.' + this.domain;
                message.getAuthorityRecords().add(RedirectingTestDnsServer.newNsRecord(name, dnsName));
                message.getAdditionalRecords().add(RedirectingTestDnsServer.newARecord(dnsName, i == 0 ? this.dnsAddress : "1.2.3." + idx));
                message.getAuthorityRecords().add(RedirectingTestDnsServer.newNsRecord(name, "unresolved." + dnsName));
                ++i;
            }
            return message;
        }
    }

    private static final class TestDnsCache
    implements DnsCache {
        final DnsCache cache;
        final Map<String, List<? extends DnsCacheEntry>> cacheHits = new HashMap<String, List<? extends DnsCacheEntry>>();

        TestDnsCache(DnsCache cache) {
            this.cache = cache;
        }

        public void clear() {
            this.cache.clear();
        }

        public boolean clear(String hostname) {
            return this.cache.clear(hostname);
        }

        public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
            List cached = this.cache.get(hostname, additionals);
            this.cacheHits.put(hostname, cached);
            return cached;
        }

        public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, InetAddress address, long originalTtl, EventLoop loop) {
            return this.cache.cache(hostname, additionals, address, originalTtl, loop);
        }

        public DnsCacheEntry cache(String hostname, DnsRecord[] additionals, Throwable cause, EventLoop loop) {
            return this.cache.cache(hostname, additionals, cause, loop);
        }
    }

    private static final class TestAuthoritativeDnsServerCache
    implements AuthoritativeDnsServerCache {
        final AuthoritativeDnsServerCache cache;
        final Map<String, DnsServerAddressStream> cacheHits = new HashMap<String, DnsServerAddressStream>();

        TestAuthoritativeDnsServerCache(AuthoritativeDnsServerCache cache) {
            this.cache = cache;
        }

        public void clear() {
            this.cache.clear();
        }

        public boolean clear(String hostname) {
            return this.cache.clear(hostname);
        }

        public DnsServerAddressStream get(String hostname) {
            DnsServerAddressStream cached = this.cache.get(hostname);
            if (cached != null) {
                this.cacheHits.put(hostname, cached.duplicate());
            }
            return cached;
        }

        public void cache(String hostname, InetSocketAddress address, long originalTtl, EventLoop loop) {
            this.cache.cache(hostname, address, originalTtl, loop);
        }
    }

    private static final class TestDnsQueryLifecycleObserver
    implements DnsQueryLifecycleObserver {
        final Queue<Object> events = new ArrayDeque<Object>();
        final DnsQuestion question;

        TestDnsQueryLifecycleObserver(DnsQuestion question) {
            this.question = question;
        }

        public void queryWritten(InetSocketAddress dnsServerAddress, ChannelFuture future) {
            this.events.add(new QueryWrittenEvent(dnsServerAddress));
        }

        public void queryCancelled(int queriesRemaining) {
            this.events.add(new QueryCancelledEvent(queriesRemaining));
        }

        public DnsQueryLifecycleObserver queryRedirected(List<InetSocketAddress> nameServers) {
            this.events.add(new QueryRedirectedEvent(nameServers));
            return this;
        }

        public DnsQueryLifecycleObserver queryCNAMEd(DnsQuestion cnameQuestion) {
            this.events.add(new QueryCnamedEvent(cnameQuestion));
            return this;
        }

        public DnsQueryLifecycleObserver queryNoAnswer(DnsResponseCode code) {
            this.events.add(new QueryNoAnswerEvent(code));
            return this;
        }

        public void queryFailed(Throwable cause) {
            this.events.add(new QueryFailedEvent(cause));
        }

        public void querySucceed() {
            this.events.add(new QuerySucceededEvent());
        }
    }

    private static final class QuerySucceededEvent {
        private QuerySucceededEvent() {
        }
    }

    private static final class QueryFailedEvent {
        final Throwable cause;

        QueryFailedEvent(Throwable cause) {
            this.cause = cause;
        }
    }

    private static final class QueryNoAnswerEvent {
        final DnsResponseCode code;

        QueryNoAnswerEvent(DnsResponseCode code) {
            this.code = code;
        }
    }

    private static final class QueryCnamedEvent {
        final DnsQuestion question;

        QueryCnamedEvent(DnsQuestion question) {
            this.question = question;
        }
    }

    private static final class QueryRedirectedEvent {
        final List<InetSocketAddress> nameServers;

        QueryRedirectedEvent(List<InetSocketAddress> nameServers) {
            this.nameServers = nameServers;
        }
    }

    private static final class QueryCancelledEvent {
        final int queriesRemaining;

        QueryCancelledEvent(int queriesRemaining) {
            this.queriesRemaining = queriesRemaining;
        }
    }

    private static final class QueryWrittenEvent {
        final InetSocketAddress dnsServerAddress;

        QueryWrittenEvent(InetSocketAddress dnsServerAddress) {
            this.dnsServerAddress = dnsServerAddress;
        }
    }

    private static final class TestRecursiveCacheDnsQueryLifecycleObserverFactory
    implements DnsQueryLifecycleObserverFactory {
        final Queue<TestDnsQueryLifecycleObserver> observers = new ConcurrentLinkedQueue<TestDnsQueryLifecycleObserver>();

        private TestRecursiveCacheDnsQueryLifecycleObserverFactory() {
        }

        public DnsQueryLifecycleObserver newDnsQueryLifecycleObserver(DnsQuestion question) {
            TestDnsQueryLifecycleObserver observer = new TestDnsQueryLifecycleObserver(question);
            this.observers.add(observer);
            return observer;
        }
    }
}

