/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class DecoderULE128Benchmark
extends AbstractMicrobenchmark {
    private static final Http2Exception DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION = new Http2Exception(Http2Error.COMPRESSION_ERROR);
    private static final Http2Exception DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION = new Http2Exception(Http2Error.COMPRESSION_ERROR);
    private static final Http2Exception DECODE_ULE_128_DECOMPRESSION_EXCEPTION = new Http2Exception(Http2Error.COMPRESSION_ERROR);
    private ByteBuf longMaxBuf;
    private ByteBuf intMaxBuf;

    @Setup
    public void setup() {
        byte[] longMax = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 127};
        this.longMaxBuf = Unpooled.wrappedBuffer((byte[])longMax);
        byte[] intMax = new byte[]{-1, -1, -1, -1, 7};
        this.intMaxBuf = Unpooled.wrappedBuffer((byte[])intMax);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public long decodeMaxLong() throws Http2Exception {
        long v = DecoderULE128Benchmark.decodeULE128(this.longMaxBuf, 0L);
        this.longMaxBuf.readerIndex(0);
        return v;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public long decodeMaxIntWithLong() throws Http2Exception {
        long v = DecoderULE128Benchmark.decodeULE128(this.intMaxBuf, 0L);
        this.intMaxBuf.readerIndex(0);
        return v;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int decodeMaxInt() throws Http2Exception {
        int v = DecoderULE128Benchmark.decodeULE128(this.intMaxBuf, 0);
        this.intMaxBuf.readerIndex(0);
        return v;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public int decodeMaxIntUsingLong() throws Http2Exception {
        int v = DecoderULE128Benchmark.decodeULE128UsingLong(this.intMaxBuf, 0);
        this.intMaxBuf.readerIndex(0);
        return v;
    }

    static int decodeULE128UsingLong(ByteBuf in, int result) throws Http2Exception {
        int readerIndex = in.readerIndex();
        long v = DecoderULE128Benchmark.decodeULE128(in, (long)result);
        if (v > Integer.MAX_VALUE) {
            in.readerIndex(readerIndex);
            throw DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION;
        }
        return (int)v;
    }

    static long decodeULE128(ByteBuf in, long result) throws Http2Exception {
        assert (result <= 127L && result >= 0L);
        boolean resultStartedAtZero = result == 0L;
        int writerIndex = in.writerIndex();
        int readerIndex = in.readerIndex();
        int shift = 0;
        while (readerIndex < writerIndex) {
            byte b = in.getByte(readerIndex);
            if (shift == 56 && ((b & 0x80) != 0 || b == 127 && !resultStartedAtZero)) {
                throw DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION;
            }
            if ((b & 0x80) == 0) {
                in.readerIndex(readerIndex + 1);
                return result + (((long)b & 0x7FL) << shift);
            }
            result += ((long)b & 0x7FL) << shift;
            ++readerIndex;
            shift += 7;
        }
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }

    static int decodeULE128(ByteBuf in, int result) throws Http2Exception {
        assert (result <= 127 && result >= 0);
        boolean resultStartedAtZero = result == 0;
        int writerIndex = in.writerIndex();
        int readerIndex = in.readerIndex();
        int shift = 0;
        while (readerIndex < writerIndex) {
            byte b = in.getByte(readerIndex);
            if (shift == 28 && ((b & 0x80) != 0 || !resultStartedAtZero && b > 6 || resultStartedAtZero && b > 7)) {
                throw DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION;
            }
            if ((b & 0x80) == 0) {
                in.readerIndex(readerIndex + 1);
                return result + ((b & 0x7F) << shift);
            }
            result += (b & 0x7F) << shift;
            ++readerIndex;
            shift += 7;
        }
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }
}

