/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

public abstract class EmbeddedChannelWriteReleaseHandlerContext
implements ChannelHandlerContext {
    private static final String HANDLER_NAME = "microbench-delegator-ctx";
    private final EventLoop eventLoop;
    private final Channel channel;
    private final ByteBufAllocator alloc;
    private final ChannelHandler handler;
    private SocketAddress localAddress;

    public EmbeddedChannelWriteReleaseHandlerContext(ByteBufAllocator alloc, ChannelHandler handler) {
        this(alloc, handler, new EmbeddedChannel());
    }

    public EmbeddedChannelWriteReleaseHandlerContext(ByteBufAllocator alloc, ChannelHandler handler, EmbeddedChannel channel) {
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)alloc, (String)"alloc");
        this.channel = (Channel)ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        this.handler = (ChannelHandler)ObjectUtil.checkNotNull((Object)handler, (String)"handler");
        this.eventLoop = (EventLoop)ObjectUtil.checkNotNull((Object)channel.eventLoop(), (String)"eventLoop");
    }

    protected abstract void handleException(Throwable var1);

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return null;
    }

    public <T> boolean hasAttr(AttributeKey<T> key) {
        return false;
    }

    public Channel channel() {
        return this.channel;
    }

    public EventExecutor executor() {
        return this.eventLoop;
    }

    public String name() {
        return HANDLER_NAME;
    }

    public ChannelHandler handler() {
        return this.handler;
    }

    public boolean isRemoved() {
        return false;
    }

    public ChannelHandlerContext fireChannelRegistered() {
        return this;
    }

    public ChannelHandlerContext fireChannelUnregistered() {
        return this;
    }

    public ChannelHandlerContext fireChannelActive() {
        return this;
    }

    public ChannelHandlerContext fireChannelInactive() {
        return this;
    }

    public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        try {
            this.handler().exceptionCaught((ChannelHandlerContext)this, cause);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    public ChannelHandlerContext fireUserEventTriggered(Object event) {
        return this;
    }

    public ChannelHandlerContext fireChannelRead(Object msg) {
        return this;
    }

    public ChannelHandlerContext fireChannelReadComplete() {
        return this;
    }

    public ChannelHandlerContext fireChannelWritabilityChanged() {
        return this;
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newPromise());
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.newPromise());
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.newPromise());
    }

    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    public ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        try {
            this.channel().bind(localAddress, promise);
            this.localAddress = localAddress;
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        try {
            this.channel().connect(remoteAddress, this.localAddress, promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        try {
            this.channel().connect(remoteAddress, localAddress, promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public ChannelFuture disconnect(ChannelPromise promise) {
        try {
            this.channel().disconnect(promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public ChannelFuture close(ChannelPromise promise) {
        try {
            this.channel().close(promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public ChannelFuture deregister(ChannelPromise promise) {
        try {
            this.channel().deregister(promise);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public ChannelHandlerContext read() {
        try {
            this.channel().read();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }

    public ChannelFuture write(Object msg) {
        return this.write(msg, this.newPromise());
    }

    public ChannelFuture write(Object msg, ChannelPromise promise) {
        try {
            if (msg instanceof ReferenceCounted) {
                ((ReferenceCounted)msg).release();
                promise.setSuccess();
            } else {
                this.channel().write(msg, promise);
            }
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            this.handleException(e);
        }
        return promise;
    }

    public ChannelHandlerContext flush() {
        this.channel().flush();
        return this;
    }

    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        return this.channel().writeAndFlush(msg, promise);
    }

    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }

    public ChannelPipeline pipeline() {
        return this.channel().pipeline();
    }

    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    public ChannelPromise newPromise() {
        return this.channel().newPromise();
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return this.channel().newProgressivePromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.channel().newSucceededFuture();
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return this.channel().newFailedFuture(cause);
    }

    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }
}

