/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.internal.hpack;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.microbench.http2.internal.hpack.Header;
import io.netty.microbench.http2.internal.hpack.HeadersSize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Util {
    private static final Map<HeadersKey, List<Header>> headersMap;

    private Util() {
    }

    static List<Header> headers(HeadersSize size, boolean limitToAscii) {
        return headersMap.get(new HeadersKey(size, limitToAscii));
    }

    static Http2Headers http2Headers(HeadersSize size, boolean limitToAscii) {
        List<Header> headers = headersMap.get(new HeadersKey(size, limitToAscii));
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < headers.size(); ++i) {
            Header header = headers.get(i);
            http2Headers.add((Object)header.name, (Object)header.value);
        }
        return http2Headers;
    }

    static {
        HeadersSize[] sizes = HeadersSize.values();
        headersMap = new HashMap<HeadersKey, List<Header>>(sizes.length * 2);
        for (HeadersSize size : sizes) {
            HeadersKey key = new HeadersKey(size, true);
            headersMap.put(key, key.newHeaders());
            key = new HeadersKey(size, false);
            headersMap.put(key, key.newHeaders());
        }
    }

    private static class HeadersKey {
        final HeadersSize size;
        final boolean limitToAscii;

        public HeadersKey(HeadersSize size, boolean limitToAscii) {
            this.size = size;
            this.limitToAscii = limitToAscii;
        }

        List<Header> newHeaders() {
            return this.size.newHeaders(this.limitToAscii);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HeadersKey that = (HeadersKey)o;
            if (this.limitToAscii != that.limitToAscii) {
                return false;
            }
            return this.size == that.size;
        }

        public int hashCode() {
            int result = this.size.hashCode();
            result = 31 * result + (this.limitToAscii ? 1 : 0);
            return result;
        }
    }
}

