/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.microbench.http2.internal.hpack.Header;
import java.util.List;

public enum HeadersSize {
    SMALL(5, 20, 40),
    MEDIUM(20, 40, 80),
    LARGE(100, 100, 300);

    private final int numHeaders;
    private final int nameLength;
    private final int valueLength;

    private HeadersSize(int numHeaders, int nameLength, int valueLength) {
        this.numHeaders = numHeaders;
        this.nameLength = nameLength;
        this.valueLength = valueLength;
    }

    public List<Header> newHeaders(boolean limitAscii) {
        return Header.createHeaders(this.numHeaders, this.nameLength, this.valueLength, limitAscii);
    }

    public ByteBuf newOutBuffer() {
        return Unpooled.buffer((int)(this.numHeaders * (this.nameLength + this.valueLength)));
    }
}

